/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoExecutionUnit;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoFindings;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoIssues;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoLineCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoMetricSchemaChange;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoMultiFileRangeCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoProbeCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoProcessStepInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoSpecItems;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoTestExecution;
import com.teamscale.index.external.input.info.ExternalAnalysisSimulinkCodeGenerationTraceInfo;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.report.result.processor.ExternalAnalysisMetricSchemaChangeProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultExecutionUnitProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultFindingsProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultIssuesProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultLineCoverageProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultMultiFileRangeCoverageProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProbeCoverageProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessStepInfoProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultSpecItemProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultTestExecutionProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisSimulinkCodeGenerationTracesProcessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ExternalAnalysisResultProcessorManager {
    @StepParameterObject
    private final ExternalAnalysisResultExecutionUnitProcessor executionUnitResultProcessor = new ExternalAnalysisResultExecutionUnitProcessor();
    @StepParameterObject
    private final ExternalAnalysisResultTestExecutionProcessor testExecutionResultProcessor = new ExternalAnalysisResultTestExecutionProcessor();
    @StepParameterObject
    private final ExternalAnalysisResultMultiFileRangeCoverageProcessor coverageUnitResultProcessor = new ExternalAnalysisResultMultiFileRangeCoverageProcessor();
    @StepParameterObject
    private final ExternalAnalysisResultLineCoverageProcessor lineCoverageProcessor = new ExternalAnalysisResultLineCoverageProcessor();
    @StepParameterObject
    private final ExternalAnalysisResultProbeCoverageProcessor probeCoverageProcessor = new ExternalAnalysisResultProbeCoverageProcessor();
    @StepParameterObject
    private final ExternalAnalysisResultFindingsProcessor findingsProcessor = new ExternalAnalysisResultFindingsProcessor();
    @StepParameterObject
    private final ExternalAnalysisResultProcessStepInfoProcessor processStepProcessor = new ExternalAnalysisResultProcessStepInfoProcessor();
    @StepParameterObject
    private final ExternalAnalysisResultIssuesProcessor issuesProcessor = new ExternalAnalysisResultIssuesProcessor();
    @StepParameterObject
    private final ExternalAnalysisResultSpecItemProcessor specItemsProcessor = new ExternalAnalysisResultSpecItemProcessor();
    @StepParameterObject
    private final ExternalAnalysisSimulinkCodeGenerationTracesProcessor simulinkCodeGenerationTracesProcessor = new ExternalAnalysisSimulinkCodeGenerationTracesProcessor();
    @StepParameterObject
    private final ExternalAnalysisMetricSchemaChangeProcessor metricSchemaChangeProcessor = new ExternalAnalysisMetricSchemaChangeProcessor();
    private final Map<Class<? extends ExternalAnalysisImportInfo<?>>, ExternalAnalysisResultProcessorBase<?>> processorsByImportInfoClass = new HashMap();

    public ExternalAnalysisResultProcessorManager() {
        this.register(ExternalAnalysisImportInfoExecutionUnit.class, this.executionUnitResultProcessor);
        this.register(ExternalAnalysisImportInfoTestExecution.class, this.testExecutionResultProcessor);
        this.register(ExternalAnalysisImportInfoMultiFileRangeCoverage.class, this.coverageUnitResultProcessor);
        this.register(ExternalAnalysisImportInfoLineCoverage.class, this.lineCoverageProcessor);
        this.register(ExternalAnalysisImportInfoProbeCoverage.class, this.probeCoverageProcessor);
        this.register(ExternalAnalysisImportInfoProcessStepInfo.class, this.processStepProcessor);
        this.register(ExternalAnalysisImportInfoIssues.class, this.issuesProcessor);
        this.register(ExternalAnalysisImportInfoSpecItems.class, this.specItemsProcessor);
        this.register(ExternalAnalysisSimulinkCodeGenerationTraceInfo.class, this.simulinkCodeGenerationTracesProcessor);
        this.register(ExternalAnalysisImportInfoMetricSchemaChange.class, this.metricSchemaChangeProcessor);
        this.registerUnsafe(ExternalAnalysisImportInfoFindings.class, this.findingsProcessor);
    }

    public <T, R extends ExternalAnalysisResult<T>, I extends ExternalAnalysisImportInfo<T>> void register(Class<I> importInfoClass, ExternalAnalysisResultProcessorBase<R> processor) {
        this.registerUnsafe(importInfoClass, processor);
    }

    private <T, R extends ExternalAnalysisResult<T>, I extends ExternalAnalysisImportInfo<?>> void registerUnsafe(Class<I> importInfoClass, ExternalAnalysisResultProcessorBase<R> processor) {
        this.processorsByImportInfoClass.put(importInfoClass, processor);
    }

    public Set<Class<? extends ExternalAnalysisImportInfo<?>>> getSupportedExternalAnalysisImportInfoClasses() {
        return this.processorsByImportInfoClass.keySet();
    }

    public ExternalAnalysisResultProcessorBase getProcessorForImportClass(Class<? extends ExternalAnalysisImportInfo> infoClass) {
        ExternalAnalysisResultProcessorBase<?> processor = this.processorsByImportInfoClass.get(infoClass);
        CCSMAssert.isNotNull(processor, () -> "No processor for info of type " + infoClass.getName() + " registered!");
        return processor;
    }

    public Collection<ExternalAnalysisResultProcessorBase<?>> getAllProcessors() {
        return this.processorsByImportInfoClass.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAll(CommitDescriptor schedulingCommit) throws StorageException {
        Collection<ExternalAnalysisResultProcessorBase<?>> processors = this.getAllProcessors();
        try {
            for (ExternalAnalysisResultProcessorBase<?> processor : processors) {
                processor.persist(schedulingCommit);
            }
        }
        finally {
            processors.forEach(ExternalAnalysisResultProcessorBase::reset);
        }
    }
}

