/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.TokenElementIndex;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;

public class ChangeMetricsSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String LAST_CHANGED_METRICS_INDEX_PARTITION = "last-changed";
    public static final String CHANGE_COUNT_METRICS_INDEX_PARTITION = "change-count";
    @IndexAccess.Named(mode=EIndexAccessMode.READ_WRITE, name="metrics")
    private MetricsIndex metricsIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, name="metrics")
    private MetricsIndex previousMetricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ElementHistoryIndex elementHistoryIndex;
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta changes;

    public void execute() throws Exception {
        long timestamp = this.getSchedulingCommit().getTimestamp();
        PairList values = new PairList();
        for (String added : this.changes.getAddedOrChangedKeysAsStrings()) {
            values.add((Object)added, (Object)timestamp);
        }
        this.metricsIndex.setMetricValues(values, LAST_CHANGED_METRICS_INDEX_PARTITION);
        this.updateChangeCount();
        this.metricsIndex.removeEntries((Collection)this.changes.getDeletedKeysAsStrings(), new String[]{LAST_CHANGED_METRICS_INDEX_PARTITION, CHANGE_COUNT_METRICS_INDEX_PARTITION});
    }

    private void updateChangeCount() throws StorageException {
        PairList partitionsAndPaths = new PairList();
        for (String added : this.changes.getAddedOrChangedKeysAsStrings()) {
            partitionsAndPaths.add((Object)CHANGE_COUNT_METRICS_INDEX_PARTITION, (Object)added);
        }
        List<ElementHistoryEntry> historyEntries = this.elementHistoryIndex.getHistoryEntries(this.changes.getAddedOrChangedKeysAsStrings());
        List oldMetricValues = this.metricsIndex.getMetricValues(partitionsAndPaths);
        this.metricsIndex.setMetricValues(this.computeChangeCountValues(partitionsAndPaths.extractSecondList(), historyEntries, oldMetricValues), CHANGE_COUNT_METRICS_INDEX_PARTITION);
    }

    private PairList<String, Double> computeChangeCountValues(List<String> uniformPaths, List<ElementHistoryEntry> historyEntries, List<Object> oldChangeCounts) throws AssertionError, StorageException {
        PairList newValues = new PairList();
        for (int i = 0; i < uniformPaths.size(); ++i) {
            double changeCount = 0.0;
            ElementHistoryEntry historyEntry = historyEntries.get(i);
            if (historyEntry != null) {
                switch (historyEntry.getChangeType()) {
                    case ADD: {
                        break;
                    }
                    case EDIT: {
                        if (oldChangeCounts.get(i) != null) {
                            changeCount = 1.0 + (Double)oldChangeCounts.get(i);
                            break;
                        }
                        LOGGER.error("Expecting metric value for edited path: " + uniformPaths.get(i));
                        break;
                    }
                    case MOVE: 
                    case COPY: {
                        changeCount = this.getPreviousChangeCount(historyEntry.getOriginPath());
                        break;
                    }
                    case EXTERNAL_ANALYSIS_UPLOAD: {
                        break;
                    }
                    case DELETE: {
                        CCSMAssert.fail((String)"Not expected to be called for deleted keys");
                    }
                    default: {
                        CCSMAssert.fail((String)("Unknown change type: " + String.valueOf((Object)historyEntry.getChangeType())));
                    }
                }
            }
            newValues.add((Object)uniformPaths.get(i), (Object)changeCount);
        }
        return newValues;
    }

    private int getPreviousChangeCount(String uniformPath) throws StorageException {
        Double previousValue = (Double)this.previousMetricsIndex.getMetricValue(CHANGE_COUNT_METRICS_INDEX_PARTITION, uniformPath);
        if (previousValue != null) {
            return previousValue.intValue();
        }
        return 0;
    }
}

