/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.MergeAncestorExplorer;
import com.teamscale.index.repository.MergeBaseInfo;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class MergeBaseResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    public static final long BACKOFF_TIMESPAN = TimeUnit.DAYS.toMillis(7L);
    private final Map<CommitDescriptor, ParentedCommitDescriptor> parentedCommits = new HashMap<CommitDescriptor, ParentedCommitDescriptor>();
    private final MergeAncestorExplorer mergeAncestorExplorer;
    private final CommitDescriptorIndex commitDescriptorIndex;

    private MergeBaseResolver(MergeAncestorExplorer mergeAncestorExplorer, CommitDescriptorIndex commitDescriptorIndex) {
        this.mergeAncestorExplorer = mergeAncestorExplorer;
        this.commitDescriptorIndex = commitDescriptorIndex;
    }

    public static Optional<MergeBaseInfo> computeMergeBaseInfo(CommitDescriptor inputSourceCommit, CommitDescriptor inputTargetCommit, CommitDescriptorIndex commitIndex) throws StorageException, CommitResolutionException {
        try {
            return MergeBaseResolver.computeMergeBaseInfo(inputSourceCommit, inputTargetCommit, commitIndex, MergeAncestorExplorer.getMergeAncestorExplorerWithAcceptAllFilters());
        }
        catch (RepositoryException e) {
            LOGGER.error("A RepositoryException occurred while computing the MergeBaseInfo without filtering for partial merges.", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<MergeBaseInfo> computeMergeBaseInfo(CommitDescriptor inputSourceCommit, CommitDescriptor inputTargetCommit, CommitDescriptorIndex commitIndex, MergeAncestorExplorer mergeAncestorExplorer) throws StorageException, RepositoryException, CommitResolutionException {
        MergeBaseResolver mergeBaseResolver = new MergeBaseResolver(mergeAncestorExplorer, commitIndex);
        CommitDescriptor sourceCommit = mergeBaseResolver.resolveCommit(inputSourceCommit);
        CommitDescriptor targetCommit = mergeBaseResolver.resolveCommit(inputTargetCommit);
        mergeBaseResolver.loadRelevantCommits(sourceCommit, targetCommit);
        mergeBaseResolver.assertNoCyclesInLoadedCommits();
        return mergeBaseResolver.computeMergeParentInfo(sourceCommit, targetCommit);
    }

    private CommitDescriptor resolveCommit(CommitDescriptor commit) throws StorageException, CommitResolutionException {
        Optional firstActualCommitBeforeOrAt = this.commitDescriptorIndex.getFirstActualCommitBeforeOrAt(commit, 0L);
        if (firstActualCommitBeforeOrAt.isEmpty()) {
            LOGGER.error("No commit on branch '{}' up to timestamp '{}' could be resolved.", (Object)commit.getBranchName(), (Object)commit.getTimestamp());
            throw new CommitResolutionException(commit);
        }
        return (CommitDescriptor)firstActualCommitBeforeOrAt.get();
    }

    private ParentedCommitDescriptor getParentedCommit(CommitDescriptor commit) throws StorageException, CommitResolutionException {
        ParentedCommitDescriptor result = this.parentedCommits.get(commit);
        if (result == null) {
            result = this.commitDescriptorIndex.getCommit(commit);
            if (result == null) {
                throw new CommitResolutionException(commit);
            }
            this.parentedCommits.put(commit, result);
        }
        return result;
    }

    private void assertNoCyclesInLoadedCommits() {
        ArrayList<ParentedCommitDescriptor> cycleCommits = new ArrayList<ParentedCommitDescriptor>();
        for (ParentedCommitDescriptor commit : this.parentedCommits.values()) {
            if (!commit.getParentCommits().stream().anyMatch(parent -> parent.getTimestamp() >= commit.getTimestamp())) continue;
            cycleCommits.add(commit);
        }
        if (!cycleCommits.isEmpty()) {
            CCSMAssert.fail((String)("Computation of merge-base aborted because there is a or more cycle in the commit graph involving these commits: \n" + StringUtils.concat(cycleCommits, (String)"\n")));
        }
    }

    private void loadRelevantCommits(CommitDescriptor sourceCommit, CommitDescriptor targetCommit) throws StorageException, CommitResolutionException {
        HashSet<CommitDescriptor> sourceTree = new HashSet<CommitDescriptor>();
        HashSet<CommitDescriptor> targetTree = new HashSet<CommitDescriptor>();
        Set<CommitDescriptor> sourceTreeFrontier = new HashSet<CommitDescriptor>(Set.of(sourceCommit));
        Set<CommitDescriptor> targetTreeFrontier = new HashSet<CommitDescriptor>(Set.of(targetCommit));
        while (!sourceTreeFrontier.isEmpty()) {
            if ((sourceTreeFrontier = this.advanceTree(sourceTreeFrontier, sourceTree, MergeBaseResolver.getTimestampOrZeroIfNull(MergeBaseResolver.min(targetTreeFrontier)) - BACKOFF_TIMESPAN)).isEmpty()) {
                return;
            }
            targetTreeFrontier = this.advanceTree(targetTreeFrontier, targetTree, MergeBaseResolver.getTimestampOrZeroIfNull(MergeBaseResolver.min(sourceTreeFrontier)) - 1L);
            sourceTreeFrontier.removeAll(targetTreeFrontier);
            sourceTreeFrontier.removeAll(targetTree);
        }
    }

    private static long getTimestampOrZeroIfNull(CommitDescriptor commit) {
        if (commit != null) {
            return commit.getTimestamp();
        }
        return 0L;
    }

    private Set<CommitDescriptor> advanceTree(Set<CommitDescriptor> frontierNodes, Set<CommitDescriptor> treeNodes, long breakTimestamp) throws StorageException, CommitResolutionException {
        if (breakTimestamp < 0L) {
            breakTimestamp = 0L;
        }
        HashSet<CommitDescriptor> newFrontier = new HashSet<CommitDescriptor>();
        ArrayDeque<CommitDescriptor> worklist = new ArrayDeque<CommitDescriptor>(frontierNodes);
        while (!worklist.isEmpty()) {
            CommitDescriptor frontierNode = (CommitDescriptor)worklist.poll();
            if (treeNodes.contains(frontierNode)) continue;
            treeNodes.add(frontierNode);
            Set<CommitDescriptor> advancedFrontier = this.advanceFrontierNode(frontierNode, breakTimestamp, newFrontier, treeNodes);
            if (advancedFrontier.isEmpty()) {
                newFrontier.add(frontierNode);
            }
            worklist.addAll(advancedFrontier);
        }
        return newFrontier;
    }

    private Set<CommitDescriptor> advanceFrontierNode(CommitDescriptor frontierNode, long breakTimestamp, Set<CommitDescriptor> newFrontier, Set<CommitDescriptor> treeNodes) throws StorageException, CommitResolutionException {
        HashSet<CommitDescriptor> newWorklistItems = new HashSet<CommitDescriptor>(this.getParentedCommit(frontierNode).getParentCommitsOnOtherBranches());
        List<ParentedCommitDescriptor> commitsInTimeframe = this.getAllCommitsOnBranchExcludingBounds(frontierNode.getBranchName(), breakTimestamp, frontierNode.getTimestamp());
        if (!commitsInTimeframe.isEmpty()) {
            ParentedCommitDescriptor oldestInTimeframe = MergeBaseResolver.min(commitsInTimeframe);
            for (ParentedCommitDescriptor commitOnBranch : commitsInTimeframe) {
                this.parentedCommits.putIfAbsent(commitOnBranch.getCommit(), commitOnBranch);
                newWorklistItems.addAll(commitOnBranch.getParentCommitsOnOtherBranches());
                if (commitOnBranch != oldestInTimeframe) {
                    treeNodes.add(commitOnBranch.getCommit());
                    continue;
                }
                newFrontier.add(oldestInTimeframe.getCommit());
            }
        } else {
            Optional nextParent = this.commitDescriptorIndex.getFirstActualCommitBefore(frontierNode, 0L);
            if (nextParent.isPresent()) {
                newFrontier.add((CommitDescriptor)nextParent.get());
                newWorklistItems.addAll(this.getParentedCommit((CommitDescriptor)nextParent.get()).getParentCommitsOnOtherBranches());
            }
        }
        return newWorklistItems;
    }

    private static <T extends Comparable<? super T>> T min(Collection<? extends T> commits) {
        if (commits.isEmpty()) {
            return null;
        }
        return (T)((Comparable)Collections.min(commits));
    }

    private List<ParentedCommitDescriptor> getAllCommitsOnBranchExcludingBounds(String branchName, long fromTimestamp, long toTimestamp) throws StorageException {
        if (++fromTimestamp > --toTimestamp) {
            return Collections.emptyList();
        }
        return this.commitDescriptorIndex.getCommits((Collection)this.commitDescriptorIndex.getAllCommitsOnBranchBetweenInclusive(new CommitDescriptor(branchName, fromTimestamp), new CommitDescriptor(branchName, toTimestamp)));
    }

    private Optional<MergeBaseInfo> computeMergeParentInfo(CommitDescriptor sourceCommit, CommitDescriptor targetCommit) throws RepositoryException {
        Set<CommitDescriptor> ancestorsOfTarget = this.mergeAncestorExplorer.exploreAncestorsOfTargetCommit(targetCommit, Set.of(sourceCommit), this.parentedCommits);
        Set<CommitDescriptor> ancestorsOfSource = this.mergeAncestorExplorer.exploreAncestorsOfSourceCommit(sourceCommit, ancestorsOfTarget, this.parentedCommits);
        if (!CollectionUtils.anyMatch(ancestorsOfSource, ancestorsOfTarget::contains)) {
            return Optional.empty();
        }
        if (ancestorsOfTarget.contains(sourceCommit) || ancestorsOfSource.size() == 1) {
            return Optional.of(new MergeBaseInfo(sourceCommit, null, null, Collections.emptySet()));
        }
        Set<ParentedCommitDescriptor> ancestorsOfSourceButNotOfTarget = this.getCachedParentedCommits(CollectionUtils.differenceSet(ancestorsOfSource, (Collection[])new Collection[]{ancestorsOfTarget}));
        MergeBaseCommits mergeBase = MergeBaseResolver.computeMergeBase(ancestorsOfSourceButNotOfTarget);
        return Optional.of(new MergeBaseInfo(mergeBase.getMergeBaseCommit(), mergeBase.getBranchPointCommit().orElse(null), mergeBase.getOldestNonMergeChildInSourceHistory().orElse(null), ancestorsOfSourceButNotOfTarget));
    }

    private static MergeBaseCommits computeMergeBase(Set<ParentedCommitDescriptor> ancestorsOfSourceButNotOfTarget) {
        Set flatAncestorsOfSourceButNotOfTarget = ancestorsOfSourceButNotOfTarget.stream().map(ParentedCommitDescriptor::getCommit).collect(Collectors.toSet());
        CommitDescriptor mergeBase = ancestorsOfSourceButNotOfTarget.stream().map(ParentedCommitDescriptor::getParentCommits).flatMap(Collection::stream).distinct().filter(commit -> !flatAncestorsOfSourceButNotOfTarget.contains(commit)).max(Comparator.naturalOrder()).orElseThrow();
        Set<ParentedCommitDescriptor> nonMergeChildrenInSourceHistory = MergeBaseResolver.computeNonMergeChildrenOfCommit(mergeBase, ancestorsOfSourceButNotOfTarget);
        Optional oldestNonMergeChildInSourceHistory = nonMergeChildrenInSourceHistory.stream().max(Comparator.naturalOrder());
        Optional<CommitDescriptor> branchPoint = MergeBaseResolver.computeBranchPoint(ancestorsOfSourceButNotOfTarget);
        return new MergeBaseCommits(mergeBase, branchPoint.orElse(null), oldestNonMergeChildInSourceHistory.orElse(null));
    }

    private static Optional<CommitDescriptor> computeBranchPoint(Set<ParentedCommitDescriptor> commits) {
        if (commits.isEmpty()) {
            return Optional.empty();
        }
        ParentedCommitDescriptor oldestCommit = Collections.min(commits);
        return Optional.ofNullable(oldestCommit.getFirstParentCommit());
    }

    private static Set<ParentedCommitDescriptor> computeNonMergeChildrenOfCommit(CommitDescriptor spawnCommit, Set<ParentedCommitDescriptor> ancestorsOfSource) {
        HashSet<ParentedCommitDescriptor> nonMergeChildrenInSourceHistory = new HashSet<ParentedCommitDescriptor>();
        HashSet<ParentedCommitDescriptor> processedChildren = new HashSet<ParentedCommitDescriptor>();
        ArrayDeque childrenToProcess = new ArrayDeque(CollectionUtils.filterToSet(ancestorsOfSource, commit -> commit.getParentCommits().contains((Object)spawnCommit)));
        while (!childrenToProcess.isEmpty()) {
            ParentedCommitDescriptor current = (ParentedCommitDescriptor)childrenToProcess.pop();
            if (!processedChildren.add(current)) continue;
            if (current.isMergeCommit()) {
                Set childrenOfCurrent = CollectionUtils.filterToSet(ancestorsOfSource, commit -> commit.getParentCommits().contains((Object)current.getCommit()));
                childrenToProcess.addAll(childrenOfCurrent);
                continue;
            }
            nonMergeChildrenInSourceHistory.add(current);
        }
        return nonMergeChildrenInSourceHistory;
    }

    private Set<ParentedCommitDescriptor> getCachedParentedCommits(HashSet<CommitDescriptor> shallowCommits) {
        HashSet<ParentedCommitDescriptor> fullCommits = HashSet.newHashSet(shallowCommits.size());
        for (CommitDescriptor commit : shallowCommits) {
            ParentedCommitDescriptor fullCommit = this.parentedCommits.get(commit);
            CCSMAssert.isNotNull((Object)fullCommit, (String)("Cache failure for " + String.valueOf(commit)));
            fullCommits.add(fullCommit);
        }
        return fullCommits;
    }

    private static class MergeBaseCommits {
        private final CommitDescriptor mergeBaseCommit;
        private final CommitDescriptor branchPointCommit;
        private final ParentedCommitDescriptor oldestNonMergeChildInSourceHistory;

        private MergeBaseCommits(CommitDescriptor mergeBaseCommit, CommitDescriptor branchPointCommit, ParentedCommitDescriptor oldestNonMergeChildInSourceHistory) {
            this.mergeBaseCommit = mergeBaseCommit;
            this.branchPointCommit = branchPointCommit;
            this.oldestNonMergeChildInSourceHistory = oldestNonMergeChildInSourceHistory;
        }

        private CommitDescriptor getMergeBaseCommit() {
            return this.mergeBaseCommit;
        }

        private Optional<CommitDescriptor> getBranchPointCommit() {
            return Optional.ofNullable(this.branchPointCommit);
        }

        private Optional<ParentedCommitDescriptor> getOldestNonMergeChildInSourceHistory() {
            return Optional.ofNullable(this.oldestNonMergeChildInSourceHistory);
        }
    }
}

