/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.index.shared.CodeScopeName;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class RepositoryContentUpdaterCodeScopeSupport {
    public static final String CODE_SCOPE_PATH_INCLUDE_PATTERNS_PARAMETER = "code-scope-path-include-patterns";
    public static final String CODE_SCOPE_PATH_EXCLUDE_PATTERNS_PARAMETER = "code-scope-path-exclude-patterns";
    public static final String CODE_SCOPE_CONTENT_INCLUDE_PATTERNS_PARAMETER = "code-scope-content-include-patterns";
    public static final String CODE_SCOPE_CONTENT_EXCLUDE_PATTERNS_PARAMETER = "code-scope-content-exclude-patterns";
    @StepParameter(value="code-scope-path-include-patterns")
    private CodeScopeAware<List<String>> codeScopePathIncludes;
    @StepParameter(value="code-scope-path-exclude-patterns")
    private CodeScopeAware<List<String>> codeScopePathExcludes;
    @StepParameter(value="code-scope-content-include-patterns")
    private CodeScopeAware<List<String>> codeScopeContentIncludes;
    @StepParameter(value="code-scope-content-exclude-patterns")
    private CodeScopeAware<List<String>> codeScopeContentExcludes;
    private final Map<CodeScopeName, IncludeExcludeAntPatternSupport> pathPatternIncludeExcludeSupportCache = new HashMap<CodeScopeName, IncludeExcludeAntPatternSupport>();
    private final Map<CodeScopeName, PatternList> contentIncludePatternCache = new HashMap<CodeScopeName, PatternList>();
    private final Map<CodeScopeName, PatternList> contentExcludePatternCache = new HashMap<CodeScopeName, PatternList>();

    public RepositoryContentUpdaterCodeScopeSupport() {
    }

    @VisibleForTesting
    public RepositoryContentUpdaterCodeScopeSupport(CodeScopeAware<List<String>> codeScopePathIncludes, CodeScopeAware<List<String>> codeScopePathExcludes, CodeScopeAware<List<String>> codeScopeContentIncludes, CodeScopeAware<List<String>> codeScopeContentExcludes) {
        this.codeScopePathIncludes = codeScopePathIncludes;
        this.codeScopePathExcludes = codeScopePathExcludes;
        this.codeScopeContentIncludes = codeScopeContentIncludes;
        this.codeScopeContentExcludes = codeScopeContentExcludes;
    }

    public static @NonNull RepositoryContentUpdaterCodeScopeSupport buildFromCodeScopes(List<CodeScope> codeScopes) {
        LinkedHashMap pathIncludesPerCodeScope = new LinkedHashMap();
        LinkedHashMap pathExcludesPerCodeScope = new LinkedHashMap();
        LinkedHashMap contentIncludesPerCodeScope = new LinkedHashMap();
        LinkedHashMap contentExcludesPerCodeScope = new LinkedHashMap();
        codeScopes.forEach(scope -> {
            pathIncludesPerCodeScope.put(scope.getName(), scope.getPathIncludes());
            pathExcludesPerCodeScope.put(scope.getName(), scope.getPathExcludes());
            contentIncludesPerCodeScope.put(scope.getName(), scope.getContentIncludes());
            contentExcludesPerCodeScope.put(scope.getName(), scope.getContentExcludes());
        });
        return new RepositoryContentUpdaterCodeScopeSupport((CodeScopeAware<List<String>>)new CodeScopeAware(pathIncludesPerCodeScope, Collections.emptyList()), (CodeScopeAware<List<String>>)new CodeScopeAware(pathExcludesPerCodeScope, Collections.emptyList()), (CodeScopeAware<List<String>>)new CodeScopeAware(contentIncludesPerCodeScope, Collections.emptyList()), (CodeScopeAware<List<String>>)new CodeScopeAware(contentExcludesPerCodeScope, Collections.emptyList()));
    }

    public @NonNull CodeScopeName determineCodeScope(String uniformPath, @Nullable String content) throws ConQATException {
        List codeScopeNames = this.codeScopePathIncludes.getCodeScopeNames();
        for (CodeScopeName codeScopeName : codeScopeNames) {
            List includePatternsForScope;
            List excludePatternsForScope;
            if (!(content != null ? this.isPathIncluded(codeScopeName, uniformPath) && !RepositoryContentUpdaterCodeScopeSupport.isContentIncluded(codeScopeName, content, excludePatternsForScope = (List)this.codeScopeContentExcludes.getValue(codeScopeName), this.contentExcludePatternCache) && ((includePatternsForScope = (List)this.codeScopeContentIncludes.getValue(codeScopeName)).isEmpty() || RepositoryContentUpdaterCodeScopeSupport.isContentIncluded(codeScopeName, content, includePatternsForScope, this.contentIncludePatternCache)) : this.isPathIncluded(codeScopeName, uniformPath))) continue;
            return codeScopeName;
        }
        throw new IllegalStateException("expected a code scope for uniformPath %s".formatted(uniformPath));
    }

    private static boolean isContentIncluded(CodeScopeName codeScopeName, String content, List<String> regexPatterns, Map<CodeScopeName, PatternList> compiledPatternCache) throws ConQATException {
        PatternList compiledPatterns = compiledPatternCache.get(codeScopeName);
        if (compiledPatterns == null) {
            compiledPatterns = new PatternList();
            for (String pattern : regexPatterns) {
                compiledPatterns.add((Object)CommonUtils.compilePattern((String)pattern));
            }
            compiledPatternCache.put(codeScopeName, compiledPatterns);
        }
        return compiledPatterns.findsAnyIn(content);
    }

    private boolean isPathIncluded(CodeScopeName codeScopeName, String uniformPath) {
        IncludeExcludeAntPatternSupport codeScopeIncludesExcludes = this.pathPatternIncludeExcludeSupportCache.get(codeScopeName);
        if (codeScopeIncludesExcludes == null) {
            List includePatterns = (List)this.codeScopePathIncludes.getValue(codeScopeName);
            List excludePatterns = (List)this.codeScopePathExcludes.getValue(codeScopeName);
            codeScopeIncludesExcludes = new IncludeExcludeAntPatternSupport(includePatterns, excludePatterns);
            this.pathPatternIncludeExcludeSupportCache.put(codeScopeName, codeScopeIncludesExcludes);
        }
        return codeScopeIncludesExcludes.isIncluded(uniformPath);
    }
}

