/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.IRepositoryConnection;
import com.teamscale.index.repository.MergeAncestorExplorer;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.MergeBaseResolver;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class RepositoryContentUpdaterUtils {
    public static PairList<ICommitTreeNode, EChangeEntryOrigin> determineRequiredAdditionalNodesToBeScanned(ParentedCommitDescriptor startCommit, ICommitTreeNode currentNode, BranchRenamingCommitTreeFacade branchRenamingCommitTree, CommitDescriptorIndex commitDescriptorIndex, boolean skipEmptyParents) throws StorageException, RepositoryException, CommitResolutionException {
        return RepositoryContentUpdaterUtils.determineRequiredAdditionalNodesToBeScanned(startCommit, currentNode, branchRenamingCommitTree, commitDescriptorIndex, skipEmptyParents, MergeAncestorExplorer.getMergeAncestorExplorerWithAcceptAllFilters(), false, null);
    }

    public static PairList<ICommitTreeNode, EChangeEntryOrigin> determineRequiredAdditionalNodesToBeScanned(ParentedCommitDescriptor startCommit, ICommitTreeNode currentNode, BranchRenamingCommitTreeFacade branchRenamingCommitTree, CommitDescriptorIndex commitDescriptorIndex, boolean skipEmptyParents, MergeAncestorExplorer mergeAncestorExplorer, boolean isFirstCommitForRepository, @Nullable Logger logger) throws StorageException, RepositoryException, CommitResolutionException {
        String parentBranchName;
        PairList<ICommitTreeNode, EChangeEntryOrigin> nodesFromForkBranch;
        if (isFirstCommitForRepository && (nodesFromForkBranch = RepositoryContentUpdaterUtils.getAdditionalNodesFromForkMerge(startCommit, currentNode, branchRenamingCommitTree, commitDescriptorIndex, mergeAncestorExplorer, logger)) != null) {
            return nodesFromForkBranch;
        }
        PairList requiredNodes = new PairList();
        ICommitTreeNode parentNodeFromCommitTree = RepositoryContentUpdaterUtils.loadFirstParentNode(currentNode, (ICommitTree)branchRenamingCommitTree, skipEmptyParents);
        CommitDescriptor parentCommitFromCommitDescriptorIndex = startCommit.getFirstParentCommit();
        while (!(parentCommitFromCommitDescriptorIndex == null || parentNodeFromCommitTree == null || parentCommitFromCommitDescriptorIndex.isOnBranch(parentBranchName = branchRenamingCommitTree.renameBranch(parentNodeFromCommitTree.getRevision().getBranchName())) && parentCommitFromCommitDescriptorIndex.getTimestamp() == parentNodeFromCommitTree.getAdjustedTimestamp().orElseThrow())) {
            if (parentNodeFromCommitTree.getAdjustedTimestamp().orElseThrow() < parentCommitFromCommitDescriptorIndex.getTimestamp()) {
                parentCommitFromCommitDescriptorIndex = commitDescriptorIndex.getCommit(parentCommitFromCommitDescriptorIndex).getFirstParentCommit();
                continue;
            }
            requiredNodes.add((Object)parentNodeFromCommitTree, (Object)EChangeEntryOrigin.MERGED_REPOSITORIES);
            parentNodeFromCommitTree = RepositoryContentUpdaterUtils.loadFirstParentNode(parentNodeFromCommitTree, (ICommitTree)branchRenamingCommitTree, skipEmptyParents);
        }
        while (parentNodeFromCommitTree != null && parentNodeFromCommitTree.getState() == ECommitTreeNodeState.SKIPPED) {
            requiredNodes.add((Object)parentNodeFromCommitTree, (Object)EChangeEntryOrigin.SKIPPED_EXTERNAL_UPLOADS);
            parentNodeFromCommitTree = RepositoryContentUpdaterUtils.loadFirstParentNode(parentNodeFromCommitTree, (ICommitTree)branchRenamingCommitTree, skipEmptyParents);
        }
        return requiredNodes;
    }

    private static @Nullable PairList<ICommitTreeNode, EChangeEntryOrigin> getAdditionalNodesFromForkMerge(ParentedCommitDescriptor startCommit, ICommitTreeNode currentNode, BranchRenamingCommitTreeFacade branchRenamingCommitTree, CommitDescriptorIndex commitDescriptorIndex, MergeAncestorExplorer mergeAncestorExplorer, @Nullable Logger logger) throws StorageException, RepositoryException, CommitResolutionException {
        UnmodifiableList startCommitParents;
        List currentParents = currentNode.getParentRevisions();
        if (!RepositoryContentUpdaterUtils.isForkMergeScenario(currentParents, (UnmodifiableList<CommitDescriptor>)(startCommitParents = startCommit.getParentCommits()), branchRenamingCommitTree)) {
            return null;
        }
        String forkParentBranchName = branchRenamingCommitTree.renameBranch(((CommitTreeRevision)currentParents.getFirst()).getBranchName());
        Optional<CommitDescriptor> forkCommit = startCommitParents.stream().filter(parent -> parent.isOnBranch(forkParentBranchName)).findFirst();
        if (forkCommit.isEmpty()) {
            return null;
        }
        Optional<MergeBaseInfo> mergeBaseInfo = MergeBaseResolver.computeMergeBaseInfo(forkCommit.get(), (CommitDescriptor)startCommitParents.getFirst(), commitDescriptorIndex, mergeAncestorExplorer);
        if (logger != null) {
            logger.debug("Merge base for fork commit {} and start commit {}: {}", forkCommit, (Object)startCommit, mergeBaseInfo.orElse(null));
        }
        if (mergeBaseInfo.isPresent()) {
            return RepositoryContentUpdaterUtils.getAdditionalNodesBasedOnMergeBaseInfo(branchRenamingCommitTree, mergeBaseInfo.get());
        }
        return RepositoryContentUpdaterUtils.getAdditionalNodesFromCommitTree(branchRenamingCommitTree, forkParentBranchName, forkCommit.get());
    }

    private static PairList<ICommitTreeNode, EChangeEntryOrigin> getAdditionalNodesFromCommitTree(@NonNull BranchRenamingCommitTreeFacade branchRenamingCommitTree, String forkParentBranchName, @NonNull CommitDescriptor forkCommit) {
        return (PairList)branchRenamingCommitTree.getAllNodes().stream().filter(node -> branchRenamingCommitTree.renameBranch(node.getRevision().getBranchName()).equals(forkParentBranchName) && node.getState() == ECommitTreeNodeState.PROCESSED && node.getAdjustedTimestamp().orElseThrow() <= forkCommit.getTimestamp()).sorted(Comparator.comparingLong(node -> node.getAdjustedTimestamp().orElseThrow()).reversed()).map(node -> Pair.createPair((Object)node, (Object)((Object)EChangeEntryOrigin.MULTI_REPOSITORY_FORK_TURNED_MERGE))).collect(PairList.toPairList());
    }

    private static boolean isForkMergeScenario(List<CommitTreeRevision> currentParents, UnmodifiableList<CommitDescriptor> startCommitParents, BranchRenamingCommitTreeFacade branchRenamingCommitTree) {
        if (currentParents.size() != 1) {
            return false;
        }
        if (startCommitParents.isEmpty()) {
            return false;
        }
        return !((CommitDescriptor)startCommitParents.getFirst()).isOnBranch(branchRenamingCommitTree.renameBranch(currentParents.getFirst().getBranchName()));
    }

    private static PairList<ICommitTreeNode, EChangeEntryOrigin> getAdditionalNodesBasedOnMergeBaseInfo(BranchRenamingCommitTreeFacade branchRenamingCommitTree, MergeBaseInfo mergeBaseInfo) {
        PairList nodes = new PairList();
        for (ParentedCommitDescriptor commit : mergeBaseInfo.getAncestorsOfSource()) {
            ICommitTreeNode commitTreeNode = branchRenamingCommitTree.getNodeByBranchAndAdjustedTimestamp(commit.getBranchName(), commit.getTimestamp());
            if (commitTreeNode == null) continue;
            nodes.add((Object)commitTreeNode, (Object)EChangeEntryOrigin.MULTI_REPOSITORY_FORK_TURNED_MERGE);
        }
        return nodes.reversed();
    }

    private static ICommitTreeNode loadFirstParentNode(ICommitTreeNode treeNode, ICommitTree commitTree, boolean skipEmptyParents) {
        if (skipEmptyParents) {
            List parents = treeNode.getNonEmptyParents();
            if (parents.isEmpty()) {
                return null;
            }
            return (ICommitTreeNode)parents.getFirst();
        }
        if (treeNode.getParentRevisions().isEmpty()) {
            return null;
        }
        return commitTree.getNodeByRevision((CommitTreeRevision)treeNode.getParentRevisions().getFirst());
    }

    public static String getTextContent(byte[] content, Charset encoding) throws AssertionError {
        String result = StringUtils.bytesToString((byte[])content, (Charset)encoding);
        return StringUtils.replaceLineBreaks((String)result, (char)'\n');
    }

    public static CommitTreeRevision createCommitTreeRevision(RepositoryChangeEntry changeEntry) {
        return new CommitTreeRevision(changeEntry.getRevision(), changeEntry.getCommit().getBranchName());
    }

    public static List<RepositoryChangeEntry> filterModifiedEntries(List<RepositoryChangeEntry> entries, IRepositoryConnection repositoryConnection) {
        return CollectionUtils.filter(entries, entry -> {
            CCSMAssert.isNotNull((Object)entry, (String)"Change entry may not be null!");
            return repositoryConnection.isIncluded(entry.getRepositoryPath().toString()) && entry.getChangeType() != ERepositoryChangeType.DELETE;
        });
    }

    public static List<RepositoryLogFileEntry> getRepositoryLogFileEntries(Long lastUpdate, CommitDescriptor latestCommitOnBranch, CommitDescriptorIndex commitDescriptorIndex, RepositoryLogIndex logIndex, RepositoryLogFileIndex logFileIndex) throws StorageException {
        List commits = CollectionUtils.map((Collection)commitDescriptorIndex.getCommitHistoryWithFirstParentCommits(latestCommitOnBranch, lastUpdate.longValue()), ParentedCommitDescriptor::getCommit);
        List logEntries = logIndex.getEntries(commits);
        List codeCommits = CollectionUtils.filterAndMap((Collection)logEntries, logEntry -> logEntry != null && logEntry.getCommitTypes().contains((Object)ECommitType.CODE_COMMIT), CommitAssociatedObjectBase::getCommit);
        return logFileIndex.getEntriesByCommits(codeCommits);
    }

    public static Set<UniformPath> determineChangedAndStillPresentFiles(List<RepositoryLogFileEntry> entries) {
        HashSet<UniformPath> changedAndStillPresentFiles = new HashSet<UniformPath>();
        HashSet<UniformPath> deletedFiles = new HashSet<UniformPath>();
        for (RepositoryLogFileEntry entry : CollectionUtils.sort(entries, Comparator.comparing(CommitAssociatedObjectBase::getTimestamp).reversed())) {
            UniformPath uniformPath = entry.getUniformPath();
            if (changedAndStillPresentFiles.contains(uniformPath) || deletedFiles.contains(uniformPath)) continue;
            if (entry.isDeleted()) {
                deletedFiles.add(uniformPath);
                continue;
            }
            changedAndStillPresentFiles.add(uniformPath);
        }
        return changedAndStillPresentFiles;
    }

    private RepositoryContentUpdaterUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

