/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.IRepositoryLogEntry;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class RepositoryLogEntry
extends CommitAssociatedObjectBase
implements IRepositoryLogEntry {
    private static final long serialVersionUID = 1L;
    protected static final String REVISION_PROPERTY = "revision";
    protected static final String MESSAGE_PROPERTY = "message";
    protected static final String AUTHOR_PROPERTY = "author";
    private static final String NUM_ADDED_FILES_PROPERTY = "numAddedFiles";
    private static final String NUM_CHANGED_FILES_PROPERTY = "numChangedFiles";
    private static final String NUM_DELETED_FILES_PROPERTY = "numDeletedFiles";
    protected static final String CONNECTOR_IDENTIFIER_PROPERTY = "repositoryIdentifier";
    protected static final String COMMIT_TYPES_PROPERTY = "commitTypes";
    protected static final String UPLOAD_TIMESTAMP_PROPERTY = "uploadTimestamp";
    public static final String EXTERNAL_ANALYSIS_REVISION_PREFIX = "EA";
    private static final String SOURCE_LIBRARY_CHANGE_COMMIT_MESSAGE_PREFIX = "[Source Library Change] ";
    @JsonProperty(value="revision")
    private final String revision;
    @JsonProperty(value="message")
    private @Nullable String message;
    @JsonProperty(value="author")
    private String author;
    @JsonProperty(value="mail")
    private @Nullable String mail;
    @JsonProperty(value="numAddedFiles")
    private final int numAddedFiles;
    @JsonProperty(value="numChangedFiles")
    private final int numChangedFiles;
    @JsonProperty(value="numDeletedFiles")
    private final int numDeletedFiles;
    @JsonProperty(value="repositoryIdentifier")
    private final String connectorIdentifier;
    @JsonProperty(value="commitTypes")
    private final @Nullable EnumSet<ECommitType> commitTypes;
    @JsonProperty(value="uploadTimestamp")
    private @Nullable Long uploadTimestamp;

    public RepositoryLogEntry(String revision, CommitDescriptor commit, String message, String author, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String connectorIdentifier, EnumSet<ECommitType> commitTypes) {
        this(revision, commit, message, author, null, numAddedFiles, numChangedFiles, numDeletedFiles, connectorIdentifier, commitTypes, null);
    }

    @JsonCreator
    public RepositoryLogEntry(@JsonProperty(value="revision") String revision, @JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="message") @Nullable String message, @JsonProperty(value="author") String author, @JsonProperty(value="numAddedFiles") int numAddedFiles, @JsonProperty(value="numChangedFiles") int numChangedFiles, @JsonProperty(value="numDeletedFiles") int numDeletedFiles, @JsonProperty(value="repositoryIdentifier") String connectorIdentifier, @JsonProperty(value="commitTypes") @NonNull Set<ECommitType> commitTypes, @JsonProperty(value="uploadTimestamp") @Nullable Long uploadTimestamp) {
        this(revision, commit, message, author, null, numAddedFiles, numChangedFiles, numDeletedFiles, connectorIdentifier, commitTypes, uploadTimestamp);
    }

    public RepositoryLogEntry(String revision, CommitDescriptor commit, @Nullable String message, String author, @Nullable String mail, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String connectorIdentifier, @NonNull Set<ECommitType> commitTypes, @Nullable Long uploadTimestamp) {
        super(commit);
        this.revision = revision;
        this.message = message;
        this.author = author;
        this.mail = mail;
        this.numAddedFiles = numAddedFiles;
        this.numChangedFiles = numChangedFiles;
        this.numDeletedFiles = numDeletedFiles;
        this.connectorIdentifier = connectorIdentifier;
        CCSMAssert.isFalse((boolean)commitTypes.isEmpty(), (String)"Commit types must not be empty");
        this.commitTypes = EnumSet.copyOf(commitTypes);
        this.uploadTimestamp = uploadTimestamp;
    }

    public RepositoryLogEntry(String revision, CommitDescriptor commit, String message, String author, String mail, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String connectorIdentifier, ECommitType commitType) {
        this(revision, commit, message, author, mail, numAddedFiles, numChangedFiles, numDeletedFiles, connectorIdentifier, EnumSet.of(commitType), null);
    }

    public RepositoryLogEntry(String revision, CommitDescriptor commit, String message, String author, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String connectorIdentifier, ECommitType commitType) {
        this(revision, commit, message, author, null, numAddedFiles, numChangedFiles, numDeletedFiles, connectorIdentifier, EnumSet.of(commitType), null);
    }

    public RepositoryLogEntry(String revision, CommitDescriptor commit, String message, String author, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String connectorIdentifier, ECommitType commitType, @Nullable Long uploadTimestamp) {
        this(revision, commit, message, author, null, numAddedFiles, numChangedFiles, numDeletedFiles, connectorIdentifier, EnumSet.of(commitType), uploadTimestamp);
    }

    public static String getSourceLibraryChangeCommitMessage(String originalCommitMessage) {
        return SOURCE_LIBRARY_CHANGE_COMMIT_MESSAGE_PREFIX + originalCommitMessage;
    }

    public boolean isSourceLibraryChangeCommit() {
        return this.commitTypes != null && this.commitTypes.contains((Object)ECommitType.SOURCE_LIBRARY_CHANGE);
    }

    public static RepositoryLogEntry createDummyCodeCommitEntry(CommitDescriptor commit) {
        return new RepositoryLogEntry("", commit, "", "", null, 0, 0, 0, "", EnumSet.of(ECommitType.CODE_COMMIT), null);
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public @Nullable String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getEmail() {
        return this.mail;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public int getNumAddedFiles() {
        return this.numAddedFiles;
    }

    @Override
    public int getNumChangedFiles() {
        return this.numChangedFiles;
    }

    @Override
    public int getNumDeletedFiles() {
        return this.numDeletedFiles;
    }

    public String getConnectorIdentifier() {
        return this.connectorIdentifier;
    }

    @Override
    public Set<ECommitType> getCommitTypes() {
        if (this.commitTypes == null) {
            return Collections.emptySet();
        }
        return this.commitTypes;
    }

    @Override
    public @Nullable Long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public String toString() {
        return this.revision + " " + String.valueOf(this.getCommit()) + " " + this.author + " " + this.mail + " " + this.message + " " + this.numAddedFiles + " add " + this.numChangedFiles + " change " + this.numDeletedFiles + " delete";
    }

    public int hashCode() {
        return Objects.hash(this.author, this.getCommit(), this.message, this.revision, this.numAddedFiles, this.numChangedFiles, this.numDeletedFiles, this.connectorIdentifier, this.mail, this.commitTypes, this.uploadTimestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RepositoryLogEntry)) {
            return false;
        }
        RepositoryLogEntry that = (RepositoryLogEntry)obj;
        if (!that.canEqual(this)) {
            return false;
        }
        return Objects.equals(this.author, that.author) && Objects.equals(this.getCommit(), that.getCommit()) && Objects.equals(this.message, that.message) && Objects.equals(this.revision, that.revision) && Objects.equals(this.numAddedFiles, that.numAddedFiles) && Objects.equals(this.numChangedFiles, that.numChangedFiles) && Objects.equals(this.numDeletedFiles, that.numDeletedFiles) && Objects.equals(this.connectorIdentifier, that.connectorIdentifier) && Objects.equals(this.mail, that.mail) && Objects.equals(this.commitTypes, that.commitTypes) && Objects.equals(this.uploadTimestamp, that.uploadTimestamp);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RepositoryLogEntry;
    }
}

