/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.IRepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class RepositoryLogEntryAggregate
extends CommitAssociatedObjectBase
implements IRepositoryLogEntry {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PRIMARY_LOG_ENTRY = "primaryLogEntry";
    private static final String SECONDARY_LOG_ENTRIES = "secondaryLogEntries";
    @JsonProperty(value="primaryLogEntry")
    private RepositoryLogEntry primaryLogEntry;
    @JsonProperty(value="secondaryLogEntries")
    private final Set<RepositoryLogEntry> secondaryLogEntries = new HashSet<RepositoryLogEntry>();

    public RepositoryLogEntryAggregate() {
        super(0L);
    }

    @VisibleForTesting
    public RepositoryLogEntryAggregate(String revision, CommitDescriptor commit, String message, String author, String mail, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String connectorIdentifier, ECommitType commitType) {
        this(new RepositoryLogEntry(revision, commit, message, author, mail, numAddedFiles, numChangedFiles, numDeletedFiles, connectorIdentifier, commitType));
    }

    @VisibleForTesting
    public RepositoryLogEntryAggregate(String revision, CommitDescriptor commit, String message, String author, int numAddedFiles, int numChangedFiles, int numDeletedFiles, String connectorIdentifier, ECommitType commitType) {
        this(new RepositoryLogEntry(revision, commit, message, author, null, numAddedFiles, numChangedFiles, numDeletedFiles, connectorIdentifier, commitType));
    }

    public RepositoryLogEntryAggregate(RepositoryLogEntry logEntry) {
        this();
        this.setPrimaryLogEntry(logEntry);
    }

    @Override
    public String getRevision() {
        return this.primaryLogEntry.getRevision();
    }

    @Override
    public @Nullable String getMessage() {
        return this.primaryLogEntry.getMessage();
    }

    @Override
    public String getAuthor() {
        return this.primaryLogEntry.getAuthor();
    }

    @Override
    public String getEmail() {
        return this.primaryLogEntry.getEmail();
    }

    @Override
    public int getNumAddedFiles() {
        return this.sumOverAllCommits(RepositoryLogEntry::getNumAddedFiles);
    }

    @Override
    public int getNumChangedFiles() {
        return this.sumOverAllCommits(RepositoryLogEntry::getNumChangedFiles);
    }

    @Override
    public int getNumDeletedFiles() {
        return this.sumOverAllCommits(RepositoryLogEntry::getNumDeletedFiles);
    }

    @Override
    public Set<ECommitType> getCommitTypes() {
        return this.getLogEntryStream().map(RepositoryLogEntry::getCommitTypes).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public @Nullable Long getUploadTimestamp() {
        return this.primaryLogEntry.getUploadTimestamp();
    }

    public String toString() {
        if (this.secondaryLogEntries.isEmpty()) {
            return this.primaryLogEntry.toString();
        }
        return "Log entry aggregate: " + String.valueOf(this.primaryLogEntry) + "\n" + StringUtils.concat(this.secondaryLogEntries, (String)"\n");
    }

    public int hashCode() {
        return Objects.hash(this.primaryLogEntry, this.secondaryLogEntries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RepositoryLogEntryAggregate that = (RepositoryLogEntryAggregate)o;
        return com.google.common.base.Objects.equal((Object)this.primaryLogEntry, (Object)that.primaryLogEntry) && com.google.common.base.Objects.equal(this.secondaryLogEntries, that.secondaryLogEntries);
    }

    public void setPrimaryLogEntry(RepositoryLogEntry repositoryLogEntry) {
        if (this.primaryLogEntry != null) {
            if (this.primaryLogEntry.equals(repositoryLogEntry)) {
                LOGGER.warn("Overwriting existing primary log entry with identical entry: {}", (Object)repositoryLogEntry);
            } else {
                LOGGER.warn("Overwriting primary log entry (existing entry will be demoted to secondary entry).\nOld: {}\nNew: {}", (Object)this.primaryLogEntry, (Object)repositoryLogEntry);
                this.addSecondaryLogEntry(this.primaryLogEntry);
            }
        }
        this.primaryLogEntry = repositoryLogEntry;
        this.setCommit(repositoryLogEntry.getCommit());
    }

    public void addSecondaryLogEntry(RepositoryLogEntry repositoryLogEntry) {
        if (this.primaryLogEntry == null) {
            this.setPrimaryLogEntry(repositoryLogEntry);
        } else {
            this.secondaryLogEntries.add(repositoryLogEntry);
        }
    }

    public RepositoryLogEntry getPrimaryEntry() {
        return Objects.requireNonNull(this.primaryLogEntry);
    }

    public boolean containsConnectorIdentifier(String connectorIdentifier) {
        return this.containsConnectorIdentifier((String identifier) -> identifier.equals(connectorIdentifier));
    }

    public boolean containsConnectorIdentifier(Predicate<String> connectorIdentifierPredicate) {
        return this.getLogEntryStream().map(RepositoryLogEntry::getConnectorIdentifier).anyMatch(connectorIdentifierPredicate);
    }

    private int sumOverAllCommits(ToIntFunction<RepositoryLogEntry> countExtractor) {
        return this.getLogEntryStream().mapToInt(countExtractor).sum();
    }

    private @NonNull Stream<RepositoryLogEntry> getLogEntryStream() {
        return Stream.concat(Stream.of(this.primaryLogEntry), this.secondaryLogEntries.stream());
    }

    public List<RepositoryLogEntry> getAllEntries() {
        ArrayList<RepositoryLogEntry> repositoryLogEntries = new ArrayList<RepositoryLogEntry>();
        repositoryLogEntries.add(this.primaryLogEntry);
        repositoryLogEntries.addAll(CollectionUtils.sort(this.secondaryLogEntries, Comparator.comparing(RepositoryLogEntry::getAuthor).thenComparing(RepositoryLogEntry::getConnectorIdentifier).thenComparing(logEntry -> StringUtils.emptyIfNull((String)logEntry.getMessage())).thenComparingInt(RepositoryLogEntry::getNumAddedFiles).thenComparingInt(RepositoryLogEntry::getNumChangedFiles).thenComparingInt(RepositoryLogEntry::getNumDeletedFiles).thenComparingInt(entry -> entry.getCommitTypes().size())));
        return repositoryLogEntries;
    }

    public RepositoryLogEntry toAggregateLogEntryWithPrimaryConnector() {
        return new RepositoryLogEntry(this.getRevision(), this.getCommit(), this.getMessage(), this.getAuthor(), this.getEmail(), this.getNumAddedFiles(), this.getNumChangedFiles(), this.getNumDeletedFiles(), this.primaryLogEntry.getConnectorIdentifier(), this.getCommitTypes(), this.getUploadTimestamp());
    }

    public RepositoryLogEntry toAggregateLogEntryWithMultipleConnectors() {
        return new RepositoryLogEntry(this.getRevision(), this.getCommit(), this.convertInitialImportMessage(), this.getAuthor(), this.getEmail(), this.getNumAddedFiles(), this.getNumChangedFiles(), this.getNumDeletedFiles(), this.getAggregatedConnectorIdentifier(), this.getCommitTypes(), this.getUploadTimestamp());
    }

    private @NonNull String getAggregatedConnectorIdentifier() {
        return this.getAllEntries().stream().map(RepositoryLogEntry::getConnectorIdentifier).distinct().collect(Collectors.joining(", "));
    }

    private String convertInitialImportMessage() {
        String message = StringUtils.emptyIfNull((String)this.getMessage());
        if (!message.startsWith("Teamscale import")) {
            return message;
        }
        String aggregatedConnectorIdentifier = this.getAggregatedConnectorIdentifier();
        if (StringUtils.isEmpty((String)aggregatedConnectorIdentifier)) {
            return "Teamscale import";
        }
        return "Teamscale import (" + aggregatedConnectorIdentifier + ")";
    }

    public static List<RepositoryLogEntry> getPrimaryEntries(Collection<RepositoryLogEntryAggregate> logEntries) {
        return CollectionUtils.map(logEntries, RepositoryLogEntryAggregate::getPrimaryEntry);
    }

    public Set<RepositoryLogEntry> getSecondaryLogEntries() {
        return this.secondaryLogEntries;
    }
}

