/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.index.repository.sap.abapsystem.importer.SapConnectionStatusIndex;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.StorageCacheRegistry;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.distribution.LocalMessageBroker;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStorageSystemProvider;
import org.jetbrains.annotations.VisibleForTesting;

public class SapConnectionStatusPersister {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String sapConnectionId;
    private final String synchronizerName;
    private final IndexLayer indexLayer;
    @VisibleForTesting
    public static final SapConnectionStatusPersister NO_OP = new SapConnectionStatusPersister("", ((Supplier<IndexLayer>)() -> {
        LocalMessageBroker broker = new LocalMessageBroker();
        return new IndexLayer((IStorageSystemProvider)new InMemoryStorageSystemProvider(), StorageCacheRegistry.createCacheProvider((IMessageBroker)broker), (IMessageBroker)broker);
    }).get(), ""){

        @Override
        public void setStatus(SapConnectionStatusIndex.ESapConnectionState status, String message) {
        }
    };

    public SapConnectionStatusPersister(String sapConnectionId, IndexLayer indexLayer, String synchronizerName) {
        this.sapConnectionId = sapConnectionId;
        this.synchronizerName = synchronizerName;
        this.indexLayer = indexLayer;
    }

    public void setStatus(SapConnectionStatusIndex.ESapConnectionState status, String message) {
        Object messageWithSynchronizerName = message;
        if (status != SapConnectionStatusIndex.ESapConnectionState.HEALTHY) {
            messageWithSynchronizerName = this.synchronizerName + ": " + message;
        }
        try {
            ((SapConnectionStatusIndex)this.indexLayer.openGlobalIndex(SapConnectionStatusIndex.class)).setStatus(this.sapConnectionId, status, message);
            SapConnectionStatusPersister.setConnectionStatusInProjects(this.indexLayer, this.sapConnectionId, status, (String)messageWithSynchronizerName);
        }
        catch (StorageException e) {
            LOGGER.error("Could not save status of connection to SAP system, " + this.sapConnectionId + ": " + String.valueOf((Object)e));
        }
    }

    private static void setConnectionStatusInProjects(IndexLayer indexLayer, String sapSystemNameFromAbapTrigger, SapConnectionStatusIndex.ESapConnectionState status, String message) throws StorageException {
        Multimap<PublicProjectId, String> projectConnectorIds = SapConnectionStatusPersister.getProjectConnectorsUsingSapSystem(indexLayer, sapSystemNameFromAbapTrigger);
        if (projectConnectorIds.isEmpty()) {
            return;
        }
        for (PublicProjectId publicProjectId : projectConnectorIds.keySet()) {
            ProjectConnectorStatusIndex projectConnectorStatusIndex = (ProjectConnectorStatusIndex)indexLayer.openProjectIndex((IProjectId)publicProjectId, ProjectConnectorStatusIndex.class, null);
            ArrayList repositoryConnectorIds = new ArrayList(projectConnectorIds.get((Object)publicProjectId));
            for (String repositoryConnectorId : repositoryConnectorIds) {
                ProjectConnectorStatus currentConnectorStatus = SapConnectionStatusPersister.prepareCurrentConnectorStatus(status, message, projectConnectorStatusIndex, repositoryConnectorId);
                projectConnectorStatusIndex.setStatus(currentConnectorStatus);
            }
        }
    }

    private static ProjectConnectorStatus prepareCurrentConnectorStatus(SapConnectionStatusIndex.ESapConnectionState status, String message, ProjectConnectorStatusIndex projectConnectorStatusIndex, String repositoryConnectorId) throws StorageException {
        Long lastSuccess = 0L;
        Long lastAttempt = System.currentTimeMillis();
        if (status == SapConnectionStatusIndex.ESapConnectionState.HEALTHY) {
            lastSuccess = lastAttempt;
        } else {
            ProjectConnectorStatus previousConnectorStatus = projectConnectorStatusIndex.getStatus(repositoryConnectorId);
            if (previousConnectorStatus != null) {
                lastSuccess = previousConnectorStatus.getLastSuccess();
            }
        }
        return new ProjectConnectorStatus(repositoryConnectorId, status.convertToProjectConnectorStatus(), lastSuccess, lastAttempt, message);
    }

    private static Multimap<PublicProjectId, String> getProjectConnectorsUsingSapSystem(IndexLayer indexLayer, String sapSystemNameFromAbapTrigger) throws StorageException {
        ArrayListMultimap connectorIds = ArrayListMultimap.create();
        ProjectIndex projectIndex = (ProjectIndex)indexLayer.openGlobalIndex(ProjectIndex.class);
        EnumSet<ERepositoryConnector> abapConnectorTypes = EnumSet.of(ERepositoryConnector.ABAP_GIT, ERepositoryConnector.GIT);
        for (PublicProjectId publicProjectId : projectIndex.getAllPrimaryPublicProjectIds()) {
            ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)publicProjectId, (IndexLayer)indexLayer);
            if (projectConfiguration == null) continue;
            for (ConnectorConfiguration connectorConfiguration : projectConfiguration.getConnectors()) {
                boolean isAbapConnector = connectorConfiguration.getRepositoryType().filter(abapConnectorTypes::contains).isEmpty();
                if (isAbapConnector) continue;
                String gitConnectorPathSuffix = sapSystemNameFromAbapTrigger + "/git";
                if (!sapSystemNameFromAbapTrigger.equals(connectorConfiguration.getOptionValue("SAP connection")) && !gitConnectorPathSuffix.equals(connectorConfiguration.getOptionValue("Path suffix"))) continue;
                connectorIds.put((Object)publicProjectId, (Object)connectorConfiguration.getIdentifier());
            }
        }
        return connectorIds;
    }
}

