/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.IRepositoryConnection;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryContentUpdaterBase;
import com.teamscale.index.repository.RepositoryContentUpdaterUtils;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.artifact_store.ArchiveIndexBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectorBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.base.RepositoryConnectorBase;
import com.teamscale.index.resource.ReportPartitionOriginIndex;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public abstract class ArtifactStoreContentUpdaterBase<T extends ArtifactStoreRepositoryConnectorBase<?, ?, ?>>
extends RepositoryContentUpdaterBase {
    @StepParameter(value="Delete Partitions Without New Uploads", optional=false)
    private boolean deletePartitionsWithoutNewUploads;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ReportCommitDeltaIndex reportCommitDeltaIndex;

    @Override
    protected IRepositoryConnection createRepositoryConnection() throws RepositoryException {
        try {
            ((ArtifactStoreRepositoryInfoBase)((ArtifactStoreRepositoryConnectorBase)this.getConnector()).getRepositoryInfo()).setProjectConfiguration((ProjectConfiguration)this.projectMetaIndex.getValue(ProjectConfiguration.class));
        }
        catch (StorageException e) {
            throw new RepositoryException("Unable to load project configuration.", (Throwable)e);
        }
        return ((ArtifactStoreRepositoryConnectorBase)this.getConnector()).createConnection(this.getProfilingMonitor(), (ICancelable)this, this.getParallelTaskExecutor());
    }

    @Override
    protected String getConnectionIdentifier() {
        return ((RepositoryConnectorBase)this.getConnector()).getBaseParameters().getConnectionIdentifier();
    }

    protected abstract T getConnector();

    @Override
    protected void extendEntriesIfRequired(List<RepositoryChangeEntry> entries, List<RepositoryChangeEntry> allEntries, ICommitTreeNode commitTreeNode) throws ConQATException {
        super.extendEntriesIfRequired(entries, allEntries, commitTreeNode);
        this.extendEntriesFromExternalReports(allEntries, commitTreeNode);
    }

    private void extendEntriesFromExternalReports(List<RepositoryChangeEntry> allEntries, ICommitTreeNode commitTreeNode) throws ConQATException {
        if (!this.reportMappingSupport.hasCoverageOrTestExecutionsReportsEnabled() || commitTreeNode.getNonEmptyParents().isEmpty()) {
            return;
        }
        ICommitTreeNode firstParentNode = (ICommitTreeNode)commitTreeNode.getNonEmptyParents().get(0);
        String branchToFollow = commitTreeNode.getRevision().getBranchName();
        Optional latestCommitOnBranch = this.commitDescriptorIndex.getLatestCommitForBranch(branchToFollow);
        if (latestCommitOnBranch.isEmpty()) {
            branchToFollow = firstParentNode.getRevision().getBranchName();
            latestCommitOnBranch = this.commitDescriptorIndex.getLatestCommitForBranch(branchToFollow);
        }
        if (latestCommitOnBranch.isEmpty()) {
            return;
        }
        Set<String> changedFiles = this.determineChangedFilesSinceLastReportUpload(allEntries, firstParentNode, ((ParentedCommitDescriptor)latestCommitOnBranch.get()).getCommit());
        Object archiveIndex = ((ArtifactStoreRepositoryInfoBase)((ArtifactStoreRepositoryConnectorBase)this.getConnector()).getRepositoryInfo()).getArchiveIndex();
        this.reportCommitDeltaIndex.storeReportDelta(this.getConnectionIdentifier(), new ReportCommitDeltaIndex.ReportCommitDelta(this.transformReportPaths(((ArchiveIndexBase)((Object)archiveIndex)).getAllPathsForRevision(commitTreeNode.getRevision())), this.transformReportPaths(((ArchiveIndexBase)((Object)archiveIndex)).getAllPathsForRevision(firstParentNode.getRevision())), changedFiles));
    }

    private Map<String, byte[]> transformReportPaths(Map<String, byte[]> reportContents) throws ConQATException {
        HashMap<String, byte[]> result = HashMap.newHashMap(reportContents.size());
        for (Map.Entry<String, byte[]> reportContent : reportContents.entrySet()) {
            UniformPath repositoryPath = UniformPathCompatibilityUtil.convert((String)reportContent.getKey());
            if (!this.reportMappingSupport.determineReportFormat(repositoryPath).isPresent()) continue;
            result.put(this.pathTransformationSupport.transformPath(repositoryPath).toStringAsMigrationFrontier(), reportContent.getValue());
        }
        return result;
    }

    private Set<String> determineChangedFilesSinceLastReportUpload(List<RepositoryChangeEntry> allEntries, ICommitTreeNode firstParentNode, CommitDescriptor latestCommitOnBranch) throws ConQATException {
        List<RepositoryLogFileEntry> logFileEntries = RepositoryContentUpdaterUtils.getRepositoryLogFileEntries(firstParentNode.getAdjustedTimestamp().orElseThrow() + 1L, latestCommitOnBranch, this.commitDescriptorIndex, this.globalLogIndex, this.logFileIndex);
        Set<UniformPath> changedFiles = RepositoryContentUpdaterUtils.determineChangedAndStillPresentFiles(logFileEntries);
        for (RepositoryChangeEntry entry : allEntries) {
            if (this.reportMappingSupport.isReportPath(entry) || entry.getChangeType() == ERepositoryChangeType.DELETE) continue;
            changedFiles.add(this.pathTransformationSupport.getUniformPath(entry));
        }
        return UniformPathCompatibilityUtil.asUniformPathStringSet(changedFiles);
    }

    @Override
    protected ReportPartitionOriginIndex.EReportDeletionBehavior determineReportDeletionBehavior() {
        if (this.deletePartitionsWithoutNewUploads) {
            return ReportPartitionOriginIndex.EReportDeletionBehavior.REMOVE_ALL_DELETED_REPORTS;
        }
        return ReportPartitionOriginIndex.EReportDeletionBehavior.IGNORE_REPORT_DELETION_IN_PARTITION_WITHOUT_ADDITIONS_OR_CHANGES;
    }

    @Index(name="report-commit-delta-index", options={EStorageOption.VIRTUAL}, valueClasses={ReportCommitDelta.class})
    public static class ReportCommitDeltaIndex
    extends IndexBase
    implements IProjectIndex {
        public static final String INDEX_NAME = "report-commit-delta-index";

        public ReportCommitDeltaIndex(IStore store) {
            super(store);
        }

        private void storeReportDelta(String connectorId, ReportCommitDelta reportCommitDelta) throws StorageException {
            this.store.putWithString(connectorId, StorageUtils.serialize((Serializable)reportCommitDelta));
        }

        @IndexValueClass
        public record ReportCommitDelta(Map<String, byte[]> reportContent, Map<String, byte[]> previousReportContent, Set<String> changedFiles) implements Serializable
        {
        }
    }
}

