/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import java.time.Instant;
import java.util.Objects;

public class ArtifactStoreItemData {
    private static final String METADATA_MARKER = "/%s/".formatted("__metadata__");
    private static final String PATH_PROPERTY = "path";
    private static final String NAME_PROPERTY = "name";
    private static final String CREATED_PROPERTY = "created";
    private static final String SIZE_PROPERTY = "size";
    @JsonProperty(value="path")
    public final String path;
    @JsonProperty(value="name")
    public final String name;
    @JsonProperty(value="created")
    private final String created;
    @JsonProperty(value="size")
    private final long contentLength;
    private long creationTimestamp = -1L;

    @JsonCreator
    public ArtifactStoreItemData(@JsonProperty(value="path") String path, @JsonProperty(value="name") String name, @JsonProperty(value="created") String created, @JsonProperty(value="size") long contentLength) {
        this.path = path;
        this.name = name;
        this.created = created;
        this.contentLength = contentLength;
        if (created != null) {
            this.creationTimestamp = Instant.from(SimpleArtifactStoreClientBase.DATE_FORMATTER.parse(created)).toEpochMilli();
        }
    }

    ArtifactStoreItemData(String path, String name, long creationTimestamp, long contentLength) {
        this.path = path;
        this.name = name;
        this.creationTimestamp = creationTimestamp;
        this.created = null;
        this.contentLength = contentLength;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getFullPath() {
        return this.path + "/" + this.name;
    }

    public String toString() {
        return "ItemData{path='" + this.path + "', name='" + this.name + "', creationTimestamp='" + this.creationTimestamp + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactStoreItemData itemData = (ArtifactStoreItemData)o;
        return this.creationTimestamp == itemData.creationTimestamp && Objects.equals(this.path, itemData.path) && Objects.equals(this.name, itemData.name);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.name, this.creationTimestamp);
    }

    public boolean isMetadata() {
        return this.getFullPath().contains(METADATA_MARKER);
    }
}

