/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.EArtifactStoreScanType;
import com.teamscale.index.utils.StringPoolDeserializer;
import com.teamscale.index.utils.StringPoolSerializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ItemQueryResultData
implements Iterable<ArtifactStoreItemData> {
    private static final String RESULTS_PROPERTY = "results";
    @JsonProperty(value="results")
    public final List<ArtifactStoreItemData> results;
    private EArtifactStoreScanType scanType = EArtifactStoreScanType.INCREMENTAL_SCAN;

    public EArtifactStoreScanType getScanType() {
        return this.scanType;
    }

    @JsonCreator
    private ItemQueryResultData(@JsonProperty(value="results") Collection<ArtifactStoreItemData> results) {
        this.results = new ArrayList<ArtifactStoreItemData>(results);
    }

    public static ItemQueryResultData forIncrementalAdditiveScanWithAddedKeys(List<ArtifactStoreItemData> addedKeys) {
        ItemQueryResultData itemData = new ItemQueryResultData(addedKeys);
        itemData.scanType = EArtifactStoreScanType.INCREMENTAL_ADDITIVE_SCAN;
        return itemData;
    }

    public static ItemQueryResultData forIncrementalScanWithAddedKeys(List<ArtifactStoreItemData> addedKeys) {
        ItemQueryResultData itemData = new ItemQueryResultData(addedKeys);
        itemData.scanType = EArtifactStoreScanType.INCREMENTAL_SCAN;
        return itemData;
    }

    public static ItemQueryResultData forFullScanWithAllKeys(List<ArtifactStoreItemData> allKeys) {
        ItemQueryResultData itemData = new ItemQueryResultData(allKeys);
        itemData.scanType = EArtifactStoreScanType.FULL_SCAN;
        return itemData;
    }

    public static ItemQueryResultData forTimeRangeScanWithDateKeys(List<ArtifactStoreItemData> dateKeys) {
        ItemQueryResultData itemData = new ItemQueryResultData(dateKeys);
        itemData.scanType = EArtifactStoreScanType.TIME_RANGE_SCAN;
        return itemData;
    }

    public static ItemQueryResultData emptyResultData() {
        return new ItemQueryResultData((Collection<ArtifactStoreItemData>)CollectionUtils.emptyList());
    }

    @Override
    public @NonNull Iterator<ArtifactStoreItemData> iterator() {
        return this.results.iterator();
    }

    @Override
    public void forEach(Consumer<? super ArtifactStoreItemData> action) {
        this.results.forEach(action);
    }

    @Override
    public Spliterator<ArtifactStoreItemData> spliterator() {
        return this.results.spliterator();
    }

    public Stream<ArtifactStoreItemData> stream() {
        return this.results.stream();
    }

    public byte[] toByteArray() throws StorageException {
        StringPoolSerializer stringPoolSerializer = new StringPoolSerializer(this){
            final /* synthetic */ ItemQueryResultData this$0;
            {
                ItemQueryResultData itemQueryResultData = this$0;
                Objects.requireNonNull(itemQueryResultData);
                this.this$0 = itemQueryResultData;
            }

            @Override
            protected void serializeData(DataOutputStream dos) throws IOException {
                dos.writeInt(this.this$0.scanType.ordinal());
                dos.writeInt(this.this$0.results.size());
                for (ArtifactStoreItemData item : this.this$0.results) {
                    this.writeString(item.name, dos);
                    this.writeString(item.path, dos);
                    dos.writeLong(item.getCreationTimestamp());
                    dos.writeLong(item.getContentLength());
                }
            }
        };
        for (ArtifactStoreItemData item : this.results) {
            stringPoolSerializer.addString(item.name);
            stringPoolSerializer.addString(item.path);
        }
        return stringPoolSerializer.serialize();
    }

    public static @Nullable ItemQueryResultData fromByteArray(byte @Nullable [] bytes) {
        if (bytes == null) {
            return null;
        }
        final ItemQueryResultData[] data = new ItemQueryResultData[]{null};
        StringPoolDeserializer deserializer = new StringPoolDeserializer(){

            @Override
            protected void deserializeData(DataInputStream din) throws IOException {
                EArtifactStoreScanType scanType = EArtifactStoreScanType.fromSerializationId(din.readInt()).orElseThrow();
                int resultCount = din.readInt();
                ArrayList<ArtifactStoreItemData> results = new ArrayList<ArtifactStoreItemData>(resultCount);
                for (int i = 0; i < resultCount; ++i) {
                    String name = this.readString(din);
                    String path = this.readString(din);
                    long creationTimestamp = din.readLong();
                    results.add(new ArtifactStoreItemData(path, name, creationTimestamp, din.readLong()));
                }
                data[0] = new ItemQueryResultData(results);
                data[0].scanType = scanType;
            }
        };
        deserializer.deserialize(bytes);
        return data[0];
    }
}

