/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import com.teamscale.index.repository.artifact_store.ArtifactStoreCommitResolutionCacheIndexBase;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionType;
import com.teamscale.index.repository.artifact_store.revision_interpretation.IRevisionInterpretation;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class CommitCachingDecorator
implements IRevisionInterpretation {
    private static final int CACHE_MAXIMUM_ENTRIES = 10000;
    private static final Logger LOGGER = LogManager.getLogger();
    private final IRevisionInterpretation delegate;
    private final String foreignRepositoryIdentifier;
    private final ArtifactStoreCommitResolutionCacheIndexBase artifactStoreCommitResolutionCacheIndex;
    private final LoadingCache<Triple<String, String, @Nullable String>, Optional<CommitDescriptor>> timestampResolutionCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Triple<String, String, String>, Optional<CommitDescriptor>>(this){
        final /* synthetic */ CommitCachingDecorator this$0;
        {
            CommitCachingDecorator commitCachingDecorator = this$0;
            Objects.requireNonNull(commitCachingDecorator);
            this.this$0 = commitCachingDecorator;
        }

        public Optional<CommitDescriptor> load(Triple<String, String, String> key) throws Exception {
            return this.this$0.lookupOrCompute(key);
        }
    });

    public CommitCachingDecorator(IRevisionInterpretation delegate, String foreignRepositoryIdentifier, ArtifactStoreCommitResolutionCacheIndexBase artifactStoreCommitResolutionCacheIndex) {
        this.delegate = delegate;
        this.foreignRepositoryIdentifier = foreignRepositoryIdentifier;
        this.artifactStoreCommitResolutionCacheIndex = artifactStoreCommitResolutionCacheIndex;
    }

    @Override
    public Optional<CommitDescriptor> interpretRevision(String revision, @Nullable String branchName) throws RepositoryException {
        try {
            return (Optional)this.timestampResolutionCache.get((Object)Triple.of((Object)this.foreignRepositoryIdentifier, (Object)revision, (Object)branchName));
        }
        catch (ExecutionError | ExecutionException e) {
            LOGGER.error("Unable to look up revision {}@{} in {}", (Object)revision, (Object)branchName, (Object)this.foreignRepositoryIdentifier);
            throw new RepositoryException(e);
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public ERevisionType getRevisionType() {
        return this.delegate.getRevisionType();
    }

    private Optional<CommitDescriptor> lookupOrCompute(Triple<String, String, String> revisionAndBranchName) throws StorageException, RepositoryException {
        String branchName;
        String revision;
        String foreignRepositoryId = (String)revisionAndBranchName.getLeft();
        CommitDescriptor cachedInIndex = this.artifactStoreCommitResolutionCacheIndex.getCommit(foreignRepositoryId, revision = (String)revisionAndBranchName.getMiddle(), branchName = (String)revisionAndBranchName.getRight());
        if (cachedInIndex != null) {
            return Optional.of(cachedInIndex);
        }
        Optional<CommitDescriptor> interpretedTimestamp = this.delegate.interpretRevision(revision, branchName);
        if (interpretedTimestamp.isPresent()) {
            this.artifactStoreCommitResolutionCacheIndex.storeCommit(foreignRepositoryId, revision, branchName, interpretedTimestamp.get());
        }
        return interpretedTimestamp;
    }
}

