/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.ExtractionFailedException;
import com.teamscale.index.repository.artifact_store.IArtifactStoreCommitResolver;
import com.teamscale.index.repository.artifact_store.IPatternBasedExtractor;
import com.teamscale.index.repository.artifact_store.revision_interpretation.IRevisionInterpretation;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ItemPathBasedCommitResolver
implements IArtifactStoreCommitResolver {
    private final IPatternBasedExtractor extractor;
    private final IRevisionInterpretation interpretation;

    public ItemPathBasedCommitResolver(IPatternBasedExtractor extractor, IRevisionInterpretation interpretation) {
        this.extractor = extractor;
        this.interpretation = interpretation;
    }

    @Override
    public Optional<Pair<String, CommitDescriptor>> resolveRevisionAndCommit(ArtifactStoreItemData item, @Nullable String branchName) throws RepositoryException {
        try {
            String revision = this.extractor.extractFrom(item.getFullPath());
            return this.interpretation.interpretRevision(revision, branchName).map(commit -> Pair.createPair((Object)revision, (Object)commit));
        }
        catch (ExtractionFailedException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public Optional<CommitDescriptor> resolveCommit(String revision, @Nullable String branchName) throws RepositoryException {
        return this.interpretation.interpretRevision(revision, branchName);
    }

    @Override
    public boolean mayRequireReschedule() {
        return this.interpretation.mayRequireReschedule();
    }

    @Override
    public Optional<IArtifactStoreCommitResolver.ResolveRevisionResult> resolveRevision(ArtifactStoreItemData item) {
        try {
            return Optional.of(new IArtifactStoreCommitResolver.ResolveRevisionResult(this.extractor.extractFrom(item.getFullPath()), this.interpretation.getRevisionType()));
        }
        catch (ExtractionFailedException e) {
            return Optional.empty();
        }
    }

    @Override
    public void close() throws RepositoryException {
        this.interpretation.close();
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

