/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.s3;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.artifact_store.ArtifactIncludeExcludePatterns;
import com.teamscale.index.repository.artifact_store.ArtifactStoreCommitResolutionCacheIndexBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import com.teamscale.index.repository.artifact_store.s3.S3CommitResolutionCacheIndex;
import com.teamscale.index.repository.artifact_store.s3.S3GlobalArchiveContentIndex;
import com.teamscale.index.s3.CredentialsProcess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class S3RepositoryInfo
extends ArtifactStoreRepositoryInfoBase {
    protected static final String BUCKET_NAME = "bucket-name";
    protected static final String KEY_PREFIX_PARAMETER = "key-prefix";
    protected static final String INCLUDED_KEY_PATTERN_PARAMETER = "key-include-pattern";
    protected static final String EXCLUDED_KEY_PATTERN_PARAMETER = "key-exclude-pattern";
    static final String USE_CREDENTIALS_PROCESS_PARAMETER = "use-credentials-process";
    @StepParameter(value="bucket-name")
    private String bucketName;
    @StepParameter(value="use-credentials-process")
    private boolean useCredentialsProcess;
    @StepParameter(value="key-prefix", optional=true)
    private final List<String> keyPrefixes = new ArrayList<String>();
    @StepParameter(value="key-include-pattern", optional=true)
    private final List<String> includedKeyPatterns = new ArrayList<String>();
    @StepParameter(value="key-exclude-pattern", optional=true)
    private final List<String> excludedKeyPatterns = new ArrayList<String>();
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    private S3ArchiveIndex s3ArchiveIndex;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    protected S3CommitResolutionCacheIndex s3CommitResolutionCacheIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private S3GlobalArchiveContentIndex s3GlobalArchiveContentIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptionIndex;
    private @Nullable CredentialsProcess credentialsProcess = null;

    @Override
    public void initializeInMemoryIndexes() {
        this.setS3ArchiveIndex(new S3ArchiveIndex((IStore)new InMemoryStore()));
        this.setS3CommitResolutionCacheIndex(new S3CommitResolutionCacheIndex((IStore)new InMemoryStore()));
    }

    @Override
    protected ArtifactStoreCommitResolutionCacheIndexBase getArtifactStoreCommitResolutionCacheIndex() {
        return this.s3CommitResolutionCacheIndex;
    }

    protected S3ArchiveIndex getArchiveIndex() {
        return this.s3ArchiveIndex;
    }

    @Override
    public S3GlobalArchiveContentIndex getGlobalArchiveContentIndex() {
        return this.s3GlobalArchiveContentIndex;
    }

    @Override
    public String getRepositoryOrBucketName() {
        return this.bucketName;
    }

    @Override
    public ArtifactIncludeExcludePatterns getKeyIncludeExcludePatterns() {
        if (this.includedKeyPatterns.isEmpty()) {
            return ArtifactIncludeExcludePatterns.createWithExcludedPathsPatterns(this.excludedKeyPatterns);
        }
        if (this.excludedKeyPatterns.isEmpty()) {
            return ArtifactIncludeExcludePatterns.createWithIncludedNamesPatterns(this.includedKeyPatterns);
        }
        return ArtifactIncludeExcludePatterns.createWithIncludedNamesAndExcludedPathsPatterns(this.includedKeyPatterns, this.excludedKeyPatterns);
    }

    @Override
    public void setRepositoryOrBucketName(ConnectorConfiguration connectorConfiguration) {
        this.bucketName = connectorConfiguration.getOptionValue("Bucket");
    }

    @Override
    public void setRepositoryOrBucketName(String repositoryOrBucketName) {
        this.bucketName = repositoryOrBucketName;
    }

    @Override
    public void setIncludeAndExcludePatterns(ConnectorConfiguration connectorConfiguration) {
        String includedKeysPattern = StringUtils.emptyIfNull((String)connectorConfiguration.getOptionValue("Included Key Patterns"));
        String excludedKeysPattern = StringUtils.emptyIfNull((String)connectorConfiguration.getOptionValue("Excluded Key Patterns"));
        String includedKeyPrefixes = StringUtils.emptyIfNull((String)connectorConfiguration.getOptionValue("Key Prefixes"));
        this.includedKeyPatterns.addAll(Arrays.asList(includedKeysPattern.split("[,\\n]")));
        this.excludedKeyPatterns.addAll(Arrays.asList(excludedKeysPattern.split("[,\\n]")));
        this.keyPrefixes.addAll(Arrays.asList(includedKeyPrefixes.split("[,\\n]")));
    }

    public void addKeyPrefix(String keyPrefix) {
        this.keyPrefixes.add(keyPrefix);
    }

    public void setS3ArchiveIndex(S3ArchiveIndex s3ArchiveIndex) {
        this.s3ArchiveIndex = s3ArchiveIndex;
    }

    private void setS3CommitResolutionCacheIndex(S3CommitResolutionCacheIndex s3CommitResolutionCacheIndex) {
        this.s3CommitResolutionCacheIndex = s3CommitResolutionCacheIndex;
    }

    public List<String> getKeyPrefixes() {
        return this.keyPrefixes;
    }

    public void setUseCredentialsProcess(ConnectorConfiguration config) {
        this.useCredentialsProcess = Boolean.parseBoolean(config.getOptionValue("Use Credentials Process"));
    }

    @Override
    public void completeInfo(ExternalCredentials externalCredentials, String pathSuffix, ExternalCredentialsIndex externalCredentialsIndex) throws StorageException, ProjectConfigurationException {
        super.completeInfo(externalCredentials, pathSuffix, externalCredentialsIndex);
        this.initCredentialsProcess();
    }

    private void initCredentialsProcess() throws StorageException, ProjectConfigurationException {
        this.credentialsProcess = this.useCredentialsProcess ? CredentialsProcess.readFromServerOptions(this.serverOptionIndex) : null;
    }

    public @Nullable CredentialsProcess getCredentialsProcess() {
        return this.credentialsProcess;
    }

    public String getTargetAsStringForLogging() {
        return "bucket '%s' with key prefixes %s".formatted(this.bucketName, this.getKeyPrefixesAsStringForLogging());
    }

    private String getKeyPrefixesAsStringForLogging() {
        return "[" + this.getKeyPrefixes().stream().map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")) + "]";
    }
}

