/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.base;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.RunnableWithException;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@Index(name="branch-pointer-history-placeholder", valueClasses={String.class, Instant.class}, options={EStorageOption.BACKUP, EStorageOption.COMMIT_ISOLATED, EStorageOption.NO_ROLLBACK})
@NullMarked
@ApiStatus.Experimental
public class BranchPointerHistoryIndex
implements IProjectIndexWithDynamicName {
    public static final String PLACEHOLDER = "branch-pointer-history-placeholder";
    private static final Instant TOP = DateTimeUtils.MAX_SAFE_INSTANT;
    public static final String DELETED_REVISION = "##deleted##";
    private @Nullable String name;
    private final KeysOnlyIndex activeBranches;
    private final KeysOnlyIndex inactiveBranches;
    private final Function<String, SimpleCrudIndex<Instant, String>> branchIndexFactory;

    public static String getIndexName(String repositoryId) {
        return IProjectIndexWithDynamicName.createIndexName((String)repositoryId, (String)PLACEHOLDER);
    }

    public BranchPointerHistoryIndex(IStore store) {
        this.activeBranches = new KeysOnlyIndex((IStore)new DelegatingPartitionStore(store, "ab"));
        this.inactiveBranches = new KeysOnlyIndex((IStore)new DelegatingPartitionStore(store, "ib"));
        DelegatingPartitionStore valueStore = new DelegatingPartitionStore(store, "v");
        this.branchIndexFactory = branch -> new SimpleCrudIndex((IStore)new DelegatingPartitionStore((IStore)valueStore, branch), ISerializer.of(Instant::toEpochMilli, Instant::ofEpochMilli).andThen(ISerializer.forLong()), ISerializer.forString());
    }

    public String getName() {
        if (this.name == null) {
            throw new IllegalStateException("Name was not set");
        }
        return this.name;
    }

    public void setName(String indexName) {
        this.name = indexName;
    }

    private SimpleCrudIndex<Instant, String> getBranchIndex(String branch) {
        return this.branchIndexFactory.apply(branch);
    }

    public void recordBranchRevision(String branch, String revision, Instant timestamp) throws StorageException {
        this.runLocked(branch, () -> this.recordBranchRevisionLocked(branch, revision, timestamp));
    }

    private void recordBranchRevisionLocked(String branch, String revision, Instant timestamp) throws StorageException {
        SimpleCrudIndex<Instant, String> branchIndex = this.getBranchIndex(branch);
        if (branchIndex.get((Object)TOP).filter(revision::equals).isEmpty()) {
            branchIndex.put((Object)timestamp, (Object)revision);
            branchIndex.put((Object)TOP, (Object)revision);
            if (DELETED_REVISION.equals(revision)) {
                this.activeBranches.removeKey(branch);
                this.inactiveBranches.storeKey(branch);
            } else {
                this.activeBranches.storeKey(branch);
                this.inactiveBranches.removeKey(branch);
            }
        }
    }

    public void recordBranchDeletion(String branch, Instant timestamp) throws StorageException {
        this.recordBranchRevision(branch, DELETED_REVISION, timestamp);
    }

    public Set<String> getAllBranches() throws StorageException {
        return Stream.of(this.activeBranches.listKeys(), this.inactiveBranches.listKeys()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<String> getActiveBranches() throws StorageException {
        return new HashSet<String>(this.activeBranches.listKeys());
    }

    public NavigableMap<Instant, String> getBranchPointerHistory(String branch) throws StorageException {
        return this.getBranchIndex(branch).getEntries().stream().filter(p -> !TOP.equals(p.getFirst())).collect(Collectors.toMap(ImmutablePair::getFirst, ImmutablePair::getSecond, CollectionUtils.throwingMerger(ignored -> "unknown"), TreeMap::new));
    }

    public Map<String, NavigableMap<Instant, String>> getBranchPointerHistory() throws StorageException {
        Set<String> allBranches = this.getAllBranches();
        HashMap<String, NavigableMap<Instant, String>> result = HashMap.newHashMap(allBranches.size());
        for (String branch : allBranches) {
            result.put(branch, this.getBranchPointerHistory(branch));
        }
        return result;
    }

    public void truncateHistory(Instant minimumTimestamp) throws StorageException {
        Set<String> branches = this.getAllBranches();
        for (String branch : branches) {
            this.truncateBranchHistory(branch, minimumTimestamp);
        }
    }

    public void truncateBranchHistory(String branch, Instant minimumTimestamp) throws StorageException {
        this.runLocked(branch, () -> this.truncateBranchHistoryLocked(branch, minimumTimestamp));
    }

    private void truncateBranchHistoryLocked(String branch, Instant minimumTimestamp) throws StorageException {
        SimpleCrudIndex<Instant, String> branchIndex = this.getBranchIndex(branch);
        TreeMap entries = new TreeMap();
        branchIndex.getEntries().forEach(entries::put);
        if (entries.isEmpty()) {
            return;
        }
        entries.remove(TOP);
        Map.Entry firstEntryToKeep = entries.ceilingEntry(minimumTimestamp);
        while (firstEntryToKeep != null && DELETED_REVISION.equals(firstEntryToKeep.getValue())) {
            firstEntryToKeep = entries.higherEntry(firstEntryToKeep.getKey());
        }
        if (firstEntryToKeep == null) {
            this.clearBranchHistory(branch);
            return;
        }
        NavigableSet<Instant> toDelete = entries.navigableKeySet().headSet(firstEntryToKeep.getKey(), false);
        if (toDelete.isEmpty()) {
            return;
        }
        branchIndex.remove(toDelete);
    }

    public void clearBranchHistory(String branch) throws StorageException {
        this.runLocked(branch, () -> {
            this.getBranchIndex(branch).clear();
            this.activeBranches.removeKey(branch);
            this.inactiveBranches.removeKey(branch);
        });
    }

    private <T extends Exception> void runLocked(String branch, RunnableWithException<T> lockedOperation) throws T {
        this.activeBranches.runLocked(branch, lockedOperation);
    }

    public void clear() throws StorageException {
        for (String branch : this.getAllBranches()) {
            this.clearBranchHistory(branch);
        }
    }
}

