/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.base;

import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="repository-to-trigger-mapping", options={EStorageOption.NO_ROLLBACK})
public class RepositoryToTriggerMappingIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "repository-to-trigger-mapping";
    private static final String SEPARATOR = "#-#";
    private final KeysOnlyIndex delegate;

    public RepositoryToTriggerMappingIndex(IStore store) {
        this.delegate = new KeysOnlyIndex(store);
    }

    public void insertMapping(String url, String triggerName) throws StorageException {
        CCSMAssert.isNotNull((Object)triggerName, (String)"The trigger name we map for a repository must never be null.");
        this.delegate.storeKey(RepositoryToTriggerMappingIndex.constructKey(url, triggerName));
    }

    public void removeMapping(String url, String triggerName) throws StorageException {
        this.delegate.removeKey(RepositoryToTriggerMappingIndex.constructKey(url, triggerName));
    }

    public List<String> getTriggerNamesForURL(String url) throws StorageException {
        String query = RepositoryToTriggerMappingIndex.canonicalizeUrlOrRepositoryPath(url) + SEPARATOR;
        return this.delegate.streamKeysStartingWith(query).map(key -> key.split(SEPARATOR, 2)[1]).collect(Collectors.toList());
    }

    public PairList<String, String> getAllMappings() throws StorageException {
        return (PairList)this.delegate.streamKeysStartingWith("").map(key -> key.split(SEPARATOR, 2)).collect(PairList.toPairList(parts -> parts[0], parts -> parts[1]));
    }

    private static String constructKey(String url, String triggerName) {
        return StringUtils.surroundWith((String)SEPARATOR, (String)RepositoryToTriggerMappingIndex.canonicalizeUrlOrRepositoryPath(url), (String)triggerName);
    }

    private static String canonicalizeUrlOrRepositoryPath(String url) {
        String protocolIndicator = "://";
        int protocolIndex = url.indexOf(protocolIndicator);
        if (protocolIndex >= 0) {
            url = url.substring(protocolIndex + protocolIndicator.length());
        }
        return StringUtils.stripSuffix((String)url.replace("\\", "/"), (String)"/");
    }
}

