/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.committree;

import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.committree.CommitSchedulingResult;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.repository.committree.CachingBranchRenameHandler;
import com.teamscale.index.repository.committree.IBranchRenameHandler;
import com.teamscale.index.repository.committree.NopBranchRenameHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jspecify.annotations.Nullable;

public class BranchRenamingCommitTreeFacade
implements IChangeRetrieverCommitTree {
    private static final long serialVersionUID = 1L;
    private IChangeRetrieverCommitTree commitTree;
    private IBranchRenameHandler branchRenameHandler;
    private CommitTreeIndex commitTreeIndex;

    public BranchRenamingCommitTreeFacade(StringTransformation branchTransformation, CommitTreeIndex commitTreeIndex) throws StorageException {
        this((IChangeRetrieverCommitTree)commitTreeIndex.loadTree(), branchTransformation, commitTreeIndex);
    }

    public BranchRenamingCommitTreeFacade(IChangeRetrieverCommitTree commitTree, StringTransformation branchTransformation, CommitTreeIndex commitTreeIndex) throws StorageException {
        this.commitTree = commitTree;
        this.commitTreeIndex = commitTreeIndex;
        if (branchTransformation.containsTransformations()) {
            PairList<String, String> sortedRenameMapping = this.loadSortedRenameMapping();
            this.branchRenameHandler = new CachingBranchRenameHandler(branchTransformation, sortedRenameMapping);
        } else {
            this.branchRenameHandler = new NopBranchRenameHandler();
        }
    }

    private BranchRenamingCommitTreeFacade(IChangeRetrieverCommitTree commitTree, IBranchRenameHandler branchRenameHandler, CommitTreeIndex commitTreeIndex) {
        this.commitTree = commitTree;
        this.branchRenameHandler = branchRenameHandler;
        this.commitTreeIndex = commitTreeIndex;
    }

    private PairList<String, String> loadSortedRenameMapping() throws StorageException {
        return BranchRenamingCommitTreeFacade.loadSortedRenameMapping(this.commitTreeIndex);
    }

    public static PairList<String, String> loadSortedRenameMapping(CommitTreeIndex commitTreeIndex) throws StorageException {
        PairList sortedRenameMapping = (PairList)commitTreeIndex.getAdditionalData(BranchRenamingCommitTreeFacade.class.getSimpleName());
        if (sortedRenameMapping == null) {
            return new PairList();
        }
        return sortedRenameMapping;
    }

    public UnmodifiableSet<String> getLiveBranchNames() {
        return CollectionUtils.asUnmodifiable(new HashSet(CollectionUtils.map((Collection)this.commitTree.getLiveBranchNames(), this::unrenameBranch)));
    }

    public IBranchRenameHandler getBranchRenameHandler() {
        return this.branchRenameHandler;
    }

    public void setLiveBranchNames(Collection<String> branchNames) {
        this.commitTree.setLiveBranchNames((Collection)CollectionUtils.map(branchNames, this::renameBranch));
    }

    public void persist() throws StorageException {
        this.commitTree.persist();
        PairList<String, String> sortedRenameMapping = this.branchRenameHandler.getSortedMapping();
        this.commitTreeIndex.storeAdditionalData(BranchRenamingCommitTreeFacade.class.getSimpleName(), sortedRenameMapping);
    }

    public boolean nodeExists(CommitTreeRevision revision) {
        return this.commitTree.nodeExists(this.renameBranch(revision));
    }

    public List<ICommitTreeNode> getAllNodes() {
        return CollectionUtils.map((Collection)this.commitTree.getAllNodes(), x$0 -> new BranchRenamingCommitTreeNode(this, (ICommitTreeNode)x$0));
    }

    public List<CommitTreeNode> getAllRawNodes() {
        return this.commitTree.getAllRawNodes();
    }

    public ICommitTreeNode addNode(CommitTreeRevision revision, long timestamp, List<CommitTreeRevision> parentRevisions, Consumer<String> errorHandler, CommitDescriptor injectedParent, long commitDiscoveryTime) {
        return this.commitTree.addNode(this.renameBranch(revision), timestamp, this.renameBranch(parentRevisions), errorHandler, this.renameBranch(injectedParent), commitDiscoveryTime);
    }

    public Optional<String> getLatestContainedRevisionForBranch(String branchName) {
        return this.commitTree.getLatestContainedRevisionForBranch(this.renameBranch(branchName));
    }

    public Optional<String> getLatestContainedRevisionForBranch(ICommitTreeNode commitTreeNode) {
        return this.commitTree.getLatestContainedRevisionForBranch(commitTreeNode);
    }

    public Set<String> getAllKnownBranchNames() {
        return CollectionUtils.mapToSet((Collection)this.commitTree.getAllKnownBranchNames(), this::unrenameBranch);
    }

    public boolean isEmpty() {
        return this.commitTree.isEmpty();
    }

    public Optional<String> resolveLatestRevisionBefore(String branchName, long timestamp) {
        return this.commitTree.resolveLatestRevisionBefore(this.renameBranch(branchName), timestamp);
    }

    private CommitDescriptor renameBranch(CommitDescriptor commitDescriptor) {
        return this.branchRenameHandler.renameBranch(commitDescriptor);
    }

    public String renameBranch(String branchName) {
        return this.branchRenameHandler.renameBranch(branchName);
    }

    public String unrenameBranch(String branchName) {
        return this.branchRenameHandler.unrenameBranch(branchName);
    }

    private CommitTreeRevision renameBranch(CommitTreeRevision revision) {
        if (this.isRenamed(revision)) {
            return revision;
        }
        return this.branchRenameHandler.renameBranch(revision);
    }

    public CommitTreeRevision unrenameBranch(CommitTreeRevision revision) {
        if (!this.isRenamed(revision)) {
            return revision;
        }
        return this.branchRenameHandler.unrenameBranch(revision);
    }

    private List<CommitTreeRevision> renameBranch(List<CommitTreeRevision> revisions) {
        return CollectionUtils.map(revisions, this::renameBranch);
    }

    private List<CommitTreeRevision> unrenameBranch(List<CommitTreeRevision> revisions) {
        return CollectionUtils.map(revisions, this::unrenameBranch);
    }

    public CommitTreeRevision unrenameBranch(ICommitTreeNode node) {
        if (node instanceof BranchRenamingCommitTreeNode) {
            return node.getRevision();
        }
        return this.unrenameBranch(node.getRevision());
    }

    public CommitTreeNode findScheduledNodeByAdjustedCommitDescriptor(CommitDescriptor commit, @Nullable UUID rollbackId) throws RepositoryNeedsRollbackException {
        return this.commitTree.findScheduledNodeByAdjustedCommitDescriptor(commit, rollbackId);
    }

    public boolean hasSchedulableNodes() {
        return this.commitTree.hasSchedulableNodes();
    }

    public CommitSchedulingResult extractAndUpdateSchedulableCommits(Predicate<CommitTreeNode> skipOracle) {
        return this.commitTree.extractAndUpdateSchedulableCommits(skipOracle);
    }

    public CommitTreeNode getNextSchedulableNode() {
        return this.commitTree.getNextSchedulableNode();
    }

    public boolean hasScheduledNodes() {
        return this.commitTree.hasScheduledNodes();
    }

    public ICommitTreeNode getNodeByBranchAndAdjustedTimestamp(String branchName, long timestamp) {
        ICommitTreeNode node = this.commitTree.getNodeByBranchAndAdjustedTimestamp(this.renameBranch(branchName), timestamp);
        if (node == null) {
            return null;
        }
        return new BranchRenamingCommitTreeNode(this, node);
    }

    public @Nullable ICommitTreeNode getNodeByRevision(CommitTreeRevision commitTreeRevision) {
        ICommitTreeNode node = this.commitTree.getNodeByRevision(this.renameBranch(commitTreeRevision));
        if (node == null) {
            return null;
        }
        return new BranchRenamingCommitTreeNode(this, node);
    }

    public void setLastExpanded(long expansionTimestamp) {
        this.commitTree.setLastExpanded(expansionTimestamp);
    }

    public void resetLastExpandedTimestamp() {
        this.commitTree.resetLastExpandedTimestamp();
    }

    public boolean wasExpandedWithinTimespan(int timespanSeconds) {
        return this.commitTree.wasExpandedWithinTimespan(timespanSeconds);
    }

    public boolean isForceExpansionPending() {
        return this.commitTree.isForceExpansionPending();
    }

    private boolean isRenamed(CommitTreeRevision revision) {
        return this.branchRenameHandler.isRenamed(revision);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.commitTree);
        out.writeObject(this.branchRenameHandler);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.commitTree = (IChangeRetrieverCommitTree)in.readObject();
        this.branchRenameHandler = (IBranchRenameHandler)in.readObject();
        this.commitTreeIndex = null;
    }

    public BranchRenamingCommitTreeFacade deepAnonymizedCopy(Function<String, String> branchNameAnonymizer) {
        return new BranchRenamingCommitTreeFacade(this.commitTree.deepAnonymizedCopy(branchNameAnonymizer), this.branchRenameHandler, new CommitTreeIndex((IStore)new InMemoryStore()));
    }

    private class BranchRenamingCommitTreeNode
    implements ICommitTreeNode {
        private final ICommitTreeNode node;
        final /* synthetic */ BranchRenamingCommitTreeFacade this$0;

        private BranchRenamingCommitTreeNode(BranchRenamingCommitTreeFacade branchRenamingCommitTreeFacade, ICommitTreeNode node) {
            BranchRenamingCommitTreeFacade branchRenamingCommitTreeFacade2 = branchRenamingCommitTreeFacade;
            Objects.requireNonNull(branchRenamingCommitTreeFacade2);
            this.this$0 = branchRenamingCommitTreeFacade2;
            this.node = node;
        }

        public CommitTreeRevision getRevision() {
            return this.this$0.unrenameBranch(this.node.getRevision());
        }

        public UnmodifiableList<ICommitTreeNode> getParents() {
            return CollectionUtils.asUnmodifiable((List)CollectionUtils.map((Collection)this.node.getParents(), x$0 -> new BranchRenamingCommitTreeNode(this.this$0, (ICommitTreeNode)x$0)));
        }

        public String getBranchName() {
            return this.this$0.unrenameBranch(this.node.getBranchName());
        }

        public long getOriginalTimestamp() {
            return this.node.getOriginalTimestamp();
        }

        public List<CommitTreeRevision> getParentRevisions() {
            return this.this$0.unrenameBranch(this.node.getParentRevisions());
        }

        public List<ICommitTreeNode> getNonEmptyParents() {
            return CollectionUtils.map((Collection)this.node.getNonEmptyParents(), x$0 -> new BranchRenamingCommitTreeNode(this.this$0, (ICommitTreeNode)x$0));
        }

        public OptionalLong getAdjustedTimestamp() {
            return this.node.getAdjustedTimestamp();
        }

        public CommitDescriptor getCommitDescriptorWithAdjustedTimestamp() {
            return this.node.getCommitDescriptorWithAdjustedTimestamp();
        }

        public CommitDescriptor getCommitDescriptorWithOriginalTimestamp() {
            return this.node.getCommitDescriptorWithOriginalTimestamp();
        }

        public ECommitTreeNodeState getState() {
            return this.node.getState();
        }

        public String toString() {
            String unrenamedBranch = this.this$0.unrenameBranch(this.node.getRevision().getBranchName());
            if (unrenamedBranch.equals(this.node.getRevision().getBranchName())) {
                return this.node.toString();
            }
            return "BranchRenamingCommitTreeNode [revision=" + String.valueOf(this.node.getRevision()) + ", unrenamedRevision=" + String.valueOf(this.getRevision()) + ", originalTimestamp=" + this.node.getOriginalTimestamp() + ", adjustedTimestamp=" + String.valueOf(this.node.getAdjustedTimestamp()) + ", parentRevisions=" + String.valueOf(this.node.getParentRevisions()) + ", unrenamedParentRevisions=" + String.valueOf(this.getParentRevisions()) + ", state=" + String.valueOf(this.node.getState()) + "]";
        }

        public void copyState(ICommitTreeNode sourceNode) {
            this.node.copyState(sourceNode);
        }

        public long getDiscoveryTimestamp() {
            return this.node.getDiscoveryTimestamp();
        }
    }
}

