/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.rest.client.HttpClientUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import kotlin.io.ByteStreamsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.EGitProtocol;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import ru.bozaro.gitlfs.client.AuthHelper;
import ru.bozaro.gitlfs.client.Client;
import ru.bozaro.gitlfs.client.auth.AuthProvider;
import ru.bozaro.gitlfs.client.auth.BasicAuthProvider;
import ru.bozaro.gitlfs.client.internal.JsonPost;
import ru.bozaro.gitlfs.client.internal.Request;
import ru.bozaro.gitlfs.common.data.BatchItem;
import ru.bozaro.gitlfs.common.data.BatchReq;
import ru.bozaro.gitlfs.common.data.BatchRes;
import ru.bozaro.gitlfs.common.data.Link;
import ru.bozaro.gitlfs.common.data.Links;
import ru.bozaro.gitlfs.common.data.Meta;
import ru.bozaro.gitlfs.common.data.Operation;
import ru.bozaro.gitlfs.pointer.Pointer;

public final class GitLfsClient
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Client client;
    private Link auth;

    public GitLfsClient(URI location, String username, String password) throws RepositoryException, URISyntaxException {
        AuthProvider authProvider = GitLfsClient.getLfsAuthProvider(location, username, password);
        this.client = new Client(authProvider, HttpClientUtils.createHttpClient());
    }

    private static AuthProvider getLfsAuthProvider(URI location, String username, String password) throws RepositoryException, URISyntaxException {
        EGitProtocol protocol;
        EGitProtocol eGitProtocol = protocol = (EGitProtocol)EGitProtocol.fromUri((URI)location).orElse(null);
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"HTTP", "HTTPS", "GIT"}, (EGitProtocol)eGitProtocol, n)) {
            case 0: 
            case 1: 
            case 2: {
                return new BasicAuthProvider(GitLfsClient.resolveLfsUri(location), username, password);
            }
        }
        throw new RepositoryException("Teamscale does not support Git LFS for the URI: \"" + String.valueOf(location) + "\"");
    }

    public void checkConnection() throws IOException {
        this.refreshAuth();
        Meta meta = new Meta("0", 1L);
        this.requestBatch(meta);
    }

    public byte[] downloadFromLfs(@NonNull Map<String, String> pointer) throws IOException {
        CCSMAssert.isNotNull(pointer);
        CCSMAssert.isNotNull((Object)pointer.get("oid"));
        CCSMAssert.isNotNull((Object)pointer.get("size"));
        try {
            this.refreshAuth();
            Meta meta = new Meta(pointer.get("oid").substring(7), Long.parseLong(pointer.get("size")));
            BatchItem item = (BatchItem)this.requestBatch(meta).getObjects().getFirst();
            LOGGER.debug("Downloading Git LFS file with size {}.", (Object)pointer.get("size"));
            return (byte[])this.client.getObject(meta, (Links)item, ByteStreamsKt::readBytes);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException("Teamscale is unable to process an invalid Git LFS pointer.", e);
        }
    }

    private BatchRes requestBatch(Meta ... meta) throws IOException {
        JsonPost postRequest = new JsonPost((Object)new BatchReq(Operation.Download, List.of(meta)), BatchRes.class);
        URI postUri = AuthHelper.INSTANCE.join(this.auth.getHref(), new String[]{"objects/batch"});
        return (BatchRes)this.client.doRequest(this.auth, (Request)postRequest, postUri, Client.ConnectionClosePolicy.Close);
    }

    private void refreshAuth() throws IOException {
        this.auth = this.client.getAuthProvider().getAuth(Operation.Download);
    }

    public static @Nullable Map<String, String> getLfsPointer(byte[] fileContents, long fileSize) {
        if (fileSize > 1024L) {
            return null;
        }
        return Pointer.INSTANCE.parsePointer(fileContents, 0, (int)fileSize);
    }

    private static URI resolveLfsUri(URI location) throws URISyntaxException {
        return new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), StringUtils.ensureEndsWith((String)StringUtils.stripSuffix((String)location.getPath(), (String)"/"), (String)".git") + "/info/lfs", location.getQuery(), location.getFragment());
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

