/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Index(name="git-repository-infos-placeholder", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP}, valueClasses={String.class})
public class GitRepositoryInfoIndex
extends ProjectIndexWithDynamicNameBase
implements IRollbackableIndex {
    public static final String PLACEHOLDER = "git-repository-infos-placeholder";
    private static final String BRANCHNAME_BY_COMMIT_NAME_KEY = "branch-names";
    private static final String INITIAL_DEFAULT_BRANCH_ROOT_REVISION = "initial-default-branch-root-revision";
    private static final String DEBUG_DUMP_REQUESTED = "debug-dump-requested";
    private static final String COMMIT_TREE_EXPANSION_NEEDED_KEY = "commit-tree-expansion-needed";
    private static final String REFS_HASH_KEY = "refs-hash";
    private static final String LAST_COMMIT_TREE_EXPANSION = "commit-tree-last-expanded";
    private static final String FAILED_FETCHES_COUNT_PREFIX = "missing-ref-count/";
    private static final String DEFAULT_BRANCH_KEY = "default-branch-name";
    private static final String NODES_SAFE_TO_PROCESS = "nodes-safe-to-process";
    private Map<String, String> branchNamesByCommitName;

    public GitRepositoryInfoIndex(IStore store) {
        super(store);
    }

    public Map<String, String> getBranchNamesByCommitName() throws StorageException {
        if (this.branchNamesByCommitName != null) {
            return this.branchNamesByCommitName;
        }
        this.branchNamesByCommitName = (Map)((Object)StorageUtils.deserialize((byte[])this.store.getWithString(BRANCHNAME_BY_COMMIT_NAME_KEY)));
        if (this.branchNamesByCommitName == null) {
            this.branchNamesByCommitName = new HashMap<String, String>();
        }
        return this.branchNamesByCommitName;
    }

    public void persistBranchNamesByCommitName(Map<String, String> branchNamesByCommitName) throws StorageException {
        this.store.putWithString(BRANCHNAME_BY_COMMIT_NAME_KEY, StorageUtils.serialize(new HashMap<String, String>(branchNamesByCommitName)));
        this.branchNamesByCommitName = null;
    }

    public boolean isDebugDumpRequested() throws StorageException {
        return Optional.ofNullable((Boolean)StorageUtils.deserialize((byte[])this.store.getWithString(DEBUG_DUMP_REQUESTED))).orElse(false);
    }

    public void setDebugDumpRequested(boolean debugDumpRequested) throws StorageException {
        this.store.putWithString(DEBUG_DUMP_REQUESTED, StorageUtils.serialize((Serializable)Boolean.valueOf(debugDumpRequested)));
    }

    public static String createIndexName(String repositoryIdentifier) {
        return IProjectIndexWithDynamicName.createIndexName((String)repositoryIdentifier, (String)PLACEHOLDER);
    }

    public void setCommitTreeExpansionNeeded(boolean expansionNeeded) throws StorageException {
        this.store.putWithString(COMMIT_TREE_EXPANSION_NEEDED_KEY, StorageUtils.serialize((Serializable)Boolean.valueOf(expansionNeeded)));
    }

    public boolean isCommitTreeExpansionNeeded() throws StorageException {
        Boolean expansionNeeded = (Boolean)StorageUtils.deserialize((byte[])this.store.getWithString(COMMIT_TREE_EXPANSION_NEEDED_KEY));
        return Optional.ofNullable(expansionNeeded).orElse(true);
    }

    public void setLastCommitTreeExpansion(Instant lastCommitTreeExpansion) throws StorageException {
        this.store.putWithString(LAST_COMMIT_TREE_EXPANSION, ByteArrayUtils.longToByteArray((long)lastCommitTreeExpansion.toEpochMilli()));
    }

    public Optional<Instant> getLastCommitTreeExpansion() throws StorageException {
        byte[] value = this.store.getWithString(LAST_COMMIT_TREE_EXPANSION);
        return Optional.ofNullable(value).map(ByteArrayUtils::byteArrayToLong).map(Instant::ofEpochMilli);
    }

    public void setPreviousDefaultBranchName(String defaultBranch) throws StorageException {
        this.store.putWithString(DEFAULT_BRANCH_KEY, StringUtils.stringToBytes((String)defaultBranch));
    }

    public Optional<String> getPreviousDefaultBranchName() throws StorageException {
        return Optional.ofNullable(StringUtils.bytesToString((byte[])this.store.getWithString(DEFAULT_BRANCH_KEY)));
    }

    public Optional<String> getInitialDefaultBranchRootRevision() throws StorageException {
        String storedValue = StringUtils.bytesToString((byte[])this.store.getWithString(INITIAL_DEFAULT_BRANCH_ROOT_REVISION));
        if (StringUtils.isEmpty((String)storedValue)) {
            return Optional.empty();
        }
        return Optional.of(storedValue);
    }

    public void storeInitialDefaultBranchRootRevision(@Nullable String initialDefaultBranchRootRevision) throws StorageException {
        if (StringUtils.isEmpty((String)initialDefaultBranchRootRevision)) {
            this.resetInitialDefaultBranchRootRevision();
        } else {
            this.store.putWithString(INITIAL_DEFAULT_BRANCH_ROOT_REVISION, StringUtils.stringToBytes((String)initialDefaultBranchRootRevision));
        }
    }

    public void resetInitialDefaultBranchRootRevision() throws StorageException {
        this.store.removeWithString(INITIAL_DEFAULT_BRANCH_ROOT_REVISION);
    }

    public void setRefsHash(byte[] refsHash) throws StorageException {
        this.store.putWithString(REFS_HASH_KEY, refsHash);
    }

    public byte[] getRefsHash() throws StorageException {
        return this.store.getWithString(REFS_HASH_KEY);
    }

    public void setNodesSafeToProcess(HashSet<String> nodesCheckedForHugeDiff) throws StorageException {
        this.store.putWithString(NODES_SAFE_TO_PROCESS, StorageUtils.serialize(nodesCheckedForHugeDiff));
    }

    public HashSet<String> getNodesSafeToProcess() throws StorageException {
        byte[] value = this.store.getWithString(NODES_SAFE_TO_PROCESS);
        if (value == null) {
            return new HashSet<String>();
        }
        return (HashSet)StorageUtils.deserialize((byte[])value);
    }

    public void storeFailedFetch(String missingRef) throws StorageException {
        String key = GitRepositoryInfoIndex.createMissingRefKey(missingRef);
        byte[] oldValue = this.store.getWithString(key);
        if (oldValue == null) {
            this.store.putWithString(key, ByteArrayUtils.intToByteArray((int)1));
        } else {
            this.store.putWithString(key, ByteArrayUtils.intToByteArray((int)(ByteArrayUtils.byteArrayToInt((byte[])oldValue) + 1)));
        }
    }

    public int getFailedFetchCount(String sourceRef) throws StorageException {
        byte[] value = this.store.getWithString(GitRepositoryInfoIndex.createMissingRefKey(sourceRef));
        if (value == null) {
            return 0;
        }
        return ByteArrayUtils.byteArrayToInt((byte[])value);
    }

    private static String createMissingRefKey(String missingRef) {
        return FAILED_FETCHES_COUNT_PREFIX + missingRef;
    }

    public void clearStore() throws StorageException {
        this.store.removeByPrefix("");
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        this.store.removeWithStrings(Arrays.asList(COMMIT_TREE_EXPANSION_NEEDED_KEY, REFS_HASH_KEY));
    }
}

