/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.index.repository.git.GitSubModuleRepository;
import java.util.Objects;
import org.conqat.engine.index.shared.RepositoryException;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitSubModuleCommitReference {
    private final GitSubModuleRepository subModule;
    private final String revision;

    public GitSubModuleCommitReference(GitSubModuleRepository subModule, String revision) {
        this.subModule = subModule;
        this.revision = revision;
    }

    public boolean commitExists() {
        return this.subModule.getOptionalCommit(this.revision).isPresent();
    }

    public GitSubModuleRepository getSubModule() {
        return this.subModule;
    }

    public String getRevision() {
        return this.revision;
    }

    public RevCommit getCommit() throws RepositoryException {
        return this.subModule.getCommit(this.revision);
    }

    public int hashCode() {
        return Objects.hash(this.subModule, this.revision);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GitSubModuleCommitReference) {
            GitSubModuleCommitReference other = (GitSubModuleCommitReference)obj;
            return this.revision.equals(other.revision) && this.subModule.equals(other.subModule);
        }
        return false;
    }
}

