/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.autogc;

import java.util.List;
import java.util.Objects;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="pending-garbage-collection", options={EStorageOption.COMPRESSED})
public class PendingGarbageCollectionIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "pending-garbage-collection";
    private static final String LOCK_SUFFIX = "update";
    private static final byte[] DUMMY_VALUE = new byte[0];
    private final ValueIndex<byte[]> delegateIndex;

    public PendingGarbageCollectionIndex(IStore store) {
        this.delegateIndex = ValueIndex.forSerializable((IStore)store);
    }

    public void requestGC(String repositoryPath) throws StorageException {
        this.delegateIndex.runLocked(LOCK_SUFFIX, () -> this.delegateIndex.setValue(repositoryPath, (Object)DUMMY_VALUE));
    }

    public List<String> popPendingGCs() throws StorageException {
        class GetAllKeysCallback {
            private List<String> values;

            GetAllKeysCallback(PendingGarbageCollectionIndex this$0) {
                Objects.requireNonNull(this$0);
            }
        }
        GetAllKeysCallback callback = new GetAllKeysCallback(this);
        this.delegateIndex.runLocked(LOCK_SUFFIX, () -> {
            callback.values = this.delegateIndex.getAllKeys();
            this.delegateIndex.removeAllEntries();
        });
        return callback.values;
    }

    @VisibleForTesting
    public List<String> readPendingGCs() throws StorageException {
        return this.delegateIndex.getAllKeys();
    }
}

