/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudLink;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudProject;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudWorkspace;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class BitbucketCloudRepository {
    @JsonProperty(value="workspace")
    private @Nullable BitbucketCloudWorkspace workspace;
    @JsonProperty(value="full_name")
    private String fullName;
    @JsonProperty(value="slug")
    private @Nullable String slug;
    @JsonProperty(value="links")
    private @Nullable BitbucketCloudCloneLinks links;
    @JsonProperty(value="project")
    private @Nullable BitbucketCloudProject project;
    @JsonProperty(value="uuid")
    private String uuid;

    public String getUuid() {
        return this.uuid;
    }

    public BitbucketCloudRepository() {
    }

    @VisibleForTesting
    public BitbucketCloudRepository(String fullName, @Nullable BitbucketCloudCloneLinks links) {
        this.fullName = fullName;
        this.links = links;
    }

    public Optional<String> getHttpCloneUrl() {
        if (this.links == null) {
            return Optional.empty();
        }
        return this.links.getHttpCloneUrl();
    }

    public String getProjectKey() {
        if (this.project == null) {
            return "";
        }
        return this.project.getKey();
    }

    public @Nullable String getSlug() {
        return this.slug;
    }

    public String getFullName() {
        return this.fullName;
    }

    public @Nullable BitbucketCloudCloneLinks getLinks() {
        return this.links;
    }

    public @Nullable BitbucketCloudProject getProject() {
        return this.project;
    }

    public @Nullable BitbucketCloudWorkspace getWorkspace() {
        return this.workspace;
    }

    public String toString() {
        return "BitbucketCloudRepository{workspace=" + String.valueOf(this.workspace) + ", fullName='" + this.fullName + "', slug='" + this.slug + "', links=" + String.valueOf(this.links) + ", project=" + String.valueOf(this.project) + ", uuid='" + this.uuid + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitbucketCloudRepository that = (BitbucketCloudRepository)o;
        return Objects.equals(this.workspace, that.workspace) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.slug, that.slug) && Objects.equals(this.links, that.links) && Objects.equals(this.project, that.project) && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.workspace, this.fullName, this.slug, this.links, this.project, this.uuid);
    }

    public static class BitbucketCloudCloneLinks {
        @JsonProperty(value="clone")
        private BitbucketCloudLink[] clone;

        public BitbucketCloudCloneLinks() {
        }

        @VisibleForTesting
        public BitbucketCloudCloneLinks(BitbucketCloudLink[] clone) {
            this.clone = Arrays.copyOf(clone, clone.length);
        }

        public Optional<String> getHttpCloneUrl() {
            return Arrays.stream(this.clone).filter(cloneUrl -> cloneUrl.getLinkName() != null && cloneUrl.getLinkName().startsWith("http")).findFirst().map(BitbucketCloudLink::getLinkHref);
        }

        public String toString() {
            return "BitbucketCloudCloneLinks{clone=" + Arrays.toString(this.clone) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BitbucketCloudCloneLinks that = (BitbucketCloudCloneLinks)o;
            return Arrays.equals(this.clone, that.clone);
        }

        public int hashCode() {
            return Arrays.hashCode(this.clone);
        }
    }
}

