/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.repository.git.bitbucket.BitbucketInstallationRepositories;
import com.teamscale.index.repository.git.bitbucket.server.model.insights.BitbucketServerCodeInsightAnnotation;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.BitBucketServerPullRequestChanges;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.BitbucketServerDiffPath;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff.BitbucketServerPullRequestDiffs;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerInlinePullRequestComment;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public final class BitbucketServerUtils {
    public static final String PUSH_EVENT = "repo:refs_changed";
    public static final String PULL_REQUEST_OPENED = "pr:opened";
    public static final String PULL_REQUEST_MODIFIED = "pr:modified";
    public static final String PULL_REQUEST_MERGED = "pr:merged";
    public static final String PULL_REQUEST_DECLINED = "pr:declined";
    public static final String PULL_REQUEST_SRC_BRANCH_UPDATED = "pr:from_ref_updated";
    public static final String PULL_REQUEST_DELETED = "pr:deleted";
    public static final String TEAMSCALE_INSIGHT_PREFIX = "Teamscale -";
    private static final int INLINE_COMMENT_CHARACTER_LIMIT = 2000;

    @VisibleForTesting
    public static List<BitbucketServerCodeInsightAnnotation> createCodeInsightAnnotationsFromFindings(List<IReviewComment> reviewComments, BitbucketServerPullRequestDiffs diffs, boolean shouldAddTeamscalePrefix) {
        ArrayList<BitbucketServerCodeInsightAnnotation> annotationsToBeAdded = new ArrayList<BitbucketServerCodeInsightAnnotation>();
        Map<String, List<IReviewComment>> pathToFindings = reviewComments.stream().collect(Collectors.groupingBy(reviewComment -> reviewComment.getLocation().getUniformPath()));
        Map<String, PairList<Integer, Integer>> pathToChangedLinesDiffRangesMap = diffs.getPathToChangedLinesDiffRightSideRangesMap();
        pathToFindings.forEach((path, findingsList) -> annotationsToBeAdded.addAll(BitbucketServerUtils.getCodeInsightAnnotationsForPath(path, findingsList, (PairList<Integer, Integer>)((PairList)pathToChangedLinesDiffRangesMap.get(path)), shouldAddTeamscalePrefix)));
        return annotationsToBeAdded;
    }

    @VisibleForTesting
    static List<BitbucketServerInlinePullRequestComment> createInlineComments(BitBucketServerPullRequestChanges changes, List<IReviewComment> reviewComments, BitbucketServerPullRequestDiffs diffs) {
        ArrayList<BitbucketServerInlinePullRequestComment> commentsToBeAdded = new ArrayList<BitbucketServerInlinePullRequestComment>();
        Map<String, String> pathToSrcPath = changes.getValues().stream().collect(Collectors.toMap(BitbucketServerDiffPath::getPath, BitbucketServerDiffPath::getSrcPath));
        Map<String, List<IReviewComment>> pathToComments = reviewComments.stream().collect(Collectors.groupingBy(reviewComment -> reviewComment.getLocation().getUniformPath()));
        Map<String, PairList<Integer, Integer>> pathToDiffRangesMap = diffs.getPathToDiffRightSideRangesMap();
        Map<String, Map<Integer, Integer>> pathToDiffContextLinesMap = diffs.getPathToDiffLinesMap();
        pathToComments.forEach((path, comments) -> commentsToBeAdded.addAll(BitbucketServerUtils.getInlineCommentsForPath(path, (String)pathToSrcPath.get(path), comments, changes.getToHash(), changes.getFromHash(), (PairList<Integer, Integer>)((PairList)pathToDiffRangesMap.get(path)), (Map)pathToDiffContextLinesMap.get(path))));
        return commentsToBeAdded;
    }

    private static List<BitbucketServerCodeInsightAnnotation> getCodeInsightAnnotationsForPath(String path, List<IReviewComment> reviewComments, PairList<Integer, Integer> diffRanges, boolean shouldAddTeamscalePrefix) {
        ArrayList<BitbucketServerCodeInsightAnnotation> annotations = new ArrayList<BitbucketServerCodeInsightAnnotation>();
        if (BitbucketServerUtils.diffRangesEmpty(diffRanges)) {
            return annotations;
        }
        Map<Integer, List<IReviewComment>> reviewCommentsByLine = reviewComments.stream().collect(Collectors.groupingBy(finding -> BitbucketServerUtils.getCorrespondingDiffLine(finding, diffRanges)));
        reviewCommentsByLine.forEach((line, reviewCommentsForLine) -> annotations.addAll(BitbucketServerUtils.getCodeInsightAnnotations(path, reviewCommentsForLine, line, shouldAddTeamscalePrefix)));
        return annotations;
    }

    private static List<BitbucketServerInlinePullRequestComment> getInlineCommentsForPath(String path, String srcPath, List<IReviewComment> reviewComments, String toHash, String fromHash, PairList<Integer, Integer> diffRanges, Map<Integer, Integer> contextLinesMap) {
        ArrayList<BitbucketServerInlinePullRequestComment> fileComments = new ArrayList<BitbucketServerInlinePullRequestComment>();
        if (BitbucketServerUtils.diffRangesEmpty(diffRanges)) {
            return fileComments;
        }
        Map<Integer, List<IReviewComment>> reviewCommentsByLine = reviewComments.stream().collect(Collectors.groupingBy(finding -> BitbucketServerUtils.getCorrespondingDiffLine(finding, diffRanges)));
        reviewCommentsByLine.forEach((line, reviewCommentsForLine) -> {
            String lineType = "ADDED";
            if (contextLinesMap.containsKey(line)) {
                lineType = "CONTEXT";
                line = (Integer)contextLinesMap.get(line);
            }
            String text = BitbucketServerUtils.buildCompatibleMarkdownCommentContent(line, reviewCommentsForLine);
            fileComments.add(new BitbucketServerInlinePullRequestComment(text, fromHash, toHash, path, srcPath, line.intValue(), lineType));
        });
        return fileComments;
    }

    private static String buildCompatibleMarkdownCommentContent(int line, List<IReviewComment> reviewCommentsForLine) {
        String markdownText = CcpCommentUtils.createInlineCommentMarkdownContent(reviewCommentsForLine, line);
        String compatibleMarkdownText = CcpCommentUtils.convertEscapedMarkdownRelevantSymbolsToHexUnicode(markdownText);
        return BitbucketServerUtils.ensureCommentCharacterLimit(compatibleMarkdownText);
    }

    private static boolean diffRangesEmpty(PairList<Integer, Integer> diffRanges) {
        return CollectionUtils.isNullOrEmpty(diffRanges);
    }

    private static Collection<BitbucketServerCodeInsightAnnotation> getCodeInsightAnnotations(String path, List<IReviewComment> reviewComments, Integer line, boolean shouldAddTeamscalePrefix) {
        return CollectionUtils.map(reviewComments, comment -> BitbucketServerUtils.createCodeInsightAnnotation(path, line, comment, shouldAddTeamscalePrefix));
    }

    private static BitbucketServerCodeInsightAnnotation createCodeInsightAnnotation(String path, Integer line, IReviewComment comment, boolean shouldAddTeamscalePrefix) {
        Object text = shouldAddTeamscalePrefix ? String.join((CharSequence)" ", TEAMSCALE_INSIGHT_PREFIX, comment.getTextWithoutLinks()) : comment.getTextWithoutLinks();
        if (comment.getStartLine() != line.intValue()) {
            text = (String)text + " " + String.format("(comment was moved to visible diff, actual start line: %d)", comment.getStartLine());
        }
        text = BitbucketServerUtils.ensureCommentCharacterLimit((String)text);
        String severity = switch (comment.getAssessment()) {
            case ETrafficLightColor.RED -> "HIGH";
            case ETrafficLightColor.GREEN -> "LOW";
            default -> "MEDIUM";
        };
        String type = switch (comment.getCategory()) {
            case "Security" -> "VULNERABILITY";
            case "Correctness" -> "BUG";
            default -> null;
        };
        return new BitbucketServerCodeInsightAnnotation(path, line, (String)text, severity, comment.getTeamscaleDetailsUrl(), type, "teamscale");
    }

    private static @NonNull String ensureCommentCharacterLimit(String text) {
        if (text.length() > 2000) {
            return text.substring(0, 1997) + "...";
        }
        return text;
    }

    public static int getCorrespondingDiffLine(IReviewComment reviewComment, PairList<Integer, Integer> diffRanges) {
        ElementLocation findingLocation = reviewComment.getLocation();
        if (!(findingLocation instanceof TextRegionLocation)) {
            return BitbucketServerUtils.getClosestLineInDiff(1, diffRanges);
        }
        TextRegionLocation regionLocation = (TextRegionLocation)findingLocation;
        int startLine = regionLocation.getRawStartLine();
        if (BitbucketServerUtils.lineIsInDiff(startLine, diffRanges)) {
            return startLine;
        }
        int endLine = regionLocation.getRawEndLine();
        if (BitbucketServerUtils.lineIsInDiff(endLine, diffRanges)) {
            return endLine;
        }
        return BitbucketServerUtils.getClosestLineInDiff(startLine, diffRanges);
    }

    private static int getClosestLineInDiff(int line, PairList<Integer, Integer> diffRanges) {
        PairList filteredRanges = diffRanges.filter((start, end) -> line < start && line < end);
        if (filteredRanges.isEmpty()) {
            return (Integer)Collections.max(diffRanges.extractSecondList());
        }
        return (Integer)Collections.min(filteredRanges.extractFirstList());
    }

    private static boolean lineIsInDiff(int line, PairList<Integer, Integer> diffRanges) {
        return diffRanges.anyMatch((start, end) -> line >= start && line <= end);
    }

    public static String getHttpCloneUrlFromResponse(BitbucketInstallationRepositories.InstallationRepository repository) throws ConnectorValidationException {
        return repository.getHttpCloneUrl().orElseThrow(() -> new ConnectorValidationException("Missing clone URL in response!"));
    }

    public static String getAnalysisInProgressText(String commitHash) {
        return "Teamscale analysis for commit " + commitHash + " is in progress. Results will be posted as soon as the analysis is complete.";
    }

    private BitbucketServerUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

