/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.debug_dump.dump;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.CommitGraphNode;
import java.time.ZonedDateTime;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class CommitGraphNodeDump {
    @JsonProperty
    public final String name;
    @JsonProperty
    public final String message;
    @JsonProperty
    public final long commitTimestamp;
    @JsonProperty
    public final ZonedDateTime authorTime;
    @JsonProperty
    public final String branchName;
    @JsonProperty
    public final @Nullable List<CommitGraphNodeDump> parents;
    @JsonProperty
    public final @Nullable List<CommitGraphNodeDump> successors;

    @JsonCreator
    public CommitGraphNodeDump(@JsonProperty(value="name") String name, @JsonProperty(value="message") String message, @JsonProperty(value="commitTimestamp") long commitTimestamp, @JsonProperty(value="authorTime") ZonedDateTime authorTime, @JsonProperty(value="branchName") String branchName, @JsonProperty(value="parents") List<CommitGraphNodeDump> parents, @JsonProperty(value="successors") @Nullable List<CommitGraphNodeDump> successors) {
        this.name = name;
        this.message = message;
        this.commitTimestamp = commitTimestamp;
        this.authorTime = authorTime;
        this.branchName = branchName;
        this.parents = parents;
        this.successors = successors;
    }

    public CommitGraphNodeDump(CommitGraphNode commitGraphNode) {
        this(commitGraphNode, true);
    }

    private CommitGraphNodeDump(CommitGraphNode commitGraphNode, boolean isRoot) {
        this.name = commitGraphNode.getName();
        this.branchName = commitGraphNode.getBranchName();
        this.message = commitGraphNode.getCommitMessage();
        this.commitTimestamp = commitGraphNode.getCommitTimestamp();
        this.authorTime = commitGraphNode.getAuthorTime();
        if (isRoot) {
            this.parents = CollectionUtils.map(commitGraphNode.getParents(), node -> new CommitGraphNodeDump((CommitGraphNode)node, false));
            this.successors = CollectionUtils.map(commitGraphNode.getSuccessors(), node -> new CommitGraphNodeDump((CommitGraphNode)node, false));
        } else {
            this.parents = null;
            this.successors = null;
        }
    }
}

