/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.debug_dump.dump;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.repository.git.BranchHeadRef;
import com.teamscale.index.repository.git.debug_dump.dump.CommitGraphNodeDump;
import com.teamscale.index.repository.git.debug_dump.dump.EGitRepositoryDumpState;
import com.teamscale.index.repository.git.debug_dump.dump.GitConnectorConfigurationDump;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDump;
import com.teamscale.index.repository.git.debug_dump.dump.RefDump;
import com.teamscale.index.repository.git.debug_dump.dump.RevCommitDump;
import com.teamscale.index.repository.git.labeling.GitBranchPrioritizer;
import com.teamscale.index.repository.git.labeling.IBranchLabeler;
import com.teamscale.index.repository.git.labeling.MergeMessageParser;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.index.shared.GitRefUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.resources.Resource;
import org.jspecify.annotations.NonNull;

public class GitRepositoryDebugDumpAnonymizer {
    private static final Random RANDOM = new Random();
    private final Map<EGitRepositoryDumpState, GitRepositoryDump> repositoryDumpsByState;
    private final Map<EGitRepositoryDumpState, Map<String, String>> branchNamesByCommitNameByState;
    private final Map<EGitRepositoryDumpState, String> initialDefaultBranchRootRevision;
    private final Map<EGitRepositoryDumpState, IChangeRetrieverCommitTree> commitTreesByState;
    private final Map<EGitRepositoryDumpState, Map<String, CommitGraphNodeDump>> commitGraphsByState;
    private final Map<EGitRepositoryDumpState, Collection<BranchHeadRef>> branchHeadRefs;
    private final GitConnectorConfigurationDump configurationDump;
    private final Map<Integer, Set<String>> importantBranchesByPriority = new HashMap<Integer, Set<String>>();
    private final Set<String> excludedBranches = new HashSet<String>();
    private final Map<String, String> anonymizedBranchNamesByOriginalBranchName = new HashMap<String, String>();
    private final MergeMessageParser mergeMessageParser = MergeMessageParser.createInstance();

    private GitRepositoryDebugDumpAnonymizer(Map<EGitRepositoryDumpState, GitRepositoryDump> repositoryDumpsByState, Map<EGitRepositoryDumpState, Map<String, String>> branchNamesByCommitNameByState, Map<EGitRepositoryDumpState, String> initialDefaultBranchRootRevision, Map<EGitRepositoryDumpState, IChangeRetrieverCommitTree> commitTreesByState, Map<EGitRepositoryDumpState, Map<String, CommitGraphNodeDump>> commitGraphsByState, Map<EGitRepositoryDumpState, Collection<BranchHeadRef>> branchHeadRefs, GitConnectorConfigurationDump configurationDump) {
        this.repositoryDumpsByState = repositoryDumpsByState;
        this.branchNamesByCommitNameByState = branchNamesByCommitNameByState;
        this.initialDefaultBranchRootRevision = initialDefaultBranchRootRevision;
        this.commitTreesByState = commitTreesByState;
        this.commitGraphsByState = commitGraphsByState;
        this.branchHeadRefs = branchHeadRefs;
        this.configurationDump = configurationDump;
    }

    public static GitRepositoryDebugDumpAnonymizer createAnonymizer(Map<EGitRepositoryDumpState, GitRepositoryDump> repositoryDumpsByState, Map<EGitRepositoryDumpState, Map<String, String>> branchNamesByCommitNameByState, Map<EGitRepositoryDumpState, String> initialDefaultBranchRootRevision, Map<EGitRepositoryDumpState, IChangeRetrieverCommitTree> commitTreesByState, Map<EGitRepositoryDumpState, Map<String, CommitGraphNodeDump>> commitGraphsByState, Map<EGitRepositoryDumpState, Collection<BranchHeadRef>> branchHeadRefs, GitConnectorConfigurationDump configurationDump) {
        GitRepositoryDebugDumpAnonymizer anonymizer = new GitRepositoryDebugDumpAnonymizer(repositoryDumpsByState, branchNamesByCommitNameByState, initialDefaultBranchRootRevision, commitTreesByState, commitGraphsByState, branchHeadRefs, configurationDump);
        anonymizer.computeAnonymizedBranchMapping();
        return anonymizer;
    }

    private void computeAnonymizedBranchMapping() {
        List<String> branchNamesToAnonymize = this.collectBranchNamesToAnonymize();
        SetMap prefixMatches = GitBranchPrioritizer.BranchNameSuggestions.getPrefixMatches(branchNamesToAnonymize).invert();
        List<String> anonymizationCandidates = GitRepositoryDebugDumpAnonymizer.getAnonymizationCandidates(branchNamesToAnonymize.size());
        ListIterator<String> anonymizationCandidateIterator = anonymizationCandidates.listIterator();
        PatternList importantBranchesPatterns = this.getImportantBranchesPatterns();
        for (String branchName : branchNamesToAnonymize) {
            if (GitRefUtils.isAnonymousBranchName((String)branchName)) {
                this.anonymizedBranchNamesByOriginalBranchName.putIfAbsent(branchName, branchName);
                continue;
            }
            StringBuilder anonymizedBranchName = new StringBuilder();
            if (prefixMatches.getKeys().contains((Object)branchName)) {
                String prefix = this.anonymizedBranchNamesByOriginalBranchName.get(Objects.requireNonNull((Set)prefixMatches.getCollection((Object)branchName)).stream().max(Comparator.comparingInt(String::length)).orElseThrow());
                anonymizedBranchName.append(prefix).append("-");
            }
            anonymizedBranchName.append(anonymizationCandidateIterator.next());
            if (importantBranchesPatterns.matchesAny(branchName)) {
                int priority = GitBranchPrioritizer.BranchNameSuggestions.determineBranchPriority(branchName, importantBranchesPatterns);
                this.importantBranchesByPriority.putIfAbsent(priority, new HashSet());
                this.importantBranchesByPriority.get(priority).add(anonymizedBranchName.toString());
            }
            if (this.configurationDump.branchExcludePatterns.stream().anyMatch(pattern -> pattern.matcher(branchName).matches())) {
                this.excludedBranches.add(anonymizedBranchName.toString());
            }
            this.anonymizedBranchNamesByOriginalBranchName.putIfAbsent(branchName, anonymizedBranchName.toString());
        }
    }

    private PatternList getImportantBranchesPatterns() {
        return new PatternList(this.configurationDump.importantBranchPatterns);
    }

    private List<String> collectBranchNamesToAnonymize() {
        HashSet<String> branchNamesToAnonymize = new HashSet<String>();
        branchNamesToAnonymize.addAll(GitRepositoryDebugDumpAnonymizer.extractBranchNames(this.branchNamesByCommitNameByState, s -> s.map(Map::values).flatMap(Collection::stream)));
        branchNamesToAnonymize.addAll(GitRepositoryDebugDumpAnonymizer.extractBranchNames(this.commitGraphsByState, s -> s.map(Map::values).flatMap(Collection::stream).map(node -> node.branchName)));
        branchNamesToAnonymize.addAll(GitRepositoryDebugDumpAnonymizer.extractBranchNames(this.commitGraphsByState, s -> s.map(Map::values).flatMap(Collection::stream).map(node -> node.message).map(this::tryToExtractParentsFromMergeMessage).flatMap(parents -> Stream.of(parents.firstParent(), parents.secondParent())).filter(Optional::isPresent).map(Optional::get)));
        branchNamesToAnonymize.addAll(GitRepositoryDebugDumpAnonymizer.extractBranchNames(this.commitTreesByState, s -> s.map(ICommitTree::getAllNodes).flatMap(Collection::stream).map(ICommitTreeNode::getRevision).map(CommitTreeRevision::getBranchName)));
        branchNamesToAnonymize.addAll(GitRepositoryDebugDumpAnonymizer.extractBranchNames(this.repositoryDumpsByState, s -> s.map(repoDump -> repoDump.refs).flatMap(Collection::stream).map(GitRepositoryDebugDumpAnonymizer::extractBranchNameFromRef)));
        branchNamesToAnonymize.addAll(GitRepositoryDebugDumpAnonymizer.extractBranchNames(this.repositoryDumpsByState, s -> s.map(repoDump -> repoDump.commits).flatMap(Collection::stream).map(commit -> commit.message).map(this::tryToExtractParentsFromMergeMessage).flatMap(parents -> Stream.of(parents.firstParent(), parents.secondParent())).filter(Optional::isPresent).map(Optional::get)));
        branchNamesToAnonymize.addAll(GitRepositoryDebugDumpAnonymizer.extractBranchNames(this.branchHeadRefs, s -> s.flatMap(Collection::stream).map(BranchHeadRef::branchName)));
        return CollectionUtils.sort(branchNamesToAnonymize);
    }

    private static <T> Set<String> extractBranchNames(Map<EGitRepositoryDumpState, T> map, Function<Stream<T>, Stream<String>> extractor) {
        return extractor.apply(map.values().stream()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static List<String> getAnonymizationCandidates(int numberOfCandidates) {
        List<String> words = GitRepositoryDebugDumpAnonymizer.readWordList();
        HashSet candidates = HashSet.newHashSet(numberOfCandidates);
        while (candidates.size() < numberOfCandidates) {
            int randomIndex = RANDOM.nextInt(words.size());
            String first = words.get(randomIndex);
            randomIndex = RANDOM.nextInt(words.size());
            String second = words.get(randomIndex);
            candidates.add(first + "-" + second);
        }
        return CollectionUtils.sort(candidates);
    }

    private static List<String> readWordList() {
        return Resource.of(GitRepositoryDebugDumpAnonymizer.class, (String)"wordlist.txt").getLines();
    }

    public Map<EGitRepositoryDumpState, IChangeRetrieverCommitTree> getAnonymizedCommitTreesByState() {
        HashMap<EGitRepositoryDumpState, IChangeRetrieverCommitTree> anonymizedCommitTreesByState = HashMap.newHashMap(this.commitTreesByState.size());
        this.commitTreesByState.forEach((state, commitTree) -> anonymizedCommitTreesByState.put((EGitRepositoryDumpState)((Object)state), commitTree.deepAnonymizedCopy(this::anonymizeBranchName)));
        return anonymizedCommitTreesByState;
    }

    public Map<EGitRepositoryDumpState, String> getInitialDefaultBranchRootRevision() {
        return this.initialDefaultBranchRootRevision;
    }

    public Map<EGitRepositoryDumpState, Map<String, CommitGraphNodeDump>> getAnonymizedCommitGraphsByState() {
        HashMap<EGitRepositoryDumpState, Map<String, CommitGraphNodeDump>> anonymizedCommitGraphsByState = HashMap.newHashMap(this.commitGraphsByState.size());
        this.commitGraphsByState.forEach((state, commitGraph) -> anonymizedCommitGraphsByState.put((EGitRepositoryDumpState)((Object)state), this.getAnonymizedCommitGraph((Map<String, CommitGraphNodeDump>)commitGraph)));
        return anonymizedCommitGraphsByState;
    }

    private Map<String, CommitGraphNodeDump> getAnonymizedCommitGraph(Map<String, CommitGraphNodeDump> commitGraph) {
        HashMap<String, CommitGraphNodeDump> anonymizedCommitGraph = HashMap.newHashMap(commitGraph.size());
        commitGraph.forEach((revision, commitGraphNodeDump) -> anonymizedCommitGraph.put((String)revision, this.getAnonymizedCommitGraphNodeDump((CommitGraphNodeDump)commitGraphNodeDump)));
        return anonymizedCommitGraph;
    }

    private CommitGraphNodeDump getAnonymizedCommitGraphNodeDump(CommitGraphNodeDump commitGraphNodeDump) {
        List anonymizedParents = Optional.ofNullable(commitGraphNodeDump.parents).map(parents -> CollectionUtils.map((Collection)parents, this::getAnonymizedCommitGraphNodeDump)).orElse(null);
        List anonymizedSuccessors = Optional.ofNullable(commitGraphNodeDump.successors).map(successors -> CollectionUtils.map((Collection)successors, this::getAnonymizedCommitGraphNodeDump)).orElse(null);
        return new CommitGraphNodeDump(commitGraphNodeDump.name, this.getAnonymizedCommitMessage(commitGraphNodeDump.message), commitGraphNodeDump.commitTimestamp, commitGraphNodeDump.authorTime, this.anonymizeBranchName(commitGraphNodeDump.branchName), anonymizedParents, anonymizedSuccessors);
    }

    public Map<EGitRepositoryDumpState, Map<String, String>> getAnonymizedBranchNamesByCommitNameByState() {
        HashMap<EGitRepositoryDumpState, Map<String, String>> anonymizedBranchNamesByCommitNameByState = HashMap.newHashMap(this.branchNamesByCommitNameByState.size());
        for (Map.Entry<EGitRepositoryDumpState, Map<String, String>> entry : this.branchNamesByCommitNameByState.entrySet()) {
            anonymizedBranchNamesByCommitNameByState.put(entry.getKey(), this.anonymizeBranchNamesByCommitName(entry.getValue()));
        }
        return anonymizedBranchNamesByCommitNameByState;
    }

    private Map<String, String> anonymizeBranchNamesByCommitName(Map<String, String> branchNamesByCommitName) {
        HashMap<String, String> anonymizedBranchNamesByCommitName = HashMap.newHashMap(this.anonymizedBranchNamesByOriginalBranchName.size());
        branchNamesByCommitName.forEach((commitName, branchName) -> anonymizedBranchNamesByCommitName.put((String)commitName, this.anonymizeBranchName((String)branchName)));
        return anonymizedBranchNamesByCommitName;
    }

    public Map<EGitRepositoryDumpState, GitRepositoryDump> getAnonymizedRepositoryDumpsByState() {
        HashMap<EGitRepositoryDumpState, GitRepositoryDump> anonymizedRepositoryDumpsByState = HashMap.newHashMap(this.repositoryDumpsByState.size());
        for (Map.Entry<EGitRepositoryDumpState, GitRepositoryDump> entry : this.repositoryDumpsByState.entrySet()) {
            anonymizedRepositoryDumpsByState.put(entry.getKey(), this.anonymizeRepositoryDump(entry.getValue()));
        }
        return anonymizedRepositoryDumpsByState;
    }

    public Map<EGitRepositoryDumpState, Collection<BranchHeadRef>> getAnonymizedBranchHeadRefsByState() {
        return this.branchHeadRefs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> CollectionUtils.map((Collection)((Collection)entry.getValue()), this::anonymizeBranchHeadRef)));
    }

    private @NonNull BranchHeadRef anonymizeBranchHeadRef(BranchHeadRef branchHeadRef) {
        return new BranchHeadRef(this.anonymizeBranchName(branchHeadRef.branchName()), branchHeadRef.headRevision());
    }

    private RefDump anonymizeRefDump(RefDump ref) {
        RefDump anonymizedTargetRef = Optional.ofNullable(ref.target).map(this::anonymizeRefDump).orElse(null);
        String branchName = GitRepositoryDebugDumpAnonymizer.extractBranchNameFromRef(ref);
        String anonymizedRefName = "refs/heads/" + this.anonymizeBranchName(branchName);
        return new RefDump(anonymizedRefName, ref.objectId, ref.peeledObjectId, anonymizedTargetRef);
    }

    private static String extractBranchNameFromRef(RefDump ref) {
        return org.conqat.lib.commons.string.StringUtils.stripPrefix((String)ref.name, (String)"refs/heads/");
    }

    private GitRepositoryDump anonymizeRepositoryDump(GitRepositoryDump repositoryDump) {
        List<RefDump> refs = repositoryDump.refs.stream().filter(ref -> ref.name.startsWith("refs/heads/")).map(this::anonymizeRefDump).toList();
        List<RevCommitDump> revCommits = repositoryDump.commits.stream().map(revCommitDump -> {
            String anonymizedMessage = this.getAnonymizedCommitMessage(revCommitDump.message);
            return new RevCommitDump(revCommitDump.name, anonymizedMessage, revCommitDump.parentNames, revCommitDump.getTime());
        }).toList();
        return new GitRepositoryDump(refs, revCommits);
    }

    private String getAnonymizedCommitMessage(String message) {
        MergeMessageParser.ParentMatchResult branchesFromMergeMessage = this.tryToExtractParentsFromMergeMessage(message);
        Optional<String> anonymizedFirstBranch = branchesFromMergeMessage.firstParent().map(this::anonymizeBranchName);
        Optional<String> anonymizedSecondBranch = branchesFromMergeMessage.secondParent().map(this::anonymizeBranchName);
        if (anonymizedFirstBranch.isPresent() && anonymizedSecondBranch.isPresent()) {
            return "Merge branch '" + anonymizedSecondBranch.get() + "' into '" + anonymizedFirstBranch.get() + "'";
        }
        if (anonymizedSecondBranch.isPresent()) {
            return "Merge branch '" + anonymizedSecondBranch.get() + "'";
        }
        if (anonymizedFirstBranch.isPresent()) {
            return "Merge branch <suppressed> into '" + anonymizedFirstBranch.get() + "'";
        }
        return "Regular commit or unrecognized merge message.";
    }

    private @NonNull MergeMessageParser.ParentMatchResult tryToExtractParentsFromMergeMessage(String message) {
        return this.mergeMessageParser.tryToExtractParentsFromMergeMessage(message, IBranchLabeler.noOpBranchLabeler());
    }

    public GitConnectorConfigurationDump getAnonymizedConfigurationDump() {
        return new GitConnectorConfigurationDump(this.anonymizeBranchName(this.configurationDump.defaultBranchName), new IncludeExcludeRegexSupport(List.of(".*"), this.excludedBranches.stream().toList()), this.getAnonymizedImportantBranchesPatternList(), this.configurationDump.startRevisionOrDate, this.configurationDump.endRevisionOrDate, this.configurationDump.branchingEnabled, this.configurationDump.keepResurrectedBranchHistory);
    }

    private PatternList getAnonymizedImportantBranchesPatternList() {
        List importantBranchPrioritiesSorted = CollectionUtils.sort(this.importantBranchesByPriority.keySet(), Comparator.comparingInt(i -> i).reversed());
        ArrayList<CallSite> importantBranchesOrdered = new ArrayList<CallSite>();
        Iterator iterator = importantBranchPrioritiesSorted.iterator();
        while (iterator.hasNext()) {
            int priority = (Integer)iterator.next();
            importantBranchesOrdered.add((CallSite)((Object)(StringUtils.getCommonPrefix((String[])((String[])this.importantBranchesByPriority.get(priority).toArray(String[]::new))) + ".*")));
        }
        return new PatternList((Collection)CollectionUtils.map(importantBranchesOrdered, Pattern::compile));
    }

    private String anonymizeBranchName(String branchName) {
        return this.anonymizedBranchNamesByOriginalBranchName.get(branchName);
    }

    public Map<String, String> getAnonymizedBranchNamesByOriginalBranchName() {
        return this.anonymizedBranchNamesByOriginalBranchName;
    }
}

