/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.debug_dump.dump;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.revwalk.RevCommit;

public class RevCommitDump {
    @JsonProperty
    public final String name;
    @JsonProperty
    public final String message;
    @JsonProperty
    public final List<String> parentNames;
    @JsonProperty
    private final long time;

    @JsonCreator
    public RevCommitDump(@JsonProperty(value="name") String name, @JsonProperty(value="message") String message, @JsonProperty(value="parentNames") List<String> parentNames, @JsonProperty(value="time") long time) {
        this.name = name;
        this.message = message;
        this.parentNames = parentNames;
        this.time = time;
    }

    public RevCommitDump(RevCommit revCommit) {
        this.name = revCommit.getName();
        this.message = revCommit.getFullMessage();
        this.time = revCommit.getCommitterIdent().getWhen().getTime();
        this.parentNames = new ArrayList<String>();
        for (RevCommit parent : revCommit.getParents()) {
            this.parentNames.add(parent.getName());
        }
    }

    public long getTime() {
        return this.time;
    }
}

