/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.log.interaction.InteractionLogMessage;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.rest.client.authentication.ERestClientAuthenticationMode;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.index.blacklisting.FindingBlacklistCommit;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.blacklisting.FindingBlacklistStagingIndex;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.merge_request.comments.ReviewCommentEngine;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.merge_request.voting.VotingRecorder;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.VotingRequirementsChecker;
import com.teamscale.index.repository.git.gerrit.GerritAnalysisResultUploader;
import com.teamscale.index.repository.git.gerrit.GerritConfigurationParameters;
import com.teamscale.index.repository.git.gerrit.GerritTriggerBase;
import com.teamscale.index.repository.git.gerrit.GerritUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class GerritFindingBlacklistTrigger
extends GerritTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource.Named(index=CommitTreeIndex.class, name="finding-blacklist-commit-tree")
    private KeyDelta commitTreeDelta;
    @BranchingLayerAccess(value=FindingBlacklistStagingIndex.class)
    private IBranchingLayer findingBlacklistStagingBranchingLayer;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TimestampAdjustmentIndex timestampAdjustmentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalResultsPartitionLastUpdateIndex externalResultsPartitionLastUpdateIndex;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_ONLY)
    private CommitTreeIndex commitTreeIndex;

    public void execute() throws StorageException {
        CommitDescriptor schedulingCommit = this.getSchedulingCommit();
        if (!GerritUtils.isGerritBranch(schedulingCommit.getBranchName())) {
            return;
        }
        if (ShadowModeOption.isShadowModeEnabled((ServerOptionIndex)this.serverOptionIndex) || !this.projectHasGerritConnector()) {
            return;
        }
        if (!this.isVotingOrCommentingEnabled()) {
            return;
        }
        AnalysisState analysisState = this.branchAnalysisStateIndex.getAnalysisState(schedulingCommit.getBranchName());
        if (!VotingRequirementsChecker.isVotingOrCommentingRelevantAnalysisState(Objects.requireNonNull(analysisState).getState())) {
            return;
        }
        OptionalLong originalTimestamp = this.timestampAdjustmentIndex.getOriginalTimestamp(schedulingCommit.getBranchName(), schedulingCommit.getTimestamp());
        CommitDescriptor commitToRead = new CommitDescriptor(schedulingCommit.getBranchName(), originalTimestamp.orElse(schedulingCommit.getTimestamp()));
        FindingBlacklistCommit findingBlacklistCommit = (FindingBlacklistCommit)((Object)GerritFindingBlacklistTrigger.openFindingBlacklistStagingIndex(commitToRead, this.findingBlacklistStagingBranchingLayer).getCommitInfo());
        if (findingBlacklistCommit == null) {
            LOGGER.error(LoggingUtils.INTERACTION, "No finding flagging commit found for commit " + String.valueOf(commitToRead));
        } else {
            this.processBlacklistCommit(findingBlacklistCommit);
        }
    }

    private void processBlacklistCommit(FindingBlacklistCommit findingBlacklistCommit) throws StorageException {
        HashSet<String> scheduledBranches = new HashSet<String>();
        String branchName = findingBlacklistCommit.getCommit().getBranchName();
        for (FindingBlacklistEvent findingBlacklistEvent : findingBlacklistCommit.getBlacklistEvents()) {
            if (!scheduledBranches.add(branchName)) continue;
            Optional<CommitDescriptor> schedulingCommit = GerritUtils.getLastRealCommitOnBranch(this.indexes.commitDescriptorIndex.getCommitsForBranch(branchName), this.indexes.repositoryLogIndex).map(ParentedCommitDescriptor::getCommit);
            if (schedulingCommit.isEmpty()) {
                LOGGER.error(LoggingUtils.INTERACTION, "Could not find viable commit on branch of: " + branchName);
                continue;
            }
            if (this.votingRecordIndex.isMarkedAsSuccessfullyVotedAtTimestampOrNewer(schedulingCommit.get(), findingBlacklistCommit.getCommit().getTimestamp())) continue;
            GerritConfigurationParameters gerritConfigurationParameters = new GerritConfigurationParameters(this.isIgnoreYellowFindingsForVotesEnabled, this.isIgnoreYellowFindingsForCommentsEnabled, this.isDetailedLineCommentsEnabled, this.isVotingEnabled);
            CommitTree commitTree = this.commitTreeIndex.loadTree();
            if (CommitVotingTriggerBase.isNotLatestCommitOnBranch(schedulingCommit.get(), commitTree)) {
                return;
            }
            String reason = "Voted after finding flagging event " + String.valueOf((Object)findingBlacklistEvent.getType()) + ": " + findingBlacklistEvent.getBlacklistInfo().map(FindingBlacklistInfo::getTimestamp).map(String::valueOf).orElse("No timestamp available.");
            new VotingRecorder(this.getProjectId(), this.votingRecordIndex, this.indexes.repositoryLogIndex, this.externalResultsPartitionLastUpdateIndex, schedulingCommit.get(), reason).record(() -> this.executeVoting(findingBlacklistEvent, (CommitDescriptor)schedulingCommit.get(), gerritConfigurationParameters, reason));
        }
    }

    private VotingRecorder.VotingResult executeVoting(FindingBlacklistEvent findingBlacklistEvent, CommitDescriptor schedulingCommit, GerritConfigurationParameters gerritConfigurationParameters, String reason) throws StorageException, VotingException {
        TeamscaleCommitLinkProvider linkProvider = new TeamscaleCommitLinkProvider(BaseUrlOption.getBaseUrl((ServerOptionIndex)this.serverOptionIndex), this.getProjectId(), schedulingCommit.toUnresolvedCommitDescriptor());
        ReviewCommentEngine reviewCommentEngine = this.createReviewCommentEngine(schedulingCommit, linkProvider);
        String repositoryIdentifier = GerritFindingBlacklistTrigger.getGerritRepositoryConnector(this.indexes.metaIndex).getIdentifier();
        ExternalCredentials accountCredentials = this.getAccountCredentials();
        GerritAnalysisResultUploader gerritAnalysisResultUploader = new GerritAnalysisResultUploader(schedulingCommit, findingBlacklistEvent.serialize(), this.reviewLabel, ERestClientAuthenticationMode.fromId((String)this.restClientAuthenticationModeName), this.indexes, this.reviewCommentTriggerParameters.getTrackedFindingsByIdIndex(), null, gerritConfigurationParameters, linkProvider, accountCredentials, this.getVoteIncludeSupport(), repositoryIdentifier, reviewCommentEngine, false, null, null, false);
        VotingRecord.EVotingState vote = gerritAnalysisResultUploader.execute();
        LOGGER.info(LoggingUtils.INTERACTION, (Message)new InteractionLogMessage(reason, accountCredentials.uri, repositoryIdentifier));
        long voteTime = System.currentTimeMillis();
        Optional<Long> tolerationTimestamp = findingBlacklistEvent.getBlacklistInfo().map(FindingBlacklistInfo::getTimestamp);
        Long timeToVote = null;
        if (tolerationTimestamp.isPresent()) {
            timeToVote = voteTime - tolerationTimestamp.get();
        }
        return new VotingRecorder.VotingResult(vote, timeToVote, Collections.emptyList());
    }

    private static FindingBlacklistStagingIndex openFindingBlacklistStagingIndex(CommitDescriptor currentCommit, IBranchingLayer findingBlacklistStagingBranchingLayer) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)currentCommit.getBranchName(), (long)currentCommit.getTimestamp());
        return new FindingBlacklistStagingIndex(findingBlacklistStagingBranchingLayer.openStore(historyAccessOption));
    }

    private boolean projectHasGerritConnector() throws StorageException {
        return !GerritFindingBlacklistTrigger.getGerritConnectors(this.indexes.metaIndex).isEmpty();
    }

    public static ConnectorConfiguration getGerritRepositoryConnector(MetaIndex projectMetaIndex) throws StorageException, AssertionError {
        List<ConnectorConfiguration> connectors = GerritFindingBlacklistTrigger.getGerritConnectors(projectMetaIndex);
        CCSMAssert.isFalse((connectors.size() > 1 ? 1 : 0) != 0, (String)"Only ever works for a single gerrit connector per project. Using more than one is not supported.");
        return (ConnectorConfiguration)CollectionUtils.getAny(connectors);
    }

    public static List<ConnectorConfiguration> getGerritConnectors(MetaIndex projectMetaIndex) throws StorageException {
        ProjectConfiguration config = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        return config.getConnectorsByType((IConnectorEnum)ERepositoryConnector.GERRIT);
    }
}

