/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitea;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.HttpPaginationUtils;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.gitea.IGiteaApi;
import com.teamscale.index.repository.git.gitea.data.GiteaChangedFile;
import com.teamscale.index.repository.git.gitea.data.GiteaCommitStatus;
import com.teamscale.index.repository.git.gitea.data.GiteaCommitStatusCreate;
import com.teamscale.index.repository.git.gitea.data.GiteaIssueComment;
import com.teamscale.index.repository.git.gitea.data.GiteaIssueCommentCreate;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequest;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestPatch;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestReview;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestReviewComment;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestReviewCreate;
import com.teamscale.index.repository.git.gitea.data.GiteaRepository;
import com.teamscale.index.repository.git.gitea.data.GiteaWebhook;
import com.teamscale.index.repository.git.gitea.data.GiteaWebhookConfig;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class GiteaClient {
    @VisibleForTesting
    public static final int PAGE_LIMIT = 10000;
    private final IGiteaApi gitea;

    public GiteaClient(String baseUrl, @Nullable String username, String password, Logger interactionLogger) {
        this.gitea = (IGiteaApi)GiteaClient.configureAuthenticationMode(Retrofit.builder((String)baseUrl), username, password).withInteractionLogger(interactionLogger).create(IGiteaApi.class);
    }

    private static Retrofit.Builder configureAuthenticationMode(Retrofit.Builder builder, @Nullable String username, String passwordOrToken) {
        if (StringUtils.isEmpty((String)username)) {
            return builder.withBearerAuthentication(passwordOrToken);
        }
        return builder.withBasicNTLMAuthentication(username, passwordOrToken);
    }

    public GiteaRepository getRepository(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return this.gitea.getRepository(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo());
    }

    public List<GiteaPullRequest> getOpenPullRequests(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitea.getOpenPullRequests(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), 10000), this.gitea::getOpenPullRequestsFromNextPage);
    }

    public GiteaPullRequest getPullRequest(PlatformRepositoryIdentifier repositoryIdentifier, long number) throws ServiceCallException {
        return this.gitea.getPullRequest(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), number);
    }

    public void updatePullRequest(PlatformRepositoryIdentifier repositoryIdentifier, long number, GiteaPullRequestPatch pullRequest) throws ServiceCallException {
        this.gitea.updatePullRequest(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), number, pullRequest);
    }

    public List<GiteaWebhook> getRepositoryWebhooks(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitea.getWebhooks(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), 10000), this.gitea::getWebhooksFromNextPage);
    }

    public void createRepositoryWebhook(PlatformRepositoryIdentifier repositoryIdentifier, String webhookUrl, String[] events) throws ServiceCallException {
        this.gitea.postWebhook(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), new GiteaWebhook(true, events, "gitea", "*", new GiteaWebhookConfig(webhookUrl, "json")));
    }

    public List<GiteaPullRequestReview> getPullRequestReviews(PlatformRepositoryIdentifier repositoryIdentifier, long number) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitea.getPullRequestReviews(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), number, 10000), this.gitea::getPullRequestReviewsFromNextPage);
    }

    public List<GiteaPullRequestReviewComment> getPullRequestReviewComments(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestNumber, int reviewId) throws ServiceCallException {
        return List.of(this.gitea.getPullRequestReviewComments(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestNumber, reviewId));
    }

    public void createPullRequestReview(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestNumber, GiteaPullRequestReviewCreate review) throws ServiceCallException {
        this.gitea.postPullRequestReview(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestNumber, review);
    }

    public void deletePullRequestReview(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestNumber, Integer reviewId) throws ServiceCallException {
        this.gitea.deletePullRequestReview(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestNumber, reviewId);
    }

    public List<GiteaChangedFile> getPullRequestChangedFiles(PlatformRepositoryIdentifier repositoryIdentifier, long number) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitea.getPullRequestChangedFiles(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), number, 10000), this.gitea::getPullRequestChangedFilesFromNextPage);
    }

    public void postCommitStatus(PlatformRepositoryIdentifier repositoryIdentifier, String commitSha, GiteaCommitStatusCreate commitStatus) throws ServiceCallException {
        this.gitea.postCommitStatus(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commitSha, commitStatus);
    }

    public List<GiteaCommitStatus> getCommitStatuses(PlatformRepositoryIdentifier repositoryIdentifier, String commitSha) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitea.getCommitStatuses(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commitSha, 10000), this.gitea::getCommitStatusesFromNextPage);
    }

    public List<GiteaIssueComment> getIssueComments(PlatformRepositoryIdentifier repositoryIdentifier, long issueIndex) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitea.getIssueComments(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), issueIndex, 10000), this.gitea::getIssueCommentsFromNextPage);
    }

    public void postIssueComment(PlatformRepositoryIdentifier repositoryIdentifier, Integer issueIndex, GiteaIssueCommentCreate issueComment) throws ServiceCallException {
        this.gitea.postIssueComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), issueIndex, issueComment);
    }

    public void deleteIssueComment(PlatformRepositoryIdentifier repositoryIdentifier, Integer issueIndex, Integer issueCommentId) throws ServiceCallException {
        this.gitea.deleteIssueComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), issueIndex, issueCommentId);
    }
}

