/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitea;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.merge_request.MergeRequestSynchronizerBase;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import com.teamscale.index.repository.git.gitea.GiteaChangeRetriever;
import com.teamscale.index.repository.git.gitea.GiteaClient;
import com.teamscale.index.repository.git.gitea.GiteaMergeRequestProvider;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

public class GiteaMergeRequestSynchronizer
extends MergeRequestSynchronizerBase<GiteaMergeRequestProvider, GiteaPullRequest> {
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameter(value="repository-path")
    private String repositoryPath;
    @StepParameter(value="account-identifier")
    private String accountIdentifier;

    @Override
    protected GiteaMergeRequestProvider createMergeRequestProvider() throws StorageException, ServiceCallException {
        ExternalCredentials credentials = this.getExternalCredentials(this.accountIdentifier);
        GiteaClient client = new GiteaClient(credentials.uri, credentials.username, credentials.password, LOGGER);
        return new GiteaMergeRequestProvider(this.repositoryPath, client);
    }

    @Override
    protected String getRepositoryPath() {
        return this.repositoryPath;
    }

    @Override
    protected Class<? extends RepositoryChangeRetrieverBase> getChangeRetrieverClass() {
        return GiteaChangeRetriever.class;
    }
}

