/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitea;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.gitea.GiteaClient;
import com.teamscale.index.repository.git.gitea.data.GiteaRepository;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;

public final class GiteaUtils {
    public static final String MAIN_BRANCH = "main";

    public static String getRepositoryCloneUrl(GiteaClient client, String repositoryName) throws ConnectorValidationException {
        GiteaRepository repository;
        try {
            repository = client.getRepository(PlatformRepositoryIdentifier.fromRepositoryPath(repositoryName));
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
        return Optional.ofNullable(repository.cloneUrl()).orElseThrow(() -> new ConnectorValidationException("Could not retrieve clone URL for repository: " + repositoryName));
    }

    public static URI getRepositoryCloneUri(@NonNull ConnectorConfiguration connectorConfiguration, @NonNull ExternalCredentials credentials, @NonNull Logger logger) throws ProjectConfigurationException, RepositoryException {
        GiteaClient client = new GiteaClient(credentials.uri, credentials.username, credentials.password, logger);
        String repositoryPath = Optional.ofNullable(connectorConfiguration.getOptionValue("Repository Path")).orElseThrow(() -> new ProjectConfigurationException("Repository path is null."));
        String url = GiteaUtils.getRepositoryCloneUrl(client, repositoryPath);
        try {
            return UrlUtils.parseUri((String)url);
        }
        catch (URISyntaxException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private GiteaUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

