/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitea;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.repository.git.gitea.data.GiteaChangedFile;
import com.teamscale.index.repository.git.gitea.data.GiteaCommitStatus;
import com.teamscale.index.repository.git.gitea.data.GiteaCommitStatusCreate;
import com.teamscale.index.repository.git.gitea.data.GiteaIssueComment;
import com.teamscale.index.repository.git.gitea.data.GiteaIssueCommentCreate;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequest;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestPatch;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestReview;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestReviewComment;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequestReviewCreate;
import com.teamscale.index.repository.git.gitea.data.GiteaRepository;
import com.teamscale.index.repository.git.gitea.data.GiteaWebhook;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface IGiteaApi
extends IRetrofitApi {
    public static final String REST_API_BASE_PATH = "api/v1/";
    public static final String REPO_OWNER_PARAMETER_NAME = "owner";
    public static final String REPO_NAME_PARAMETER_NAME = "repo";
    public static final String PAGE_LIMIT_PARAMETER_NAME = "limit";
    public static final String PULL_REQUEST_NUMBER_PARAMETER_NAME = "number";
    public static final String PULL_REQUEST_REVIEW_ID_PARAMETER_NAME = "id";
    public static final String COMMIT_SHA_PARAMETER_NAME = "sha";
    public static final String ISSUE_INDEX_PARAMETER_NAME = "index";
    public static final String ISSUE_COMMENT_ID_PARAMETER_NAME = "id";
    public static final String REPOSITORY_API_ENDPOINT = "api/v1/repos/{owner}/{repo}";
    public static final String REPOSITORY_WEBHOOKS_API_ENDPOINT = "api/v1/repos/{owner}/{repo}/hooks";
    public static final String PULL_REQUESTS_API_ENDPOINT = "api/v1/repos/{owner}/{repo}/pulls";
    public static final String SINGLE_PULL_REQUEST_API_ENDPOINT = "api/v1/repos/{owner}/{repo}/pulls/{number}";
    public static final String PULL_REQUEST_REVIEWS_API_ENDPOINT = "api/v1/repos/{owner}/{repo}/pulls/{number}/reviews";
    public static final String SINGLE_PULL_REQUEST_REVIEW_API_ENDPOINT = "api/v1/repos/{owner}/{repo}/pulls/{number}/reviews/{id}";
    public static final String COMMIT_STATUS_ENDPOINT = "api/v1/repos/{owner}/{repo}/statuses/{sha}";
    public static final String ISSUE_COMMENTS_ENDPOINT = "api/v1/repos/{owner}/{repo}/issues/{index}/comments";
    public static final String SINGLE_ISSUE_COMMENT_ENDPOINT = "api/v1/repos/{owner}/{repo}/issues/{index}/comments/{id}";

    @GET(value="api/v1/repos/{owner}/{repo}")
    public GiteaRepository getRepository(@Path(value="owner") String var1, @Path(value="repo") String var2) throws ServiceCallException;

    @GET(value="api/v1/repos/{owner}/{repo}/hooks")
    public Call<GiteaWebhook[]> getWebhooks(@Path(value="owner") String var1, @Path(value="repo") String var2, @Query(value="limit") int var3);

    @GET
    public Call<GiteaWebhook[]> getWebhooksFromNextPage(@Url String var1);

    @POST(value="api/v1/repos/{owner}/{repo}/hooks")
    public Void postWebhook(@Path(value="owner") String var1, @Path(value="repo") String var2, @Body GiteaWebhook var3) throws ServiceCallException;

    @GET(value="api/v1/repos/{owner}/{repo}/pulls?state=open")
    public Call<GiteaPullRequest[]> getOpenPullRequests(@Path(value="owner") String var1, @Path(value="repo") String var2, @Query(value="limit") int var3);

    @GET
    public Call<GiteaPullRequest[]> getOpenPullRequestsFromNextPage(@Url String var1);

    @PATCH(value="api/v1/repos/{owner}/{repo}/pulls/{number}")
    public Void updatePullRequest(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="number") long var3, @Body GiteaPullRequestPatch var5) throws ServiceCallException;

    @GET(value="api/v1/repos/{owner}/{repo}/pulls/{number}")
    public GiteaPullRequest getPullRequest(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="number") long var3) throws ServiceCallException;

    @GET(value="api/v1/repos/{owner}/{repo}/pulls/{number}/reviews")
    public Call<GiteaPullRequestReview[]> getPullRequestReviews(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="number") long var3, @Query(value="limit") int var5);

    @GET
    public Call<GiteaPullRequestReview[]> getPullRequestReviewsFromNextPage(@Url String var1);

    @GET(value="api/v1/repos/{owner}/{repo}/pulls/{number}/reviews/{id}/comments")
    public GiteaPullRequestReviewComment[] getPullRequestReviewComments(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="number") long var3, @Path(value="id") int var5) throws ServiceCallException;

    @POST(value="api/v1/repos/{owner}/{repo}/pulls/{number}/reviews")
    public Void postPullRequestReview(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="number") long var3, @Body GiteaPullRequestReviewCreate var5) throws ServiceCallException;

    @DELETE(value="api/v1/repos/{owner}/{repo}/pulls/{number}/reviews/{id}")
    public Void deletePullRequestReview(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="number") long var3, @Path(value="id") Integer var5) throws ServiceCallException;

    @GET(value="api/v1/repos/{owner}/{repo}/pulls/{number}/files")
    public Call<GiteaChangedFile[]> getPullRequestChangedFiles(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="number") long var3, @Query(value="limit") int var5);

    @GET
    public Call<GiteaChangedFile[]> getPullRequestChangedFilesFromNextPage(@Url String var1);

    @POST(value="api/v1/repos/{owner}/{repo}/statuses/{sha}")
    public Void postCommitStatus(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="sha") String var3, @Body GiteaCommitStatusCreate var4) throws ServiceCallException;

    @GET(value="api/v1/repos/{owner}/{repo}/statuses/{sha}")
    public Call<GiteaCommitStatus[]> getCommitStatuses(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="sha") String var3, @Query(value="limit") int var4);

    @GET
    public Call<GiteaCommitStatus[]> getCommitStatusesFromNextPage(@Url String var1);

    @GET(value="api/v1/repos/{owner}/{repo}/issues/{index}/comments")
    public Call<GiteaIssueComment[]> getIssueComments(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="index") long var3, @Query(value="limit") int var5);

    @GET
    public Call<GiteaIssueComment[]> getIssueCommentsFromNextPage(@Url String var1);

    @POST(value="api/v1/repos/{owner}/{repo}/issues/{index}/comments")
    public Void postIssueComment(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="index") Integer var3, @Body GiteaIssueCommentCreate var4) throws ServiceCallException;

    @DELETE(value="api/v1/repos/{owner}/{repo}/issues/{index}/comments/{id}")
    public Void deleteIssueComment(@Path(value="owner") String var1, @Path(value="repo") String var2, @Path(value="index") Integer var3, @Path(value="id") Integer var4) throws ServiceCallException;
}

