/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.merge_request_fetch_strategy;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.GitHubCommitStatus;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.github.merge_request_fetch_strategy.GitHubDataFetchConfiguration;
import com.teamscale.index.repository.git.github.merge_request_fetch_strategy.IGitHubMergeRequestDataFetchStrategy;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public class GitHubWebhookPayloadFetchStrategy
implements IGitHubMergeRequestDataFetchStrategy {
    private final GitHubDataFetchConfiguration dataFetchConfiguration;

    public GitHubWebhookPayloadFetchStrategy(GitHubDataFetchConfiguration dataFetchConfiguration) {
        this.dataFetchConfiguration = dataFetchConfiguration;
    }

    @Override
    public @Nullable GitHubPullRequest getPlatformMergeRequest(PlatformRepositoryIdentifier repositoryIdentifier, long id) throws StorageException {
        return this.dataFetchConfiguration.webhookPayloadIndex().getPullRequest(new MergeRequestIdentifier(repositoryIdentifier.asRepositoryPath(), id));
    }

    public Set<CheckRun> getCheckRuns(PlatformRepositoryIdentifier repositoryIdentifier, String mergeRequestSourceHead) throws StorageException {
        return this.dataFetchConfiguration.webhookPayloadIndex().getCheckRuns(mergeRequestSourceHead);
    }

    public Set<GitHubCommitStatus> getCommitStatuses(PlatformRepositoryIdentifier repositoryIdentifier, String mergeRequestSourceHead) throws StorageException {
        return this.dataFetchConfiguration.webhookPayloadIndex().getCommitStatuses(mergeRequestSourceHead);
    }

    @Override
    public List<GitHubPullRequest> getAllOpenPlatformMergeRequests(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

