/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.HttpPaginationUtils;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.repository.git.gitlab.IGitLabApi;
import com.teamscale.index.repository.git.gitlab.data.EAccessLevel;
import com.teamscale.index.repository.git.gitlab.data.GitLabCommitStatus;
import com.teamscale.index.repository.git.gitlab.data.GitLabDiscussion;
import com.teamscale.index.repository.git.gitlab.data.GitLabHook;
import com.teamscale.index.repository.git.gitlab.data.GitLabMergeRequest;
import com.teamscale.index.repository.git.gitlab.data.GitLabNote;
import com.teamscale.index.repository.git.gitlab.data.GitLabProject;
import com.teamscale.index.repository.git.gitlab.data.GitlabProjectLanguages;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;

public class GitLabClient {
    private static final int PAGE_LIMIT = 100;
    private final String baseUrl;
    private final IGitLabApi gitlab;
    private final Logger logger;

    public GitLabClient(String baseUrl, String accessToken, Logger interactionLogger) {
        this.logger = interactionLogger;
        this.baseUrl = StringUtils.ensureEndsWith((String)baseUrl, (String)"/");
        this.gitlab = (IGitLabApi)Retrofit.builder((String)this.baseUrl).withBearerAuthentication(accessToken).withInteractionLogger(interactionLogger).create(IGitLabApi.class);
    }

    public GitLabProject getProject(String repositoryPath) throws ServiceCallException {
        return this.gitlab.getProject(repositoryPath);
    }

    public List<GitLabHook> listProjectHooks(String repositoryPath) throws ServiceCallException {
        return Arrays.asList(this.gitlab.getProjectHooks(repositoryPath));
    }

    public List<GitLabProject> listProjectsUserHasReporterAccessTo() throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitlab.getProjectsWithAccessLevel(EAccessLevel.REPORTER.getLevel(), 100), this.gitlab::getNextProjectsWithAccessLevel);
    }

    public GitlabProjectLanguages getLanguagesForProject(String projectId) throws ServiceCallException {
        return this.gitlab.getLanguagesForProject(projectId);
    }

    public void createProjectHook(String repositoryPath, String targetUrl) throws ServiceCallException {
        GitLabHook hook = new GitLabHook(targetUrl, true, true, true, false);
        this.gitlab.postProjectHook(repositoryPath, hook);
    }

    public void updateProjectHook(int hookId, String repositoryPath, String targetUrl) throws ServiceCallException {
        GitLabHook hook = new GitLabHook(targetUrl, true, true, true, false);
        this.gitlab.updateProjectHook(repositoryPath, hookId, hook);
    }

    public GitLabMergeRequest getMergeRequest(String repositoryPath, long mergeRequestId) throws ServiceCallException {
        return this.gitlab.getMergeRequest(repositoryPath, mergeRequestId);
    }

    public String getMergeRequestUrl(String repositoryPath, long mergeRequestId) {
        return this.baseUrl + repositoryPath + "/merge_requests/" + mergeRequestId;
    }

    public void updateMergeRequestDescription(String repositoryPath, long mergeRequestId, String newDescription) throws ServiceCallException {
        this.logger.traceEntry();
        this.logger.debug("Attempting to update description of GitLab merge request in repo {} to say \"{}\"", (Object)repositoryPath, (Object)newDescription);
        this.gitlab.updateMergeRequestDescription(repositoryPath, mergeRequestId, newDescription);
        this.logger.traceExit();
    }

    public List<GitLabMergeRequest> listOpenMergeRequests(String repositoryPath) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitlab.getOpenMergeRequests(repositoryPath, 100), this.gitlab::getNextOpenMergeRequests);
    }

    public GitLabMergeRequest getMergeRequestWithChanges(String repositoryPath, long mergeRequestId) throws ServiceCallException {
        return this.gitlab.getMergeRequestWithChanges(repositoryPath, mergeRequestId);
    }

    public List<GitLabDiscussion> listOpenOrResolvedMergeRequestDiscussions(String repositoryPath, long mergeRequestId) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitlab.getMergeRequestDiscussions(repositoryPath, mergeRequestId, 100), this.gitlab::getNextMergeRequestDiscussions);
    }

    public GitLabDiscussion createMergeRequestDiscussion(String repositoryPath, long mergeRequestId, GitLabNote note) throws ServiceCallException {
        return this.gitlab.createMergeRequestDiscussion(repositoryPath, mergeRequestId, note);
    }

    public void resolveMergeRequestDiscussion(String repositoryPath, long mergeRequestId, String discussionId, boolean resolved) throws ServiceCallException {
        this.gitlab.resolveMergeRequestDiscussion(repositoryPath, mergeRequestId, discussionId, resolved);
    }

    public void updateMergeRequestDiscussion(String repositoryPath, long mergeRequestId, String discussionId, long noteId, String newBody) throws ServiceCallException {
        this.gitlab.updateMergeRequestDiscussionNote(repositoryPath, mergeRequestId, discussionId, noteId, newBody);
    }

    public void replyToMergeRequestDiscussion(String repositoryPath, long mergeRequestId, String discussionId, String body) throws ServiceCallException {
        this.gitlab.addNoteToDiscussion(repositoryPath, mergeRequestId, discussionId, body);
    }

    public void deleteMergeRequestNote(String repositoryPath, long mergeRequestId, long noteId) throws ServiceCallException {
        this.gitlab.deleteMergeRequestNote(repositoryPath, mergeRequestId, noteId);
    }

    public EAccessLevel getProjectAccessLevel(String repositoryPath) throws ServiceCallException {
        return this.gitlab.getProjectUser(repositoryPath, this.getCurrentUserId()).getAccessLevel();
    }

    private int getCurrentUserId() throws ServiceCallException {
        return this.gitlab.getUser().id();
    }

    public List<GitLabCommitStatus> getCommitStatuses(String repositoryPath, String commitSha) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> this.gitlab.getCommitStatuses(repositoryPath, commitSha, 100), this.gitlab::getNextCommitStatuses);
    }

    public String getVersion() throws ServiceCallException {
        return this.gitlab.getVersion().version();
    }
}

