/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.labeling;

import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.options.CommandLineBase;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.options.OptionHandler;

public class GitRepositoryInfoDumper
extends CommandLineBase<StorageException> {
    @OptionHandler
    private final GitInfoStoreOptions gitInfoStoreOptions = new GitInfoStoreOptions();

    protected void run() throws StorageException {
        if (this.gitInfoStoreOptions.gitInfoStore == null) {
            GitRepositoryInfoDumper.printError((String)"Store is missing!");
            this.printUsageAndExit();
        }
        GitRepositoryInfoIndex gitInfoIndex = this.gitInfoStoreOptions.getGitInfoIndex();
        Map<String, String> branches = gitInfoIndex.getBranchNamesByCommitName();
        branches.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> GitRepositoryInfoDumper.printInfo((String)((String)entry.getValue() + " " + (String)entry.getKey())));
    }

    public static void main(String[] args) throws StorageException {
        LoggingUtils.initLogger();
        GitRepositoryInfoDumper.execute(GitRepositoryInfoDumper::new, (String[])args);
    }

    public static class GitInfoStoreOptions {
        private Path gitInfoStore = null;

        @Option(longName="git-info-store", description="sets the path to the git repository info store (extracted from Teamscale backup)")
        public void setGitInfoStorePath(String path) {
            this.gitInfoStore = Path.of(path, new String[0]);
            CCSMAssert.isTrue((boolean)Files.exists(this.gitInfoStore, new LinkOption[0]), () -> "Git info store does not exist: " + String.valueOf(this.gitInfoStore));
        }

        public GitRepositoryInfoIndex getGitInfoIndex() throws StorageException {
            if (this.gitInfoStore == null) {
                return new GitRepositoryInfoIndex((IStore)new InMemoryStore());
            }
            InMemoryStore store = new InMemoryStore();
            try (DataInputStream dis = new DataInputStream(Files.newInputStream(this.gitInfoStore, new OpenOption[0]));){
                StorageUtils.importStore((IStore)store, (DataInputStream)dis);
            }
            catch (IOException e) {
                throw new StorageException(e.getMessage(), (Throwable)e);
            }
            return new GitRepositoryInfoIndex((IStore)new CompressingStore((IStore)store));
        }
    }
}

