/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.labeling;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.repository.git.CommitGraphNode;
import com.teamscale.index.repository.git.labeling.IBranchLabeler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class MergeMessageParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BRANCH_NAME_PATTERN = "'?([^'\\s]*[^'\\s.])'?";
    private static final MergeMessageBranchExtractionPattern MERGE_BRANCH_INTO_BRANCH_PATTERN = new MergeMessageBranchExtractionPattern("^Merge\\s+[\\w-]*\\s*branch\\s+'?([^'\\s]*[^'\\s.])'?.*into\\s+'?([^'\\s]*[^'\\s.])'?\\.?$", EParentMatch.SECOND_PARENT, EParentMatch.FIRST_PARENT);
    private static final MergeMessageBranchExtractionPattern AUTO_MERGE_BRANCH_INTO_BRANCH_PATTERN = new MergeMessageBranchExtractionPattern("^Merge\\s+\"[^\"]*\".*into\\s+'?([^'\\s]*[^'\\s.])'?\\.?$", EParentMatch.FIRST_PARENT, new EParentMatch[0]);
    private static final MergeMessageBranchExtractionPattern AUTOMATIC_UPSTREAM_MERGE_BRANCH_PATTERN = new MergeMessageBranchExtractionPattern("^Automatic upstream merge\\s+\\(\\s*'?([^'\\s]*[^'\\s.])'?\\s+->\\s+'?([^'\\s]*[^'\\s.])'?\\s*\\).*$", EParentMatch.SECOND_PARENT, EParentMatch.FIRST_PARENT);
    private static final MergeMessageBranchExtractionPattern MERGE_BRANCH_PATTERN = new MergeMessageBranchExtractionPattern("^Merge branch\\s+'?([^'\\s]*[^'\\s.])'?.*$", EParentMatch.SECOND_PARENT, new EParentMatch[0]);
    private static final MergeMessageBranchExtractionPattern MERGE_REQUEST_PATTERN = new MergeMessageBranchExtractionPattern("^Merge pull request [#0-9]+ from '?([^'\\s]*[^'\\s.])'?$", EParentMatch.SECOND_PARENT, new EParentMatch[0]);
    private static final MergeMessageBranchExtractionPattern MERGE_REQUEST_IN_PATTERN = new MergeMessageBranchExtractionPattern("^Merge pull request [#0-9]+ in \\S* from '?([^'\\s]*[^'\\s.])'? to '?([^'\\s]*[^'\\s.])'?$", EParentMatch.SECOND_PARENT, EParentMatch.FIRST_PARENT);
    private static final MergeMessageBranchExtractionPattern INTEGRATE_REQUEST_PATTERN = new MergeMessageBranchExtractionPattern("^Integrate pull request [#0-9]+ \\(.*\\) from '?([^'\\s]*[^'\\s.])'?\\+[a-z0-9]*- into '?([^'\\s]*[^'\\s.])'?$", EParentMatch.SECOND_PARENT, EParentMatch.FIRST_PARENT);
    private static final MergeMessageBranchExtractionPattern UPDATE_REQUEST_PATTERN = new MergeMessageBranchExtractionPattern("^Update '?([^'\\s]*[^'\\s.])'? from '?([^'\\s]*[^'\\s.])'?$", EParentMatch.FIRST_PARENT, EParentMatch.SECOND_PARENT);
    private static final MergeMessageBranchExtractionPattern MERGE_BRANCH_WITH_COMMIT_RANGE_PATTERN = new MergeMessageBranchExtractionPattern("^Merge branch '?([^'\\s]*[^'\\s.])'? .*to '?([^'\\s]*[^'\\s.])'?$", EParentMatch.SECOND_PARENT, EParentMatch.FIRST_PARENT);
    private static final MergeMessageBranchExtractionPattern MERGE_IN_REPO_PATTERN = new MergeMessageBranchExtractionPattern("^Merge in .* from '?([^'\\s]*[^'\\s.])'? to '?([^'\\s]*[^'\\s.])'?$", EParentMatch.SECOND_PARENT, EParentMatch.FIRST_PARENT);
    private static final List<MergeMessageBranchExtractionPattern> MERGE_MESSAGE_BRANCH_EXTRACTION_PATTERNS = CollectionUtils.sort(List.of(MERGE_BRANCH_INTO_BRANCH_PATTERN, AUTO_MERGE_BRANCH_INTO_BRANCH_PATTERN, AUTOMATIC_UPSTREAM_MERGE_BRANCH_PATTERN, MERGE_REQUEST_IN_PATTERN, INTEGRATE_REQUEST_PATTERN, UPDATE_REQUEST_PATTERN, MERGE_BRANCH_WITH_COMMIT_RANGE_PATTERN, MERGE_IN_REPO_PATTERN, MERGE_BRANCH_PATTERN, MERGE_REQUEST_PATTERN));
    private final @Nullable Pattern extractedBranchNameTransformationPattern;
    private final String extractedBranchNameTransformationReplacement;
    private final Cache<Long, ParentMatchResult> extractedParentsByMessageHashCache = Caffeine.newBuilder().maximumSize(20000L).build();
    private final Cache<String, Optional<String>> extractedBranchNameByRevisionCache = Caffeine.newBuilder().maximumSize(20000L).build();

    @VisibleForTesting
    MergeMessageParser(@Nullable Pattern pattern, String replacement) {
        this.extractedBranchNameTransformationPattern = pattern;
        this.extractedBranchNameTransformationReplacement = replacement;
    }

    public static MergeMessageParser createInstance() {
        Pattern pattern = (Pattern)TeamscaleSystemProperties.GIT_MESSAGE_PARSER_BRANCH_TRANSFORMATION_PATTERN.getValue();
        String replacement = (String)TeamscaleSystemProperties.GIT_MESSAGE_PARSER_BRANCH_TRANSFORMATION_REPLACEMENT.getValue();
        return new MergeMessageParser(pattern, Objects.requireNonNull(replacement));
    }

    public ParentMatchResult tryToExtractParentsFromMergeMessage(String mergeMessage, IBranchLabeler branchLabeler) {
        return (ParentMatchResult)this.extractedParentsByMessageHashCache.get((Object)XXHashUtils.xxhash64((String)mergeMessage), l -> MergeMessageParser.tryToExtractParentsFromMergeMessageWithoutTransformation(mergeMessage, branchLabeler).applyTransformation(this::transformBranchName));
    }

    private static ParentMatchResult tryToExtractParentsFromMergeMessageWithoutTransformation(String mergeMessage, IBranchLabeler branchLabeler) {
        Optional<ParentMatchResult> result = MergeMessageParser.findFirstMatch(MERGE_MESSAGE_BRANCH_EXTRACTION_PATTERNS, mergeMessage, branchLabeler);
        if (result.isPresent()) {
            return result.get();
        }
        if (!mergeMessage.isEmpty()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = mergeMessage::trim;
            LOGGER.debug("Branch names of parent commits could not be extracted from merge message: '{}'", supplierArray);
        }
        return new ParentMatchResult(Optional.empty(), Optional.empty());
    }

    public Optional<String> tryToGetBranchNameFromMergeMessage(CommitGraphNode node, IBranchLabeler branchLabeler) {
        return (Optional)this.extractedBranchNameByRevisionCache.get((Object)node.getName(), string -> MergeMessageParser.tryToGetBranchNameFromMergeMessageWithoutTransformation(node, branchLabeler).map(this::transformBranchName));
    }

    private static Optional<String> tryToGetBranchNameFromMergeMessageWithoutTransformation(CommitGraphNode node, IBranchLabeler branchLabeler) {
        String mergeMessage = node.getCommitMessage();
        Optional<ParentMatchResult> parentMatchResult = MergeMessageParser.findFirstMatch(MergeMessageParser.getMergeMessageExtractionPatternsMatchingFirstParent(), mergeMessage, branchLabeler);
        if (parentMatchResult.isPresent()) {
            return parentMatchResult.flatMap(ParentMatchResult::firstParent);
        }
        if (!mergeMessage.isEmpty()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = mergeMessage::trim;
            LOGGER.debug("Branch name could not be extracted from merge message: '{}'", supplierArray);
        }
        return Optional.empty();
    }

    private static List<MergeMessageBranchExtractionPattern> getMergeMessageExtractionPatternsMatchingFirstParent() {
        return CollectionUtils.filter(MERGE_MESSAGE_BRANCH_EXTRACTION_PATTERNS, parser -> parser.getMatchedParents().contains((Object)EParentMatch.FIRST_PARENT));
    }

    private static Optional<ParentMatchResult> findFirstMatch(List<MergeMessageBranchExtractionPattern> parsers, String message, IBranchLabeler branchLabeler) {
        return parsers.stream().map(parser -> parser.matchParents(message)).filter(Optional::isPresent).map(Optional::get).findFirst().map(matchResult -> matchResult.applyBranchLabelerLookup(branchLabeler));
    }

    private @Nullable String transformBranchName(String branchName) {
        if (this.extractedBranchNameTransformationPattern == null) {
            return branchName;
        }
        String newBranchName = this.extractedBranchNameTransformationPattern.matcher(branchName).replaceAll(this.extractedBranchNameTransformationReplacement);
        if (StringUtils.isEmpty((String)newBranchName)) {
            return null;
        }
        return newBranchName;
    }

    @NullMarked
    public record ParentMatchResult(Optional<String> firstParent, Optional<String> secondParent) {
        public ParentMatchResult applyTransformation(Function<String, @Nullable String> transformer) {
            return new ParentMatchResult(this.firstParent.map(transformer), this.secondParent.map(transformer));
        }
    }

    private record UnlabeledParentMatchResult(Optional<String> firstParent, Optional<String> secondParent) {
        public ParentMatchResult applyBranchLabelerLookup(IBranchLabeler branchLabeler) {
            return new ParentMatchResult(this.firstParent.map(branchLabeler::lookupBranchName), this.secondParent.map(branchLabeler::lookupBranchName));
        }
    }

    private static class MergeMessageBranchExtractionPattern
    implements Comparable<MergeMessageBranchExtractionPattern> {
        private final Pattern messagePattern;
        private final List<EParentMatch> parentMatchingOrder;

        public MergeMessageBranchExtractionPattern(String patternString, EParentMatch firstParentMatch, EParentMatch ... furtherParentMatches) {
            this.parentMatchingOrder = Stream.concat(Stream.of(firstParentMatch), Arrays.stream(furtherParentMatches)).toList();
            this.messagePattern = Pattern.compile(patternString, 8);
            CCSMAssert.isTrue((this.parentMatchingOrder.size() == this.messagePattern.matcher("").groupCount() ? 1 : 0) != 0, (String)"Pattern group count must correspond to declared parents");
        }

        public Set<EParentMatch> getMatchedParents() {
            return new HashSet<EParentMatch>(this.parentMatchingOrder);
        }

        public Optional<UnlabeledParentMatchResult> matchParents(String mergeMessage) {
            Matcher matcher = this.messagePattern.matcher(mergeMessage);
            if (matcher.find()) {
                HashMap<EParentMatch, String> parentMatches = HashMap.newHashMap(this.parentMatchingOrder.size());
                for (int i = 0; i < this.parentMatchingOrder.size(); ++i) {
                    parentMatches.put(this.parentMatchingOrder.get(i), matcher.group(i + 1).trim());
                }
                return Optional.of(new UnlabeledParentMatchResult(Optional.ofNullable((String)parentMatches.get((Object)EParentMatch.FIRST_PARENT)), Optional.ofNullable((String)parentMatches.get((Object)EParentMatch.SECOND_PARENT))));
            }
            return Optional.empty();
        }

        private int getNumberOfMatches() {
            return this.parentMatchingOrder.size();
        }

        @Override
        public int compareTo(MergeMessageBranchExtractionPattern other) {
            return Integer.compare(other.getNumberOfMatches(), this.getNumberOfMatches());
        }
    }

    private static enum EParentMatch {
        FIRST_PARENT,
        SECOND_PARENT;

    }
}

