/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.mock_connector;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.mock_connector.ArtificialMergeRequestProvider;
import com.teamscale.index.repository.git.mock_connector.ArtificialMergeRequestRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.mock_connector.ArtificialMergeRequestVotingTrigger;
import java.io.IOException;
import java.net.URISyntaxException;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class ArtificialMergeRequestUpdateTrigger
extends MergeRequestUpdateTriggerBase<ArtificialMergeRequestProvider, MergeRequest, MergeRequestBuildJob> {
    @Override
    protected ArtificialMergeRequestProvider createMergeRequestProvider(GlobalStorageSystem globalStorageSystem, ProjectStorageSystem projectStorageSystem, String repositoryPath) throws StorageException {
        try {
            ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((MetaIndex)((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)));
            ConnectorConfiguration connector = projectConfiguration.getConnectors().stream().filter(candidate -> repositoryPath.equalsIgnoreCase(candidate.getOptionValue("Repository Path"))).findAny().orElseThrow();
            IExternalCredentialsProvider credentialsProvider = (IExternalCredentialsProvider)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class);
            ArtificialMergeRequestRepositoryConnectorDescriptor descriptor = (ArtificialMergeRequestRepositoryConnectorDescriptor)ConnectorUtils.loadConnector((ConnectorConfiguration)connector, (ConfigurationInitializationContext)new ConfigurationInitializationContext(this.indexLayer, credentialsProvider), (InternalProjectId)projectConfiguration.getInternalId());
            return new ArtificialMergeRequestProvider(repositoryPath, descriptor.getRepositoryUri().toString(), descriptor.branchesForMergeRequests, descriptor.buildJobsForMergeRequests, VotingConnectorUtils.getBuildIncludeExcludePatterns(connector));
        }
        catch (ProjectConfigurationException | IOException | URISyntaxException | RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected MergeRequestAnnotationTriggerBase<MergeRequest, MergeRequestBuildJob> createMergeRequestAnnotationTrigger() {
        return new ArtificialMergeRequestVotingTrigger();
    }
}

