/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.mock_connector;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.CollectionOptionDescriptorBase;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.common.voting_info.FindingsVotingInfo;
import com.teamscale.index.repository.git.mock_connector.ArtificialMergeRequestProvider;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class ArtificialMergeRequestVotingTrigger
extends MergeRequestAnnotationTriggerBase<MergeRequest, MergeRequestBuildJob> {
    @Override
    protected MergeRequestProvider<MergeRequest, MergeRequestBuildJob> createMergeRequestProvider(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException {
        ExternalCredentials credentials = MergeRequestUpdateTriggerBase.extractCredentials(schedulingParameters.connector(), this.indexLayer.openGlobalStorageSystem());
        String repositoryPath = schedulingParameters.connector().getOptionValue("Repository Path");
        PairList branchNames = (PairList)CollectionOptionDescriptorBase.parseStringToListOfStrings((String)schedulingParameters.connector().getOptionValue("Branches for artificial merge requests")).stream().map(stringEntry -> {
            String[] branches = stringEntry.split(Pattern.quote("->"));
            return Pair.createPair((Object)branches[0].trim(), (Object)branches[1].trim());
        }).collect(PairList.toPairList());
        List<String> buildJobs = CollectionOptionDescriptorBase.parseStringToListOfStrings((String)schedulingParameters.connector().getOptionValue("Build jobs for artificial merge requests")).stream().map(String::trim).toList();
        try {
            return new ArtificialMergeRequestProvider(repositoryPath, credentials.uri + "/" + repositoryPath, (PairList<String, String>)branchNames, buildJobs, VotingConnectorUtils.getBuildIncludeExcludePatterns(schedulingParameters.connector()));
        }
        catch (IOException | URISyntaxException | RepositoryException e) {
            throw new StorageException(e);
        }
    }

    @Override
    protected void deleteInlineFindingsCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) {
    }

    @Override
    protected void deleteInlineTestGapCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException, ExecutionCanceledException {
    }

    @Override
    protected void deleteExistingTestGapSummaryComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) {
    }

    @Override
    protected void postTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, long pullRequestId, String commentContent) {
    }

    @Override
    protected void addLineCommentLimitWarningToDescription(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String commentLimitWarningExceededMessage, String commentLimitWarningFormat) {
    }

    protected EnumSet<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism> getMergeRequestAnnotationMechanisms(ConnectorConfiguration connector) {
        return EnumSet.of(MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism.INLINE_COMMENTS);
    }

    @Override
    protected void addInlineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism mechanism) {
    }

    @Override
    protected void addBadgesToMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String badgeAsMarkdown) {
    }

    @Override
    protected VotingRecord.EVotingState addFindingsVote(FindingsVotingInfo findingsVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) {
        return VotingRecord.EVotingState.VOTING_DISABLED;
    }

    @Override
    protected ERepositoryConnector getRepositoryConnector() {
        return ERepositoryConnector.ARTIFICIAL_MERGE_REQUEST;
    }
}

