/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.common.WebHookBasedGitRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.scm_manager.ScmManagerChangeRetriever;
import com.teamscale.index.repository.git.scm_manager.ScmManagerClient;
import com.teamscale.index.repository.git.scm_manager.ScmManagerContentUpdater;
import com.teamscale.index.repository.git.scm_manager.ScmManagerMergeRequestAnnotationTrigger;
import com.teamscale.index.repository.git.scm_manager.ScmManagerMergeRequestSynchronizer;
import java.net.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@ConnectorDescriptor
public class ScmManagerRepositoryConnectorDescriptor
extends WebHookBasedGitRepositoryConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String SCM_MANAGER_HOOK_END_POINT = "api/scm-manager/web-hook";

    public ScmManagerRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.SCM_MANAGER, LOGGER);
        this.hideOption("Findings badge position");
        this.autoExpose();
    }

    private ScmManagerClient getClient() throws ConnectorValidationException {
        ExternalCredentials credentials = this.resolveExternalCredentials();
        return new ScmManagerClient(super.getRepositoryUri().toString(), credentials.username, credentials.password, LOGGER);
    }

    @Override
    public void validate() throws ConnectorValidationException {
        GitRepositoryManagementConnectorDescriptorBase.splitRepositoryPath(this.repositoryPath, ConnectorValidationException::new);
        super.validate();
    }

    @Override
    protected String getCommitLinkTemplate() throws ConnectorValidationException {
        return ScmManagerRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(this.getRepositoryUri().toString(), "code/changeset/{commitId}");
    }

    @Override
    protected String getCommitInMergeRequestLinkTemplate() throws ConnectorValidationException {
        return this.getCommitLinkTemplate();
    }

    @Override
    public URI getRepositoryUri() throws ConnectorValidationException {
        try {
            return this.getClient().getRepositoryHttpCloneUri(PlatformRepositoryIdentifier.fromRepositoryPath(this.getRepositoryPath())).orElseThrow(() -> new ConnectorValidationException("Could not retrieve clone URL for repository: " + this.repositoryPath));
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    @Override
    protected void ensureHookIsConfigured(ServerOptionIndex serverOptionIndex) throws StorageException, ServiceCallException, ConnectorValidationException {
        this.getClient().putTeamscaleInstanceUrl(PlatformRepositoryIdentifier.fromRepositoryPath(this.getRepositoryPath()), BaseUrlOption.getBaseUrl((ServerOptionIndex)serverOptionIndex));
    }

    @Override
    public Class<? extends AnalysisStepBase> getPullRequestSynchronizerClass() {
        return ScmManagerMergeRequestSynchronizer.class;
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return ScmManagerChangeRetriever.class;
    }

    @Override
    public Class<? extends CommitVotingTriggerBase<?>> getMergeRequestAnnotationTriggerClass() {
        return ScmManagerMergeRequestAnnotationTrigger.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return ScmManagerContentUpdater.class;
    }
}

