/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.history;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.code_clones.CloneChunkByHashIndex;
import com.teamscale.index.code_clones.CloneChunkByPathIndex;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryChangeIndexBase;
import com.teamscale.index.repository.RepositoryLogFileChurn;
import com.teamscale.index.repository.RepositoryLogFileChurnIndex;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.repository.history.match.CloneBasedElementHistoryMatcher;
import com.teamscale.index.repository.history.match.IElementHistoryMatcher;
import com.teamscale.index.repository.history.match.NameBasedElementHistoryMatcher;
import com.teamscale.index.repository.history.match.RepositoryBasedElementHistoryMatcher;
import com.teamscale.index.repository.history.match.name.PathByNameIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ElementHistoryUpdater
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ElementHistoryIndex elementHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private RepositoryLogFileChurnIndex repositoryLogFileChurnIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PathByNameIndex pathIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CloneChunkByPathIndex byPathIndexHead;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private CloneChunkByPathIndex byPathIndexParent;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private CloneChunkByHashIndex byHashIndexParent;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ProjectRepositoryChangeIndex changeIndex;
    @DeltaSource(value=ProjectRepositoryChangeIndex.class)
    private KeyDelta changeDelta;
    private final List<IElementHistoryMatcher> matchers = new ArrayList<IElementHistoryMatcher>();

    public void execute() throws StorageException {
        List<RepositoryChangeEntry> changeEntries = this.getChangeEntries();
        if (changeEntries.isEmpty()) {
            return;
        }
        this.matchers.add(new RepositoryBasedElementHistoryMatcher(this.changeIndex, this.changeDelta, this.getSchedulingCommit()));
        ParentedCommitDescriptor schedulingCommit = this.getParentedSchedulingCommit();
        if (!schedulingCommit.isStartCommit()) {
            this.matchers.add(new NameBasedElementHistoryMatcher(this.pathIndex, this.byPathIndexHead, this.byPathIndexParent, schedulingCommit));
            this.matchers.add(new CloneBasedElementHistoryMatcher(this.byPathIndexHead, this.byHashIndexParent, schedulingCommit));
        }
        HashSet<RepositoryChangeEntry> addedPaths = new HashSet<RepositoryChangeEntry>();
        HashSet<RepositoryChangeEntry> deletedPaths = new HashSet<RepositoryChangeEntry>();
        PairList values = new PairList();
        this.extractAddedAndDeletedPaths(addedPaths, deletedPaths, changeEntries, (PairList<String, ElementHistoryEntry>)values);
        this.applyHistoryMatchingHeuristics(addedPaths, deletedPaths, (PairList<String, ElementHistoryEntry>)values);
        this.elementHistoryIndex.insertAndMergeHistoryEntries((PairList<String, ElementHistoryEntry>)values);
        this.repositoryLogFileChurnIndex.setEntry(RepositoryLogFileChurn.aggregate(this.getSchedulingCommit(), (PairList<String, ElementHistoryEntry>)values));
    }

    private List<RepositoryChangeEntry> getChangeEntries() throws StorageException {
        List<String> pathAndRevisions = RepositoryChangeIndexBase.getPathAndRevisionsFromKeys(this.changeDelta.getAddedOrChangedKeysAsStrings());
        pathAndRevisions.addAll(RepositoryChangeIndexBase.getPathAndRevisionsFromKeys(this.changeDelta.getDeletedKeysAsStrings()));
        return this.changeIndex.getEntries(pathAndRevisions, false);
    }

    private void extractAddedAndDeletedPaths(Set<RepositoryChangeEntry> addedPaths, Set<RepositoryChangeEntry> deletedPaths, List<RepositoryChangeEntry> changeEntries, PairList<String, ElementHistoryEntry> values) throws StorageException {
        List changedPaths = CollectionUtils.map(changeEntries, RepositoryChangeEntry::getRepositoryPath);
        List<ElementHistoryEntry> lastEntries = this.elementHistoryIndex.getHistoryEntries(UniformPathCompatibilityUtil.asUniformPathStrings((Collection)changedPaths));
        boolean mergeCommit = ElementHistoryUpdater.isMergeCommit(this.getParentedSchedulingCommit());
        for (int i = 0; i < changeEntries.size(); ++i) {
            RepositoryChangeEntry changeEntry = changeEntries.get(i);
            ElementHistoryEntry historyEntry = lastEntries.get(i);
            this.handleChangeEntry(addedPaths, deletedPaths, values, changeEntry, historyEntry, mergeCommit);
        }
    }

    private void handleChangeEntry(Set<RepositoryChangeEntry> addedPaths, Set<RepositoryChangeEntry> deletedPaths, PairList<String, ElementHistoryEntry> values, RepositoryChangeEntry changeEntry, ElementHistoryEntry historyEntry, boolean mergeCommit) {
        UniformPath path = changeEntry.getRepositoryPath();
        EElementHistoryChangeType lastChange = null;
        if (historyEntry != null) {
            lastChange = historyEntry.getChangeType();
        }
        switch (changeEntry.getChangeType()) {
            case ADD: {
                if (!(mergeCommit || EElementHistoryChangeType.ADD != lastChange && EElementHistoryChangeType.EDIT != lastChange && EElementHistoryChangeType.MOVE != lastChange && EElementHistoryChangeType.COPY != lastChange)) {
                    ElementHistoryUpdater.logUnexpectedChangeTypeError(Level.WARN, path, historyEntry, changeEntry);
                }
                addedPaths.add(changeEntry);
                break;
            }
            case DELETE: {
                if (!(mergeCommit || lastChange != null && lastChange != EElementHistoryChangeType.DELETE)) {
                    ElementHistoryUpdater.logUnexpectedChangeTypeError(Level.ERROR, path, historyEntry, changeEntry);
                }
                deletedPaths.add(changeEntry);
                break;
            }
            case EDIT: {
                values.add((Object)changeEntry.getRepositoryPath().toStringAsMigrationFrontier(), (Object)new ElementHistoryEntry(changeEntry.getChangeType().toHistoryChangeType(), this.getSchedulingCommit(), changeEntry.getChangeEntryOrigin()));
                if (mergeCommit || lastChange != null && lastChange != EElementHistoryChangeType.DELETE) break;
                ElementHistoryUpdater.logUnexpectedChangeTypeError(Level.ERROR, path, historyEntry, changeEntry);
                break;
            }
            default: {
                throw new AssertionError((Object)("RepositoryChangeEntry should not contain " + String.valueOf((Object)changeEntry.getChangeType()) + " entries!"));
            }
        }
    }

    private static boolean isMergeCommit(ParentedCommitDescriptor commit) {
        if (commit.isMergeCommit()) {
            return true;
        }
        if (!commit.getParentCommits().isEmpty()) {
            return !commit.getCommit().isOnSameBranchAs((CommitDescriptor)commit.getParentCommits().getFirst());
        }
        return false;
    }

    private static void logUnexpectedChangeTypeError(Level level, UniformPath path, ElementHistoryEntry previousChange, RepositoryChangeEntry currentChange) {
        String message = previousChange != null ? "Obtained " + String.valueOf((Object)currentChange.getChangeType()) + " after " + String.valueOf((Object)previousChange.getChangeType()) + " in commit " + String.valueOf(previousChange.getCommit()) + " for path " : "Obtained " + String.valueOf((Object)currentChange.getChangeType()) + " for previously unseen path ";
        LOGGER.log(level, message + String.valueOf(path) + ". Check for potential overlap of repository connectors");
    }

    private void applyHistoryMatchingHeuristics(Set<RepositoryChangeEntry> addedPaths, Set<RepositoryChangeEntry> deletedPaths, PairList<String, ElementHistoryEntry> values) throws StorageException {
        ParentedCommitDescriptor parentedCommit = this.getParentedSchedulingCommit();
        Set deletedUniformPaths = CollectionUtils.mapToSet(deletedPaths, RepositoryChangeEntry::getRepositoryPath);
        for (IElementHistoryMatcher matcher : this.matchers) {
            Map<UniformPath, ElementHistoryEntry> result = matcher.match(addedPaths);
            for (Map.Entry<UniformPath, ElementHistoryEntry> entry : result.entrySet()) {
                UniformPath originPath;
                ElementHistoryEntry originEntry = entry.getValue();
                UniformPath currentPath = entry.getKey();
                if (currentPath.equals((Object)(originPath = UniformPathCompatibilityUtil.convert((String)originEntry.getOriginPath())))) {
                    LOGGER.warn("Element {} was matched to itself! The entry will be ignored.", (Object)originEntry);
                    continue;
                }
                boolean isMove = deletedUniformPaths.contains(originPath);
                EElementHistoryChangeType changeType = isMove ? EElementHistoryChangeType.MOVE : EElementHistoryChangeType.COPY;
                values.add((Object)currentPath.toStringAsMigrationFrontier(), (Object)new ElementHistoryEntry(originEntry.getOriginPath(), parentedCommit.getFirstParentCommit(), parentedCommit.getCommit(), changeType, originEntry.getChangeEntryOrigin()));
                addedPaths.removeIf(addedEntry -> addedEntry.getRepositoryPath().equals((Object)currentPath));
            }
        }
        for (RepositoryChangeEntry added : addedPaths) {
            values.add((Object)added.getRepositoryPath().toStringAsMigrationFrontier(), (Object)new ElementHistoryEntry(EElementHistoryChangeType.ADD, parentedCommit.getCommit(), added.getChangeEntryOrigin()));
        }
        for (RepositoryChangeEntry deleted : deletedPaths) {
            values.add((Object)deleted.getRepositoryPath().toStringAsMigrationFrontier(), (Object)new ElementHistoryEntry(EElementHistoryChangeType.DELETE, parentedCommit.getCommit(), deleted.getChangeEntryOrigin()));
        }
    }
}

