/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.history.match;

import com.teamscale.index.code_clones.CloneChunkByPathIndex;
import com.teamscale.index.code_clones.detection.CloneChunkList;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.match.CloneBasedElementHistoryMatcher;
import com.teamscale.index.repository.history.match.IElementHistoryMatcher;
import com.teamscale.index.repository.history.match.name.PathByNameIndex;
import com.teamscale.index.repository.history.match.name.PathEntry;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class NameBasedElementHistoryMatcher
implements IElementHistoryMatcher {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double CLONE_THRESHOLD = 0.5;
    private final ParentedCommitDescriptor commit;
    private final PathByNameIndex pathIndex;
    private final CloneChunkByPathIndex byPathIndexHead;
    private final CloneChunkByPathIndex byPathIndexParent;

    public NameBasedElementHistoryMatcher(PathByNameIndex pathIndex, CloneChunkByPathIndex byPathIndexHead, CloneChunkByPathIndex byPathIndexParent, ParentedCommitDescriptor commit) {
        this.pathIndex = pathIndex;
        this.byPathIndexHead = byPathIndexHead;
        this.byPathIndexParent = byPathIndexParent;
        this.commit = commit;
    }

    @Override
    public Map<UniformPath, ElementHistoryEntry> match(Set<RepositoryChangeEntry> addedPaths) throws StorageException {
        List<RepositoryChangeEntry> codePathEntries = addedPaths.stream().filter(entry -> {
            ELanguage language = ELanguage.fromPath((String)entry.getRepositoryPath().getLastSegment());
            return language != null && language != ELanguage.TEXT && language != ELanguage.LINE;
        }).toList();
        List addedPathsAsList = CollectionUtils.map(codePathEntries, RepositoryChangeEntry::getRepositoryPath);
        List<String> addedNames = PathByNameIndex.extractNamesFromPaths(UniformPathCompatibilityUtil.asUniformPathStrings((Collection)addedPathsAsList));
        List<PathEntry> pathEntries = this.pathIndex.getPathsByNames(addedNames);
        List<CloneChunkList> addedElementsChunks = this.byPathIndexHead.getChunksForElements(UniformPathCompatibilityUtil.asUniformPathStrings((Collection)addedPathsAsList));
        HashMap<UniformPath, ElementHistoryEntry> matches = new HashMap<UniformPath, ElementHistoryEntry>();
        for (int i = 0; i < addedNames.size(); ++i) {
            PathEntry pathEntry = pathEntries.get(i);
            if (pathEntry == null) {
                LOGGER.error("No full path found for file name '" + addedNames.get(i) + "' anywhere in the repository. Skipping this entry.");
                continue;
            }
            this.performPairwiseComparisonWithOriginCandidates(codePathEntries.get(i), addedElementsChunks.get(i), NameBasedElementHistoryMatcher.getSortedCandidatePaths(codePathEntries.get(i).getRepositoryPath().toStringAsMigrationFrontier(), pathEntry, this.commit.getCommit()), matches);
        }
        return matches;
    }

    private static List<String> getSortedCandidatePaths(String filePath, PathEntry pathEntry, CommitDescriptor commit) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (String path : pathEntry.getAllPaths()) {
            Long deletedTimestamp = pathEntry.getDeletedTimestamp(path);
            if (path.equals(filePath) || pathEntry.getAddedTimestamp(path) >= commit.getTimestamp() || deletedTimestamp != null && deletedTimestamp.longValue() != commit.getTimestamp()) continue;
            candidates.add(path);
        }
        candidates.sort(new PathSimilaritySorter(filePath));
        return candidates;
    }

    private void performPairwiseComparisonWithOriginCandidates(RepositoryChangeEntry addedPath, CloneChunkList addedElementChunks, List<String> originCandidates, Map<UniformPath, ElementHistoryEntry> matches) throws StorageException {
        if (originCandidates.isEmpty()) {
            return;
        }
        List<CloneChunkList> oldElementsChunks = this.byPathIndexParent.getChunksForElements(originCandidates);
        for (int i = 0; i < originCandidates.size(); ++i) {
            String originCandidate = originCandidates.get(i);
            CloneChunkList oldElementChunks = oldElementsChunks.get(i);
            if (!(CloneBasedElementHistoryMatcher.getMatchedCoverage(addedElementChunks, oldElementChunks, this.byPathIndexHead.getChunkLength(), 0.5) > 0.0)) continue;
            matches.put(addedPath.getRepositoryPath(), new ElementHistoryEntry(originCandidate, this.commit.getFirstParentCommit(), this.commit.getCommit(), EElementHistoryChangeType.MOVE, addedPath.getChangeEntryOrigin()));
            return;
        }
    }

    private static class PathSimilaritySorter
    implements Comparator<String> {
        private final String[] splitPath;

        public PathSimilaritySorter(String path) {
            this.splitPath = UniformPathUtils.splitPath((String)path);
        }

        @Override
        public int compare(String path1, String path2) {
            Diff.Delta delta1 = Diff.computeDelta((Object[])UniformPathUtils.splitPath((String)path1), (Object[])this.splitPath);
            Diff.Delta delta2 = Diff.computeDelta((Object[])UniformPathUtils.splitPath((String)path2), (Object[])this.splitPath);
            return delta1.getSize() - delta2.getSize();
        }
    }
}

