/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.retrievers;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryFilesRetriever;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionInterpretationFactory;
import com.teamscale.index.repository.artifact_store.s3.S3FilesRetriever;
import com.teamscale.index.repository.filesystem.FileSystemFilesRetriever;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemFilesRetriever;
import com.teamscale.index.repository.git.GitFilesRetriever;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitFilesRetriever;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudDataRetriever;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerFilesRetriever;
import com.teamscale.index.repository.git.gerrit.GerritFilesRetriever;
import com.teamscale.index.repository.git.gitea.GiteaFilesRetriever;
import com.teamscale.index.repository.git.github.GitHubDataRetriever;
import com.teamscale.index.repository.git.gitlab.GitLabFilesRetriever;
import com.teamscale.index.repository.git.scm_manager.ScmManagerFilesRetriever;
import com.teamscale.index.repository.retrievers.IFilesRetriever;
import com.teamscale.index.repository.sap.abapsystem.repository.AbapFilesRetriever;
import com.teamscale.index.repository.svn.SVNFilesRetriever;
import com.teamscale.index.repository.tfs.TfsFilesRetriever;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class FilesRetrieverFactory {
    private final Logger logger;
    private final IndexLayer indexLayer;

    public FilesRetrieverFactory(IndexLayer indexLayer, Logger logger) {
        this.logger = logger;
        this.indexLayer = indexLayer;
    }

    public @NonNull IFilesRetriever getFilesRetriever(@Nullable IProjectId projectId, @NonNull User user, @NonNull Supplier<@NonNull ExternalCredentials> credentials, @NonNull ConnectorConfiguration connectorConfiguration) throws StorageException, RepositoryException {
        return switch (FilesRetrieverFactory.getConnectorType(connectorConfiguration)) {
            default -> throw new MatchException(null, null);
            case ERepositoryConnector.ARTIFACTORY -> new ArtifactoryFilesRetriever(this.loadProjectConfiguration(projectId), connectorConfiguration, credentials.get(), this.openForeignCommitTreeIndex(projectId, connectorConfiguration), this.logger);
            case ERepositoryConnector.FILE_SYSTEM -> new FileSystemFilesRetriever(this.openServerOptionIndex(), connectorConfiguration);
            case ERepositoryConnector.MULTI_VERSION_FILE_SYSTEM -> new MultiVersionFileSystemFilesRetriever(this.openServerOptionIndex(), connectorConfiguration);
            case ERepositoryConnector.S3 -> new S3FilesRetriever(connectorConfiguration, this.loadProjectConfiguration(projectId), credentials.get(), this.openForeignCommitTreeIndex(projectId, connectorConfiguration));
            case ERepositoryConnector.SVN -> new SVNFilesRetriever(connectorConfiguration, credentials.get());
            case ERepositoryConnector.TFS -> new TfsFilesRetriever(connectorConfiguration, credentials.get());
            case ERepositoryConnector.AZURE_DEVOPS_GIT -> new AzureDevOpsGitFilesRetriever(this.openServerOptionIndex(), connectorConfiguration, credentials.get(), this.logger);
            case ERepositoryConnector.BITBUCKET -> new BitbucketCloudDataRetriever(this.openServerOptionIndex(), this.openAccessTokenIndex(), this.loadProjectConfiguration(projectId), connectorConfiguration, user.getUsername(), this.indexLayer.openGlobalStorageSystem(), this.logger);
            case ERepositoryConnector.BITBUCKET_SERVER -> new BitbucketServerFilesRetriever(this.openServerOptionIndex(), connectorConfiguration, credentials.get(), this.logger);
            case ERepositoryConnector.GERRIT -> new GerritFilesRetriever(this.openServerOptionIndex(), connectorConfiguration, credentials.get());
            case ERepositoryConnector.GIT, ERepositoryConnector.ARTIFICIAL_MERGE_REQUEST -> new GitFilesRetriever(this.openServerOptionIndex(), connectorConfiguration, credentials.get());
            case ERepositoryConnector.GITHUB -> new GitHubDataRetriever(this.openGithubInstallationIndex(), this.openAccessTokenIndex(), this.openServerOptionIndex(), this.logger, this.loadProjectConfiguration(projectId), connectorConfiguration, user.getUsername());
            case ERepositoryConnector.GITLAB -> new GitLabFilesRetriever(this.openServerOptionIndex(), connectorConfiguration, credentials.get(), this.logger);
            case ERepositoryConnector.SCM_MANAGER -> new ScmManagerFilesRetriever(this.openServerOptionIndex(), connectorConfiguration, credentials.get(), this.logger);
            case ERepositoryConnector.ABAP_GIT -> new AbapFilesRetriever(this.openServerOptionIndex(), connectorConfiguration);
            case ERepositoryConnector.GITEA -> new GiteaFilesRetriever(this.openServerOptionIndex(), connectorConfiguration, credentials.get(), this.logger);
        };
    }

    private static @NonNull ERepositoryConnector getConnectorType(ConnectorConfiguration connectorConfiguration) throws IllegalArgumentException {
        return (ERepositoryConnector)connectorConfiguration.getRepositoryType().orElseThrow(() -> new IllegalArgumentException("Unsupported connector '%s'.".formatted(connectorConfiguration.getRawType())));
    }

    private @Nullable ProjectConfiguration loadProjectConfiguration(@Nullable IProjectId projectId) throws StorageException {
        return projectId != null ? ProjectConfigurationUtils.getProjectConfiguration((IProjectId)projectId, (IndexLayer)this.indexLayer) : null;
    }

    private AccessTokenIndex openAccessTokenIndex() throws StorageException {
        return (AccessTokenIndex)this.indexLayer.openGlobalIndex(AccessTokenIndex.class);
    }

    private ServerOptionIndex openServerOptionIndex() throws StorageException {
        return (ServerOptionIndex)this.indexLayer.openGlobalIndex(ServerOptionIndex.class);
    }

    private GitHubInstallationIndex openGithubInstallationIndex() throws StorageException {
        return (GitHubInstallationIndex)this.indexLayer.openGlobalIndex(GitHubInstallationIndex.class);
    }

    private @Nullable CommitTreeIndex openForeignCommitTreeIndex(IProjectId projectId, ConnectorConfiguration connectorConfiguration) throws StorageException, RepositoryException {
        Optional<String> timestampInterpretationOption = Optional.ofNullable(connectorConfiguration.getOptionValue("Timestamp Interpretation"));
        if (timestampInterpretationOption.isEmpty()) {
            return null;
        }
        Optional<String> foreignConnectorIdentifier = ERevisionInterpretationFactory.getReferencedConnectorId(timestampInterpretationOption.get());
        if (foreignConnectorIdentifier.isEmpty()) {
            return null;
        }
        return (CommitTreeIndex)this.indexLayer.openProjectIndex(projectId, CommitTreeIndex.class, CommitTreeIndex.getIndexNameForRepository((String)foreignConnectorIdentifier.get()), null);
    }
}

