/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.conn.jco.JCo;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.MultilineOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.PasswordOption;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.repository.sap.abapsystem.GlobalSapSystemConnectionOption;
import com.teamscale.index.repository.sap.abapsystem.importer.AbapFullSynchronizeTrigger;
import com.teamscale.index.repository.sap.abapsystem.importer.AbapIncrementalSynchronizeTrigger;
import com.teamscale.index.repository.sap.abapsystem.importer.EUpdateMode;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.JcoDestinationDataProvider;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.SapSystemCommunicationException;
import com.teamscale.index.repository.sap.abapsystem.importer.snc.SncCredentialsManager;
import com.teamscale.index.repository.sap.abapsystem.importer.snc.SncException;
import com.teamscale.index.repository.sap.abapsystem.importer.snc.SncUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.jco.JcoReflectionUtils;
import org.conqat.engine.abap.jco.JcoUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="sap.abap.system", name="SAP ABAP System Connection", type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.SAP, orderingHint=100)
@IndexValueClass(containedInBackup=true)
public class AbapSystemDescription
implements IOption {
    private static final String JCO_VALIDATION_DESTINATION_PREFIX = "VALIDATE";
    private static final Pattern CUSTOM_NAMESPACE_PATTERN = Pattern.compile("(/[A-Z0-9_]+/)|(M[YZ])|(SAPM[YZ])");
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "sap.abap.system";
    public static final String OPTION_NAME = "SAP ABAP System Connection";
    public static final String JCO_PROPERTY_CONNECT_TIMEOUT = "jrfc.client_connect_timeout";
    @JsonProperty(value="fetchFromSapSystem")
    @OptionFieldDescription(name="Fetch data from SAP system", description="If you disable this, only ZIPs are imported. You still need to configure a synchronization schedule to integrate these ZIP files.", dependentOptions={"jcoAshost", "jcoSysnr", "jcoR3Name", "jcoMshost", "jcoGroup", "jcoMsserv", "jcoSaprouter", "jcoClient", "jcoUser", "jcoPasswd", "isSncEnabled", "x509certificatePath", "includeDefaultCustomNamespace", "addtionalCustomNamespaces", "executeFullSynchronizationAsynchronously", "codeInspectorVariantName", "codeInspectorVariantUser", "codeInspectorInclude", "codeInspectorExclude", "includeBwObjects", "includeDdicObjects", "includeModifications", "includePathsForAllObjects", "addTestCoverageInIncrementalExports", "addTestCoverageInFullExports", "clearTestCoverage"})
    public boolean fetchFromSapSystem = true;
    @JsonProperty(value="jcoAshost")
    @OptionFieldDescription(name="Direct connection: Application server host")
    public String jcoAshost = "";
    @JsonProperty(value="jcoSysnr")
    @OptionFieldDescription(name="Direct connection: Instance number", description="The number of this instance (such as '00', formerly 'system number')")
    public String jcoSysnr = "00";
    @JsonProperty(value="jcoR3Name")
    @OptionFieldDescription(name="System ID")
    public String jcoR3Name = "";
    @JsonProperty(value="jcoMshost")
    @OptionFieldDescription(name="Logon balancing connection: SAP message server")
    public String jcoMshost = "";
    @JsonProperty(value="jcoGroup")
    @OptionFieldDescription(name="Logon balancing connection: Group of SAP application servers")
    public String jcoGroup = "";
    @JsonProperty(value="jcoMsserv")
    @OptionFieldDescription(name="Logon balancing connection: SAP message server port", description="Usually, this is 36xx with xx being the instance number.")
    public String jcoMsserv = "";
    @JsonProperty(value="jcoSaprouter")
    @OptionFieldDescription(name="SAP Router string", description="Required for connection to systems behind a SAP Router. This string contains the chain of SAP Routers and their port numbers and has the form: (/H/<host>[/S/<port>])+")
    public String jcoSaprouter = "";
    @JsonProperty(value="jcoClient")
    @OptionFieldDescription(name="SAP client (such as '001')")
    public String jcoClient = "001";
    @JsonProperty(value="jcoUser")
    @OptionFieldDescription(name="Logon user for password-based authentication")
    public String jcoUser = "";
    @JsonProperty(value="jcoPasswd")
    @OptionFieldDescription(name="Logon password for password-based authentication")
    @PasswordOption
    public String jcoPasswd = "";
    @JsonProperty(value="isSncEnabled")
    @OptionFieldDescription(name="Use secure Network Communications (SNC)", dependentOptions={"jcoSncPartnername", "jcoSncMyname", "isSsoEnabledForSnc"})
    public boolean isSncEnabled = false;
    @JsonProperty(value="jcoSncPartnername")
    @OptionFieldDescription(name="SNC name of the communication partner server", description="Example: p:CN=SNC, O=ACompany, C=EN")
    public String jcoSncPartnername = "";
    @JsonProperty(value="jcoSncMyname")
    @OptionFieldDescription(name="Own SNC name of the caller", description="Example: p:CN=TEAMSCALE, O=ACompany, C=EN")
    public String jcoSncMyname = "";
    @JsonProperty(value="isSsoEnabledForSnc")
    @OptionFieldDescription(name="Use SNC Single sign-on (SSO)", description="If disabled, user/password must be provided.", dependentOptions={"x509certificatePath"})
    public boolean isSsoEnabledForSnc = false;
    @JsonProperty(value="x509certificatePath")
    @OptionFieldDescription(name="Path to X.509 certificate as logon ticket (*.crt file)")
    public String x509certificatePath = "";
    @JsonProperty(value="includeDefaultCustomNamespace")
    @OptionFieldDescription(name="Include objects in default custom namespaces Y... / Z...")
    public boolean includeDefaultCustomNamespace = true;
    @JsonProperty(value="addtionalCustomNamespaces")
    @OptionFieldDescription(name="Further custom namespaces to include", description="Separated by commas. Example: '/ABC/, /EFG/'")
    public String addtionalCustomNamespaces = "";
    @JsonProperty(value="incrementalSynchronizationSchedule")
    @OptionFieldDescription(name="Polling schedule for changes", description="Defines how frequently Teamscale queries the SAP system for recently changed objects.")
    @ScheduleOption(triggerClass=AbapIncrementalSynchronizeTrigger.class)
    public String incrementalSynchronizationSchedule = "";
    @JsonProperty(value="fullSynchronizationSchedule")
    @OptionFieldDescription(name="Polling schedule for full sync", description="Defines how frequently Teamscale fetches all objects from the SAP system.")
    @ScheduleOption(triggerClass=AbapFullSynchronizeTrigger.class)
    public String fullSynchronizationSchedule = "";
    @JsonProperty(value="executeFullSynchronizationAsynchronously")
    @OptionFieldDescription(name="Use background job for full sync", description="Recommended when experiencing long running times of the Teamscale SAP Add-on (especially when using Code Inspector) to avoid timeouts and blocking of Teamscale workers.")
    public boolean executeFullSynchronizationAsynchronously = false;
    @JsonProperty(value="codeInspectorVariantName")
    @OptionFieldDescription(name="Code Inspector: variant name", description="This setting is optional. When not specified, Code Inspector will be skipped.")
    public String codeInspectorVariantName = "DEFAULT";
    @JsonProperty(value="codeInspectorVariantUser")
    @OptionFieldDescription(name="Code Inspector: variant user", description="Leave empty for global variants")
    public String codeInspectorVariantUser = "";
    @JsonProperty(value="codeInspectorInclude")
    @OptionFieldDescription(name="Code Inspector: include specification", description="Only matching objects will be checked by SAP Code Inspector. Specified as list (comma or line separated) of patterns matching against the object path as in Teamscale. Use '**' or '?' as wildcards.")
    @MultilineOption
    public String codeInspectorInclude = "**.abap";
    @JsonProperty(value="codeInspectorExclude")
    @OptionFieldDescription(name="Code Inspector: exclude specification", description="Matching objects will not be checked by SAP Code Inspector. Specified as list (comma or line separated) of patterns matching against the object path in Teamscale. Use '**' or '?' as wildcards.")
    @MultilineOption
    public String codeInspectorExclude = "";
    @JsonProperty(value="includeDdicObjects")
    @OptionFieldDescription(name="Include objects in ABAP Dictionary (DDIC)", description="In addition to ABAP source code, this will also retrieve DDIC objects (table definitions, data elements etc.) in the given namespace(s), e.g. for use in architecture analysis.")
    public boolean includeDdicObjects = true;
    @JsonProperty(value="includeModifications")
    @OptionFieldDescription(name="Include all objects with modifications", description="In addition to ABAP custom code, this will also retrieve modified ABAP standard objects.")
    public boolean includeModifications = true;
    @JsonProperty(value="includeBwObjects")
    @OptionFieldDescription(name="Include programs generated from BW objects", description="On SAP BW systems, this will also retrieve ABAP programs generated from BW transformations, queries, and DTPs in the given namespace(s).")
    public boolean includeBwObjects = false;
    @JsonProperty(value="includePathsForAllObjects")
    @OptionFieldDescription(name="Include package information for standard objects", description="During full sync, this will retrieve package information for all ABAP and DDIC objects on the system. This is useful for analyzing dependencies to SAP standard packages.")
    public boolean includePathsForAllObjects = false;
    @JsonProperty(value="addTestCoverageInFullExports")
    @OptionFieldDescription(name="Include coverage in full sync", description="This will retrieve procedure execution information recorded by SCOV on the system. If not enabled already, Teamscale will attempt to start SCOV automatically.")
    public boolean addTestCoverageInFullExports = false;
    @JsonProperty(value="addTestCoverageInIncrementalExports")
    @OptionFieldDescription(name="Include coverage with change polling - WARNING: Only enable when you are sure you need this!", description="This may result in very high disk space consumption and long processing time. Especially, this option should not be enabled in combination with very frequent incremental change polling, e.g. every 10 minutes. Further, it should not be enabled when immediate analysis results in SAP or Eclipse ADT are desired, e.g. when using Teamscale during transport release.")
    public boolean addTestCoverageInIncrementalExports = false;
    @JsonProperty(value="clearTestCoverage")
    @OptionFieldDescription(name="Clear table COVRES after coverage retrieval")
    public boolean clearTestCoverage = false;
    @JsonProperty(value="notes")
    @OptionFieldDescription(name="Description / notes for this connection")
    @MultilineOption
    public String notes = "";

    public static AbapSystemDescription getInstanceFromOptionIndex(String configurationId, ServerOptionIndex serverOptionIndex) throws StorageException {
        if (!OptionRegistryBase.containsOptionValue((String)"server", (String)OPTION_ID, (String)configurationId, (OptionIndexBase)serverOptionIndex)) {
            return null;
        }
        return (AbapSystemDescription)ServerOptionRegistry.getInstance().getServerMultiOption(OPTION_ID, configurationId, AbapSystemDescription.class, serverOptionIndex);
    }

    public static Map<String, AbapSystemDescription> getAllInstances(ServerOptionIndex serverOptionIndex) throws StorageException {
        return ServerOptionRegistry.getServerMultiOptionAll((String)OPTION_ID, (ServerOptionIndex)serverOptionIndex).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (AbapSystemDescription)e.getValue()));
    }

    public String getX509CertificateString() throws IOException {
        if (StringUtils.isEmpty((String)this.x509certificatePath)) {
            return null;
        }
        String certificate = FileSystemUtils.readFile((Path)Path.of(this.x509certificatePath, new String[0]), (Charset)StandardCharsets.US_ASCII);
        certificate = JcoUtils.formatCertificateInSingleLine((String)certificate);
        return certificate;
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        if (!this.fetchFromSapSystem) {
            return null;
        }
        if (!JcoReflectionUtils.isJCoLibraryLoaded()) {
            return null;
        }
        if (this.jcoR3Name.trim().isEmpty()) {
            return "Please specify the SAP system id for the Teamscale SAP IDE integration (and a logon balancing connection).";
        }
        StringJoiner message = new StringJoiner("\n");
        if (this.isDirectConnection()) {
            this.validateDirectConnectionSettings(message);
        } else {
            this.validateLogonBalancedConnectionSettings(message);
        }
        this.validateLogonSettings(message);
        this.validateCustomNamespaces(message);
        this.validateCodeInspectorSettings(message);
        if (message.length() > 0) {
            return message.toString();
        }
        ServerOptionIndex optionIndex = (ServerOptionIndex)storageInfo.getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
        GlobalSapSystemConnectionOption globalSapOption = (GlobalSapSystemConnectionOption)ServerOptionRegistry.getInstance().getServerOption("sap.abap.global", GlobalSapSystemConnectionOption.class, optionIndex);
        this.validateSncSettings(message, globalSapOption.jcoSncLibrary);
        return this.validateConnection(globalSapOption);
    }

    public void executedActionsAfterModification(IndexLayer indexLayer) throws StorageException {
        JobDescriptor synchronizationJob = JobDescriptor.forMaintenanceProject().withPrivilegedTrigger(AbapIncrementalSynchronizeTrigger.class).withSchedulingReason("Scheduled due to changed settings of SAP system.").withParameter(OptionRegistryBase.buildMultiOptionId((String)OPTION_ID, (String)this.jcoR3Name)).build();
        ISchedulerCommunicator.getInstance().scheduleExternalJob(indexLayer, synchronizationJob);
    }

    private void validateCustomNamespaces(StringJoiner message) {
        String[] namespaces;
        if (StringUtils.isEmpty((String)this.addtionalCustomNamespaces)) {
            return;
        }
        for (String namespace : namespaces = this.addtionalCustomNamespaces.split(",")) {
            if (CUSTOM_NAMESPACE_PATTERN.matcher(namespace = namespace.trim()).matches()) continue;
            message.add("Invalid format of custom namespace '" + namespace + "'. ");
        }
    }

    private void validateSncSettings(StringJoiner message, String serviceLibraryFromConnection) {
        if (!this.isSncEnabled) {
            return;
        }
        this.validateSncPseCredential(message, serviceLibraryFromConnection);
        if (StringUtils.isEmpty((String)this.jcoSncPartnername)) {
            message.add("SNC name of the communicating partner is not provided.");
            return;
        }
        this.validateSncCertificateSettings(message);
    }

    private void validateSncPseCredential(StringJoiner message, String serviceLibraryFromConnection) {
        Optional<String> optResult;
        String serviceLibrary = SncUtils.getSncServiceLibraryFromEnvVar();
        if (StringUtils.isEmpty((String)serviceLibrary)) {
            serviceLibrary = serviceLibraryFromConnection;
        }
        if ((optResult = SncUtils.validateServiceLibrary(serviceLibrary)).isPresent()) {
            message.add(optResult.get());
            return;
        }
        if (!SncUtils.isSapCryptoSncOsLibrary(serviceLibrary)) {
            return;
        }
        try {
            SncCredentialsManager sncCredentialsManager = SncCredentialsManager.getInstance(serviceLibrary);
            if (!sncCredentialsManager.isPseRegisteredInCredentials(this.jcoR3Name)) {
                message.add("PSE file for SAP connection " + this.jcoR3Name + " is not registered in credentials (cred_v2). Ensure that the PSE file is named " + this.jcoR3Name + ".pse and inside the security directory. Use the 'Manage ABAP SNC Credentials' button to register it.");
                message.add("Note that SNC is activated for SAP connection " + this.jcoR3Name);
            }
        }
        catch (SncException e) {
            message.add(e.getMessage());
            message.add("Note that SNC is activated for SAP Connection " + this.jcoR3Name);
        }
    }

    private void validateSncCertificateSettings(StringJoiner message) {
        if (StringUtils.isEmpty((String)this.x509certificatePath)) {
            return;
        }
        if (!FileSystemUtils.isReadableFile((Path)Paths.get(this.x509certificatePath, new String[0]))) {
            message.add("Certificate file " + this.x509certificatePath + " is not readable.");
            return;
        }
        try {
            String certificate = this.getX509CertificateString();
            if (!certificate.matches("[A-Za-z0-9+/]+=*")) {
                message.add(this.x509certificatePath + " is not a Base64 encoded X.509 certificate");
            }
        }
        catch (IOException e) {
            message.add("IOException occurred when trying to access " + this.x509certificatePath + ": " + e.getMessage());
        }
    }

    private void validateCodeInspectorSettings(StringJoiner message) {
        if (!StringUtils.isEmpty((String)this.codeInspectorVariantName) && this.codeInspectorInclude.isEmpty()) {
            message.add("If a Code Inspector variant is specified, also a Code Inspector include pattern must be stated.");
        }
        if (!StringUtils.isEmpty((String)this.codeInspectorVariantUser) && StringUtils.isEmpty((String)this.codeInspectorVariantName)) {
            message.add("Code Inspector variant user is specified, but no variant name given.");
        }
        try {
            AbapUtils.convertAntPatternList((String)this.codeInspectorInclude);
        }
        catch (IllegalArgumentException e) {
            message.add("Error in Code Inspector include pattern list: " + e.getMessage());
        }
        try {
            AbapUtils.convertAntPatternList((String)this.codeInspectorExclude);
        }
        catch (IllegalArgumentException e) {
            message.add("Error in Code Inspector exclude pattern list: " + e.getMessage());
        }
    }

    private void validateLogonSettings(StringJoiner message) {
        if (!this.jcoClient.matches("\\d\\d\\d")) {
            message.add("Client must be a three-digit number. ");
        }
        if (this.isSsoEnabledForSnc) {
            return;
        }
        if (StringUtils.isEmpty((String)this.jcoUser)) {
            message.add("User name must not be empty. ");
        }
        if (StringUtils.isEmpty((String)this.jcoPasswd)) {
            message.add("Password must not be empty. ");
        }
    }

    private void validateLogonBalancedConnectionSettings(StringJoiner message) {
        if (this.jcoGroup.trim().isEmpty()) {
            message.add("Group of SAP application servers is mandatory for logon balanced connection. ");
        }
        if (this.jcoMshost.trim().isEmpty()) {
            message.add("SAP message server is mandatory for logon balanced connection. ");
        }
        if (!this.jcoAshost.trim().isEmpty()) {
            message.add("Hostname for application server is superfluous for logon balanced connection. ");
        }
        if (!this.jcoSysnr.trim().isEmpty()) {
            message.add("Instance number is superfluous for logon balanced connection. ");
        }
    }

    private void validateDirectConnectionSettings(StringJoiner message) {
        if (this.jcoAshost.trim().isEmpty()) {
            message.add("Hostname for application server is mandatory for direct connection. ");
        }
        if (!this.jcoSysnr.matches("\\d\\d")) {
            message.add("Instance number is mandatory for direct connection and must be a two-digit number. ");
        }
        if (!this.jcoGroup.trim().isEmpty()) {
            message.add("Group of SAP application servers is superfluous for direct connection. ");
        }
        if (!this.jcoMshost.trim().isEmpty()) {
            message.add("SAP message server superfluous for direct connection. ");
        }
    }

    public boolean isDirectConnection() {
        return !this.jcoAshost.trim().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String validateConnection(GlobalSapSystemConnectionOption globalSapOption) {
        StringJoiner message = new StringJoiner("\n");
        JcoDestinationDataProvider jcoDestinationDataProvider = JcoDestinationDataProvider.getInstance();
        String jcoConnectionName = this.getDestinationName();
        try {
            jcoDestinationDataProvider.setPropertiesFromSystemDescription(jcoConnectionName, this, globalSapOption);
        }
        catch (SapSystemCommunicationException e) {
            message.add("Error during setting of JCo properties: " + e.getMessage());
        }
        String previousTimeout = JCo.getProperty((String)JCO_PROPERTY_CONNECT_TIMEOUT);
        try {
            JCo.setProperty((String)JCO_PROPERTY_CONNECT_TIMEOUT, (String)"3");
            String errorMessage = JcoUtils.validateTeamscaleConnectorIsAvailableOnSapSystem((String)jcoConnectionName, (boolean)this.executeFullSynchronizationAsynchronously);
            if (errorMessage != null) {
                message.add(errorMessage);
            }
        }
        catch (ConQATException e) {
            message.add("Unable to access SAP system: " + e.getMessage());
        }
        finally {
            JCo.setProperty((String)JCO_PROPERTY_CONNECT_TIMEOUT, (String)previousTimeout);
        }
        if (message.length() > 0) {
            return message.toString();
        }
        return null;
    }

    public boolean isPasswordLogon() {
        return !this.isSncEnabled || !this.isSsoEnabledForSnc;
    }

    private String getDestinationName() {
        if (this.isDirectConnection()) {
            return AbapSystemDescription.makeDestination(this.jcoAshost, this.jcoSysnr);
        }
        return AbapSystemDescription.makeDestination(this.jcoMshost, this.jcoMsserv);
    }

    private static String makeDestination(String ... parts) {
        return Stream.concat(Stream.of(JCO_VALIDATION_DESTINATION_PREFIX), Stream.of(parts)).collect(Collectors.joining("_"));
    }

    public boolean isIncludeTestCoverage(EUpdateMode updateMode) {
        return switch (updateMode) {
            default -> throw new MatchException(null, null);
            case EUpdateMode.INCREMENT -> this.addTestCoverageInIncrementalExports;
            case EUpdateMode.FULL, EUpdateMode.RECOVERY, EUpdateMode.INITIAL -> this.addTestCoverageInFullExports;
        };
    }
}

