/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.abap.UpdateResult;
import com.teamscale.index.repository.SapConnectionStatusPersister;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.importer.AbapRepositoryUpdater;
import com.teamscale.index.repository.sap.abapsystem.importer.EUpdateMode;
import com.teamscale.index.repository.sap.abapsystem.importer.SapConnectionStatusIndex;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.AbapScovRestarter;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.SapSystemCommunicationException;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.SynchronousAbapExportRetriever;
import java.io.File;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.CanonicalFile;

class AbapRepositoryImporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AbapSystemDescription abapSystemDescription;
    private final Function<EUpdateMode, SynchronousAbapExportRetriever> synchronousAbapExportRetrieverFactory;
    private final AbapRepositoryUpdater repositoryUpdater;
    private final AbapScovRestarter abapScovRestarter;

    AbapRepositoryImporter(AbapRepositoryUpdater repositoryUpdater, Function<EUpdateMode, SynchronousAbapExportRetriever> synchronousAbapExportRetrieverFactory, AbapScovRestarter abapScovRestarter, AbapSystemDescription abapSystemDescription) {
        this.abapSystemDescription = abapSystemDescription;
        this.synchronousAbapExportRetrieverFactory = synchronousAbapExportRetrieverFactory;
        this.repositoryUpdater = repositoryUpdater;
        this.abapScovRestarter = abapScovRestarter;
    }

    UpdateResult fetchAndImport(EUpdateMode updateMode, File repositoryLocation, SapConnectionStatusPersister fetchImportStatusReporter) throws StorageException, SapSystemCommunicationException {
        if (!this.abapSystemDescription.fetchFromSapSystem) {
            try {
                return this.repositoryUpdater.updateRepository(fetchImportStatusReporter);
            }
            catch (GitBridgeException e) {
                throw new StorageException("Unable to update ABAP repository at '" + String.valueOf(repositoryLocation) + "'.", (Throwable)e);
            }
        }
        try {
            UpdateResult lastResult = this.executeSynchronousUpdate(updateMode, fetchImportStatusReporter);
            if (lastResult.isCoverageDataOutdatedOrMissing()) {
                this.tryRestartScov();
            }
            return lastResult;
        }
        catch (GitBridgeException e) {
            if (updateMode == EUpdateMode.INCREMENT) {
                return this.retryWithRecoveryExport(repositoryLocation, e, fetchImportStatusReporter);
            }
            throw new StorageException("Unable to synchronize ABAP repository at '" + String.valueOf(repositoryLocation) + "' with full update.", (Throwable)e);
        }
    }

    private UpdateResult executeSynchronousUpdate(EUpdateMode updateMode, SapConnectionStatusPersister fetchImportStatusReporter) throws StorageException, GitBridgeException, SapSystemCommunicationException {
        CanonicalFile zipFile = this.fetchUpdateFromSapSystem(updateMode);
        if (zipFile == null) {
            LOGGER.info("No ABAP code changes from SAP system to update.");
            this.repositoryUpdater.cancelSynchronizations();
            fetchImportStatusReporter.setStatus(SapConnectionStatusIndex.ESapConnectionState.HEALTHY, "");
            return UpdateResult.nothingUpdated();
        }
        return this.repositoryUpdater.updateRepository(fetchImportStatusReporter);
    }

    private CanonicalFile fetchUpdateFromSapSystem(EUpdateMode updateMode) throws StorageException, SapSystemCommunicationException {
        SynchronousAbapExportRetriever retriever = this.synchronousAbapExportRetrieverFactory.apply(updateMode);
        byte[] zipContent = retriever.getZipContent();
        if (zipContent == null || zipContent.length == 0) {
            return null;
        }
        return this.repositoryUpdater.saveWorkingFile(zipContent, updateMode);
    }

    private void tryRestartScov() {
        try {
            AbapScovRestarter.ScovRestartResponse response = this.abapScovRestarter.restartScov();
            if (response.restartSuccess) {
                LOGGER.warn("Coverage data is outdated. SCOV was restarted: " + response.statusMessage);
            } else {
                LOGGER.error("Coverage data is outdated. Restarting SCOV failed: " + response.statusMessage);
            }
        }
        catch (SapSystemCommunicationException r) {
            LOGGER.error("Coverage data is outdated. Restarting SCOV failed with Exception: " + r.getMessage(), (Throwable)r);
        }
    }

    private UpdateResult retryWithRecoveryExport(File repositoryLocation, GitBridgeException e, SapConnectionStatusPersister fetchImportStatusReporter) throws StorageException, SapSystemCommunicationException {
        try {
            LOGGER.warn("Error during incremental update of ABAP repository at '" + String.valueOf(repositoryLocation) + "'. Trying to synchronize repository by requesting a full update.", (Throwable)e);
            this.repositoryUpdater.archiveOldestZip();
            return this.executeSynchronousUpdate(EUpdateMode.RECOVERY, fetchImportStatusReporter);
        }
        catch (GitBridgeException eRetry) {
            throw new StorageException("Unable to synchronize ABAP repository at '" + String.valueOf(repositoryLocation) + "' with recovery update.", (Throwable)eRetry);
        }
    }
}

