/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer.rfc;

import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.GlobalSapSystemConnectionOption;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.AbapRfcFunctionExecuterBase;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.SapSystemCommunicationException;

public class AbapScovRestarter
extends AbapRfcFunctionExecuterBase {
    private static final String RESTART_SUCCESS = "E_RESTART_SUCCESS";
    private static final String STATUS_MESSAGE = "E_STATUS_MESSAGE";

    public AbapScovRestarter(String connectionName, AbapSystemDescription abapSystemDescription, GlobalSapSystemConnectionOption globalSapOption) {
        super(connectionName, "/CQSE/RESTART_SCOV", abapSystemDescription, globalSapOption);
    }

    @Override
    protected void setImportParameters() {
    }

    public ScovRestartResponse restartScov() throws SapSystemCommunicationException {
        this.executeRfcFunction();
        boolean success = this.getBooleanExportParameter(RESTART_SUCCESS);
        String statusMessage = this.getStringExportParameter(STATUS_MESSAGE);
        return new ScovRestartResponse(success, statusMessage);
    }

    public static class ScovRestartResponse {
        public final boolean restartSuccess;
        public final String statusMessage;

        public ScovRestartResponse(boolean restartSuccess, String statusMessage) {
            this.restartSuccess = restartSuccess;
            this.statusMessage = statusMessage;
        }
    }
}

