/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer.rfc;

import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.GlobalSapSystemConnectionOption;
import com.teamscale.index.repository.sap.abapsystem.importer.EUpdateMode;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.AbapExportRfcFunctionExecutorBase;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.SapSystemCommunicationException;
import jakarta.xml.bind.DatatypeConverter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.conqat.lib.commons.string.StringUtils;

public class AsynchronousBatchJobExportScheduler
extends AbapExportRfcFunctionExecutorBase {
    private static final String IMPORT_PARAMETER_JOB_ID = "I_JOB_ID";
    private static final String EXPORT_PARAMETER_JOB_NAME = "E_JOB_NAME";
    private static final String EXPORT_PARAMETER_JOB_COUNT = "E_JOB_COUNT";
    private static final String EXPORT_PARAMETER_JOB_ERROR_MESSAGE = "E_ERROR_MESSAGE";
    private byte[] jobUnitId;

    public AsynchronousBatchJobExportScheduler(String configurationId, AbapSystemDescription abapSystemDescription, GlobalSapSystemConnectionOption globalSapOption, String exportHistoryId) {
        super(configurationId, "/CQSE/SCHEDULE_BTC_TS_EXPORT", abapSystemDescription, globalSapOption, exportHistoryId, EUpdateMode.FULL);
    }

    @Override
    protected void setImportParameters() {
        super.setImportParameters();
        this.jobUnitId = AsynchronousBatchJobExportScheduler.createJobUnitId();
        this.setImportParameter(IMPORT_PARAMETER_JOB_ID, this.jobUnitId);
    }

    private static byte[] createJobUnitId() {
        UUID uuid = UUID.randomUUID();
        byte[] uuidBytes = new byte[16];
        ByteBuffer.wrap(uuidBytes).order(ByteOrder.BIG_ENDIAN).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return uuidBytes;
    }

    public String scheduleBatchJob() throws SapSystemCommunicationException {
        this.executeRfcFunction();
        String errorMessage = this.getStringExportParameter(EXPORT_PARAMETER_JOB_ERROR_MESSAGE);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new SapSystemCommunicationException("An error occurred when trying to schedule a batch job export: " + errorMessage);
        }
        return this.getStringExportParameter(EXPORT_PARAMETER_JOB_NAME) + "-" + this.getStringExportParameter(EXPORT_PARAMETER_JOB_COUNT);
    }

    public String getJobUnitId() {
        return DatatypeConverter.printHexBinary((byte[])this.jobUnitId);
    }
}

