/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer.rfc;

import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.GlobalSapSystemConnectionOption;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.AbapRfcFunctionExecuterBase;
import com.teamscale.index.repository.sap.abapsystem.repository.AbapRepositoryUtil;
import java.io.File;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.CanonicalFile;

public class ClearHistoryIdExecuter
extends AbapRfcFunctionExecuterBase {
    private static final String JCO_DESTINATION_PREFIX = "clearLock_";
    private static final String FUNCTION_CLEAR_HISTORY_ID_LOCK = "/CQSE/CLEAR_HISTORY_ID_LOCK";
    private static final String IMPORT_PARAMETER_HISTORY_ID = "I_HISTORY_ID";
    private static final String EXPORT_PARAMTER_RETURN_CODE = "E_RETURN_CODE";
    private String sapConfigurationId;
    private ServerOptionIndex serverOptionIndex;

    public ClearHistoryIdExecuter(String sapConfiguraitonId, AbapSystemDescription abapSystemDescription, ServerOptionIndex serverOptionIndex) throws StorageException {
        super(JCO_DESTINATION_PREFIX + sapConfiguraitonId, FUNCTION_CLEAR_HISTORY_ID_LOCK, abapSystemDescription, (GlobalSapSystemConnectionOption)ServerOptionRegistry.getInstance().getServerOption("sap.abap.global", GlobalSapSystemConnectionOption.class, serverOptionIndex));
        this.sapConfigurationId = sapConfiguraitonId;
        this.serverOptionIndex = serverOptionIndex;
    }

    @Override
    protected void setImportParameters() throws ConQATException {
        String connectorIdentifier;
        CanonicalFile repositoryLocation;
        try {
            repositoryLocation = AbapRepositoryUtil.buildRepositoryLocation(this.sapConfigurationId, this.serverOptionIndex);
        }
        catch (StorageException e) {
            throw new ConQATException("Unable to determine repository location for " + this.sapConfigurationId, (Throwable)e);
        }
        if (!AbapRepositoryUtil.repositoryIdentifierExists((File)repositoryLocation)) {
            throw new ConQATException("No repository identifier file found at " + String.valueOf(repositoryLocation));
        }
        try {
            connectorIdentifier = AbapRepositoryUtil.getOrCreateConnectorIdentifier((File)repositoryLocation, this.sapConfigurationId);
        }
        catch (StorageException e) {
            throw new ConQATException("Connector Identifier cannot be read at " + String.valueOf(repositoryLocation), (Throwable)e);
        }
        this.setImportParameter(IMPORT_PARAMETER_HISTORY_ID, connectorIdentifier);
    }

    public int getReturnCode() {
        return this.getIntExportParameter(EXPORT_PARAMTER_RETURN_CODE);
    }
}

