/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer.rfc;

import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.GlobalSapSystemConnectionOption;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.SapSystemCommunicationException;
import java.io.IOException;
import org.conqat.engine.abap.jco.JcoDestinationDataProviderBase;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class JcoDestinationDataProvider
extends JcoDestinationDataProviderBase {
    private static JcoDestinationDataProvider instance;

    private JcoDestinationDataProvider() {
    }

    public static synchronized JcoDestinationDataProvider getInstance() {
        if (instance == null) {
            CCSMAssert.isFalse((boolean)Environment.isDestinationDataProviderRegistered(), (String)("No " + JcoDestinationDataProvider.class.getName() + " instance is set but the " + Environment.class.getName() + " already has a " + DestinationDataProvider.class.getName() + " registered."));
            instance = new JcoDestinationDataProvider();
            Environment.registerDestinationDataProvider((DestinationDataProvider)instance);
        }
        return instance;
    }

    public synchronized void setPropertiesFromSystemDescription(String configurationId, AbapSystemDescription systemDescription, GlobalSapSystemConnectionOption globalSapOption) throws SapSystemCommunicationException {
        if (systemDescription.isDirectConnection()) {
            this.setProperty(configurationId, "jco.client.sysnr", systemDescription.jcoSysnr);
            this.setProperty(configurationId, "jco.client.ashost", systemDescription.jcoAshost);
            this.removeProperty(configurationId, "jco.client.r3name");
            this.removeProperty(configurationId, "jco.client.group");
            this.removeProperty(configurationId, "jco.client.mshost");
            this.removeProperty(configurationId, "jco.client.msserv");
        } else {
            this.setProperty(configurationId, "jco.client.r3name", systemDescription.jcoR3Name);
            this.setProperty(configurationId, "jco.client.group", systemDescription.jcoGroup);
            this.setProperty(configurationId, "jco.client.mshost", systemDescription.jcoMshost);
            this.setProperty(configurationId, "jco.client.msserv", systemDescription.jcoMsserv);
            this.removeProperty(configurationId, "jco.client.sysnr");
            this.removeProperty(configurationId, "jco.client.ashost");
        }
        this.setProperty(configurationId, "jco.client.saprouter", systemDescription.jcoSaprouter);
        this.setProperty(configurationId, "jco.client.client", systemDescription.jcoClient);
        if (systemDescription.isPasswordLogon()) {
            this.setProperty(configurationId, "jco.client.passwd", systemDescription.jcoPasswd);
            this.setProperty(configurationId, "jco.client.user", systemDescription.jcoUser);
            this.removeProperty(configurationId, "jco.client.x509cert");
        }
        if (systemDescription.isSncEnabled) {
            this.setSncProperties(configurationId, systemDescription, globalSapOption);
        } else {
            this.setProperty(configurationId, "jco.client.snc_mode", "0");
        }
    }

    private void setSncProperties(String configurationId, AbapSystemDescription systemDescription, GlobalSapSystemConnectionOption globalSapOption) throws SapSystemCommunicationException {
        this.setProperty(configurationId, "jco.client.snc_mode", "1");
        this.setProperty(configurationId, "jco.client.snc_qop", "3");
        this.setProperty(configurationId, "jco.client.snc_myname", systemDescription.jcoSncMyname);
        this.setProperty(configurationId, "jco.client.snc_partnername", systemDescription.jcoSncPartnername);
        this.setProperty(configurationId, "jco.client.snc_lib", globalSapOption.jcoSncLibrary);
        if (systemDescription.isSsoEnabledForSnc) {
            this.setProperty(configurationId, "jco.client.snc_sso", "1");
            try {
                String x509CertificateString = systemDescription.getX509CertificateString();
                this.setProperty(configurationId, "jco.client.x509cert", x509CertificateString);
                this.removeProperty(configurationId, "jco.client.passwd");
                this.removeProperty(configurationId, "jco.client.user");
            }
            catch (IOException e) {
                throw new SapSystemCommunicationException("Cannot read X.509 certificate file", e);
            }
        } else {
            this.setProperty(configurationId, "jco.client.snc_sso", "0");
        }
    }
}

