/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer.snc;

import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.SystemUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class SncUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ABAP_SNC_CREATE_CREDENTIALS_AT_STARTUP_PROPERTY = "com.teamscale.abap.snc.create-credentials-at-startup";
    private static final String ABAP_SNC_CREDENTIALS_USER_PROPERTY = "com.teamscale.abap.snc.credentials-user";
    public static final String SAPGENPSE_EXECUTABLE_NAME = "sapgenpse";
    public static final String SECURITY_DIRECTORY_ENVIRONMENT_VARIABLE_NAME = "SECUDIR";
    public static final String SNC_LIBRARY_ENVIRONMENT_VARIABLE_NAME = "SNC_LIB";
    private static final Set<String> SAP_CRYPTO_SNC_OS_LIBRARY_NAMES = Set.of("libsapcrypto.so", "sapcrypto.dll");

    public static boolean shouldCreateCredentialsAtStartup() {
        return Boolean.getBoolean(ABAP_SNC_CREATE_CREDENTIALS_AT_STARTUP_PROPERTY);
    }

    public static String getSncServiceLibraryFromEnvVar() {
        return System.getenv(SNC_LIBRARY_ENVIRONMENT_VARIABLE_NAME);
    }

    public static String getCredentialsUser() {
        return System.getProperty(ABAP_SNC_CREDENTIALS_USER_PROPERTY, "teamscale");
    }

    public static String getSapgenpseExecutablePath(String sncServiceLibrary) {
        File sncLibFolder = new File(sncServiceLibrary).getParentFile();
        String executableName = SAPGENPSE_EXECUTABLE_NAME;
        if (SystemUtils.isWindows()) {
            executableName = "sapgenpse.exe";
        }
        File sapgenpseFile = new File(sncLibFolder, executableName);
        return sapgenpseFile.getAbsolutePath();
    }

    public static Optional<String> validateSapgenpseExecutablePath(String sapgenpsePath) {
        LOGGER.debug("ABAP SNC: Validating sapgenpse executable path: {}", (Object)sapgenpsePath);
        return SncUtils.validateSomeFile(sapgenpsePath, "ABAP SNC: sapgenpse executable path");
    }

    public static String getSecurityDirectoryFromEnvVar() {
        return System.getenv(SECURITY_DIRECTORY_ENVIRONMENT_VARIABLE_NAME);
    }

    public static Optional<String> validateSecurityDirectory(String securityDirectory) {
        LOGGER.debug("ABAP SNC: Validating security directory: {}", (Object)securityDirectory);
        if (securityDirectory == null) {
            return Optional.of("ABAP SNC: Security directory environment variable, SECUDIR, is not set.");
        }
        File pseFolder = new File(securityDirectory);
        if (!pseFolder.exists()) {
            return Optional.of("ABAP SNC: Security directory " + securityDirectory + " does not exist. This is expected to contain Personal Security Environment (PSE) files.");
        }
        if (!pseFolder.isDirectory()) {
            return Optional.of("ABAP SNC: Security directory path " + securityDirectory + " is not a folder. A correct path containing Personal Security Environment (PSE) files is needed.");
        }
        return Optional.empty();
    }

    public static boolean isSapCryptoSncOsLibrary(String serviceLibraryPath) {
        if (StringUtils.isEmpty((String)serviceLibraryPath)) {
            return false;
        }
        String normalizedLibraryName = FileSystemUtils.normalizeSeparatorsPlatformIndependently((String)serviceLibraryPath);
        String libraryName = StringUtils.getLastPart((String)normalizedLibraryName, (char)'/');
        return SAP_CRYPTO_SNC_OS_LIBRARY_NAMES.contains(libraryName);
    }

    public static Optional<String> validateServiceLibrary(String serviceLibrary) {
        LOGGER.debug("ABAP SNC: Validating service library {}", (Object)serviceLibrary);
        Optional<String> result = SncUtils.validateSomeFile(serviceLibrary, "ABAP SNC service library path");
        return result.map(s -> s + "Ensure that the library exists and its correct path is set preferably in the `SNC_LIB` system environment variable.");
    }

    public static Optional<String> validateSomeFile(String filePath, String fileInfo) {
        if (StringUtils.isEmpty((String)filePath)) {
            return Optional.of(fileInfo + " is not provided. ");
        }
        File someFile = new File(filePath.trim());
        if (!someFile.exists()) {
            return Optional.of(fileInfo + " " + filePath + " not found. ");
        }
        if (!someFile.isFile()) {
            return Optional.of(fileInfo + " " + filePath + " is not a file. ");
        }
        return Optional.empty();
    }

    private SncUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

