/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.repository.base.AccountBasedRepositoryConnectorBase;
import com.teamscale.index.repository.svn.SVNRepositoryConnection;
import com.teamscale.index.repository.svn.SvnLogCacheIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.region.RegionSet;
import org.jetbrains.annotations.VisibleForTesting;

public class SVNRepositoryConnector
extends AccountBasedRepositoryConnectorBase<SVNRepositoryConnection> {
    private static final Pattern IGNORED_REVISON_PART_PATTERN = Pattern.compile("(\\d+)(\\s*-\\s*\\d+)?");
    static final String ENABLE_EXTERNALS_PARAMETER = "enable-externals";
    static final String EXTERNALS_INCLUDE_PATTERN_PARAMETER = "externals-include-pattern";
    static final String EXTERNALS_EXCLUDE_PATTERN_PARAMETER = "externals-exclude-pattern";
    static final String BRANCHES_DIRECTORY_PARAMETER = "branches-directory";
    static final String IGNORED_REVISIONS_PARAMETER = "ignored-revisions";
    private static final List<String> DEFAULT_EXCLUDED_DIRECTORIES_IF_BRANCHING_DISABLED = Arrays.asList("tags", "branches");
    @StepParameter(value="enable-externals", optional=true)
    public boolean enableExternals = false;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    public SvnLogCacheIndex logCacheIndex;
    @StepParameter(value="externals-include-pattern", optional=true)
    private final List<String> externalsIncludePatterns = new ArrayList<String>();
    @StepParameter(value="externals-exclude-pattern", optional=true)
    private final List<String> externalsExcludePatterns = new ArrayList<String>();
    @StepParameter(value="branches-directory")
    private String branchesDirectory;
    @StepParameter(value="ignored-revisions", optional=true)
    private String ignoredRevisionsDescription;

    @Override
    protected SVNRepositoryConnection createConnection(IProfilingMonitor profilingMonitor, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        if (this.externalsIncludePatterns.isEmpty()) {
            this.externalsIncludePatterns.add("**");
        }
        if (!this.getBaseParameters().isBranchingEnabled() && this.getBaseParameters().getCodePatternSupport().getExcludePatterns().isEmpty()) {
            for (String defaultExclude : DEFAULT_EXCLUDED_DIRECTORIES_IF_BRANCHING_DISABLED) {
                this.getBaseParameters().getCodePatternSupport().addExcludePattern("**/" + defaultExclude + "/**");
            }
        }
        ExternalCredentials externalCredentials = this.getExternalCredentials();
        return new SVNRepositoryConnection(this.getBaseParameters(), this.branchesDirectory, SVNRepositoryConnector.concatenateUriAndPathSuffix(externalCredentials.uri, this.getBaseParameters().getPathSuffix()), externalCredentials.username, externalCredentials.password, this.enableExternals, new IncludeExcludeAntPatternSupport(false, this.externalsIncludePatterns, this.externalsExcludePatterns), this.logCacheIndex, SVNRepositoryConnector.parseIgnoredRevisions(this.ignoredRevisionsDescription));
    }

    @VisibleForTesting
    static RegionSet parseIgnoredRevisions(String description) throws RepositoryException {
        RegionSet result = new RegionSet();
        if (StringUtils.isEmpty((CharSequence)description)) {
            return result;
        }
        for (String part : description.split("[,;]")) {
            Matcher matcher = IGNORED_REVISON_PART_PATTERN.matcher(part.trim());
            if (!matcher.matches()) {
                throw new RepositoryException("Found invalid ignored revision description part: " + part.trim());
            }
            try {
                int lower;
                int upper = lower = Integer.parseInt(matcher.group(1));
                if (!StringUtils.isEmpty((CharSequence)matcher.group(2))) {
                    upper = Integer.parseInt(matcher.group(2).replace("-", ""));
                }
                if (lower > upper) {
                    throw new RepositoryException("Invalid ignored revision description (lower > upper): " + part.trim());
                }
                result.add(new Region(lower, upper));
            }
            catch (NumberFormatException e) {
                throw new RepositoryException("Invalid ignored revision description (invalid number): " + part.trim());
            }
        }
        return result.createCompact();
    }
}

