/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.tfs.ITfsConnection;
import com.teamscale.core.tfs.TfsConnectionFactory;
import com.teamscale.index.repository.retrievers.IFilesRetriever;
import com.teamscale.index.repository.tfs.TfsRepositoryUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public final class TfsFilesRetriever
implements IFilesRetriever {
    private final @NonNull ConnectorConfiguration connectorConfiguration;
    private final @NonNull ExternalCredentials credentials;

    public TfsFilesRetriever(@NonNull ConnectorConfiguration connectorConfiguration, @NonNull ExternalCredentials credentials) {
        this.credentials = credentials;
        this.connectorConfiguration = connectorConfiguration;
    }

    @Override
    public @NonNull Collection<@NonNull String> fetchFiles() throws RepositoryException, ProjectConfigurationException {
        try (ITfsConnection connection = TfsConnectionFactory.createWithExternalCredentials((ExternalCredentials)this.credentials);){
            String basePath = TfsFilesRetriever.getBasePathFromConnectorConfig(this.connectorConfiguration);
            List list = connection.versionControl().listFilesForRepositoryPath(basePath);
            return list;
        }
    }

    private static String getBasePathFromConnectorConfig(ConnectorConfiguration connectorConfiguration) {
        String pathSuffix = StringUtils.ensureEndsWith((String)Objects.requireNonNull(connectorConfiguration.getOptionValue("Path suffix")), (String)"/");
        String defaultBranchName = connectorConfiguration.getOptionValue("Default branch name");
        String branchPathSuffix = connectorConfiguration.getOptionValue("Branch path suffix");
        boolean nonBranchedMode = Boolean.parseBoolean(connectorConfiguration.getOptionValue("Non-branched mode"));
        return TfsRepositoryUtils.getBasePath(pathSuffix, defaultBranchName, branchPathSuffix, nonBranchedMode);
    }
}

